<!-- 
    Modul für Frage/Antwort
    Copyright (c) 2007-2017 Georg Thieme Verlag KG, Stuttgart
-->

<!--doc: Kennzeichnet eine Frage oder Fragenserie-->
<!--~~ <qa-group>
<p lang="de">Umschließendes Element für eine oder mehrere Fragen</p>
<p lang="en">Brackets one or more question-answer items</p>
~~-->
<!ELEMENT qa-group (meta?, title?, (para | figure | table| listing| formula)*, qa-item+) >
<!ATTLIST qa-group
	%id.attrib;
>

<!--doc: Frage-/Antwortblock, klammert Metadaten, Frage, Antwort, Feedback und Kommentar-->
<!--~~ <qa-item>
<p lang="de">Frage-/Antwortblock, klammert Überschrift, Frage, Antwort und Kommentar</p>
<p lang="en">Special markup for questions/answer block that brackets metadata, question, answer and comment.</p>
~~-->
<!-- weitere geplante Fragetypen: | matching | inlinechoice | textchoice | order | flashcard -->
<!ELEMENT qa-item (meta?, (title | para | listing | table | formula | figure )+, (choices | answer), hint?, feedback*) >
<!ATTLIST qa-item 
	type (single | multiple | text) #REQUIRED
	%id.attrib;
>
<!-- Für qa und qblock nicht verwendet, aber im Kontext eines Interviews -> s. kis-basic -->
<!--~~ <question>
<p lang="de">Die eigentliche Frage, bestehend aus Absätzen/Listen/Formeln/Abbildungen/Tabellen und, bei Multiple Choice, den Antwortoptionen.</p>
<p lang="en">The actual question consisting of paragraphs/lists/formulas/figures/tables and, in case of multiple choice, the options of answers.</p>
~~-->
<!ELEMENT question ((para | listing  | table | formula | figure)+, choices?) >

<!--doc: Klammert die Antwortoptionen -->
<!--~~ <choices>
<p lang="de">Klammert die Antwortoptionen </p>
<p lang="en">Brackets the answering options.</p>
~~-->
<!ELEMENT choices (choice)+ >

<!-- doc: Antwortoption-->
<!--~~ <choice>
<p lang="de"> Antwortoption</p>
<p lang="en">The options</p>
~~-->
<!-- @value: wird zukünftig nicht benötigt. -> Examen online benötigt es noch -->
<!ELEMENT choice (%inline;)* >
<!ATTLIST choice
    value (A|B|C|D|E) #IMPLIED
    type (true|false) #IMPLIED
    %id.attrib;
>

<!--doc: Bei Freitextaufgaben: komplette Antwort. -->
<!--~~ <answer>
<p lang="de">Bei Freitextaufgaben: komplette Antwort.</p>
<p lang="en">For free text interaction: complete answer.</p>
~~-->
<!ELEMENT answer (para | box | listing | table | formula | figure)+ >
<!ATTLIST answer   
	%id.attrib;
>

<!--doc: Hinweis zur Beantwortung der Frage -->
<!--~~ <hint>
<p lang="de">Hinweis, der vor Beantwortung der Frage eingeblendet werden kann.</p>
<p lang="en">Hint, shown before the question has been answered.</p>
~~-->
<!ELEMENT hint (para | box | listing | table | formula | figure)+ >
<!ATTLIST hint   
	%id.attrib;
>

<!--doc: Feedback zu ausgewählten Option. Kann sowohl ohne als auch mit @type verwendet werden. D.h. entweder wird ein allgemeines Feedback gegeben oder ein Feedback je nach der richtigen bzw. falschen Beantwortung der Frage.  -->
<!--~~ <feedback>
<p lang="de"></p>
<p lang="en"></p>
~~-->
<!ELEMENT feedback (para | box | listing | table | formula | figure)*>
<!ATTLIST feedback
    type (general | correct | incorrect) #REQUIRED
>
