<!-- 
  Basis-Elemente der KIS-DTD des Thieme Verlages
  Copyright (c) 2007-2024 Georg Thieme Verlag KG, Stuttgart
-->


<!ENTITY % inline "#PCDATA | emph | sup | sub | br | indexentry | notInFont | footnote | link | uri | target | hide ">


<!-- doc: Das Element wurde für die Printfassung eingeführt und beinhaltet ein oder mehrere Autorennamen. Das Element wird direkt unter der Kapitelüberschrift ausgegeben. Autorennamen werden auch in den Metadaten gepflegt.-->
<!--~~ <author>
<p lang="de">Das Element wurde für die Printfassung eingeführt und beinhaltet ein oder mehrere Autorennamen. Das Element wird direkt unter der Kapitelüberschrift ausgegeben.
Autorennamen werden auch in den Metadaten gepflegt.</p>
<p lang="en">The element was introduced primarily for the printed version. Author names are placed directly after the chapter heading. Author names are also recorded in the metadata section.</p>
~~-->
<!ELEMENT author (#PCDATA | notInFont | footnote)* >


<!-- doc: Definiert eine Art Vorspanntext/Teaser vor dem eigenlichen Textinhalt.-->
<!--~~ <trailer>
<p lang="de">Definiert eine Art Vorspanntext/Teaser vor dem eigenlichen Textinhalt.
Kommt vorallem in Ratgebern und Zeitschriften vor.</p>
<p lang="en">Defines a lead text before the main text starts.</p>
~~-->
<!ELEMENT trailer (%inline;)* >


<!--doc: Überschrift eines Buchteils (part), eines Kapitels (section), einer Abbildung (figure) oder einer Hervorhebung (box).-->
<!--~~ <title>
<p lang="de">Überschrift eines Buchteils (part), eines Kapitels (section), einer Abbildung (figure) oder einer Hervorhebung (box).</p>
<p lang="en">Heading of a part of a book (part), a chapter (section), an illustration (figure) or a special markup (box).</p>
~~-->
<!ELEMENT title (%inline;)* >
<!ATTLIST title
	type  CDATA #IMPLIED
	%lang.attrib;
    %id.attrib;
>


<!--  doc: Übersetzung der Überschrift (title). Vorallem in Zeitschriftenartikeln verwendet.-->
<!--~~ <titletranslated>
<p lang="de">Übersetzung der Überschrift (title). Vorallem in Zeitschriftenartikeln verwendet.</p>
<p lang="en">Translation of the title. Used mostly for articles in magazines.</p> 
~~-->
<!ELEMENT titletranslated (%inline;)* >
<!ATTLIST titletranslated
    %lang.attrib;
    %id.attrib;
>


<!--  doc: Kommt als Unterüberschrift hauptsächlich in Zeitschriftenartikeln vor.
Als Zwischenüberschrift auch in Tabellen verwendet.-->
<!--~~ <subtitle>
<p lang="de">Kommt als Unterüberschrift hauptsächlich in Zeitschriftenartikeln vor.
Als Zwischenüberschrift auch in Tabellen verwendet.</p>
<p lang="en">Appears as a subheading; mostly for articles in magazines.
As a crossheading also used within tables.</p>  
~~-->
<!ELEMENT subtitle (%inline;)* >
<!ATTLIST subtitle
    type  CDATA #IMPLIED
    %lang.attrib;
    %id.attrib;
>


<!--  doc: Übersetzung der Unterüberschrift. Vorallem in Zeitschriftenartikeln verwendet. -->
<!--~~ <subtitletranslated>
<p lang="de">Übersetzung der Unterüberschrift. Vorallem in Zeitschriftenartikeln verwendet.</p>
<p lang="en">Translation of the subtitle. Used mostly for articles in magazines. </p>
~~-->
<!ELEMENT subtitletranslated (%inline;)* >
<!ATTLIST subtitletranslated
    %lang.attrib;
    %id.attrib;
>


<!--  doc: Dieses Element umfasst eine gekürzte Überschrift (max. 50 Zeichen). Sie kann im Kolumnentitel oder im Griffregister ausgegeben werden.-->
<!--~~ <shorttitle>
<p lang="de">Dieses Element umfasst eine gekürzte Überschrift (max. 50 Zeichen). Sie kann im Kolumnentitel oder im Griffregister ausgegeben werden (3B2-templateabhängig).</p>
<p lang="en">This element comprises a shortened version of the heading (max. 50 characters) as a running head or thumb index.</p>
~~-->
<!ELEMENT shorttitle (#PCDATA | sup | sub | notInFont)* >


<!--  doc: Eine Überschrift, die zusätzlich zum normalen <title> angegeben werden kann. (eRef)-->
<!--~~ <alttitle>
<p lang="de">Eine Überschrift, die zusätzlich zum normalen `<title> angegeben werden kann. 
Vorallem in der eRef ausgegeben, wenn Überschriften nicht aussagekräftig.</p>
<p lang="en">Alternative title in addition to the `<title> element. Mostly used in eRef for further explanation.</p>
~~-->
<!ELEMENT alttitle (#PCDATA | sup | sub | notInFont)* >


<!--  doc: Zwischenüberschrift der ersten Ebene in den Sonderumgebungen Box und Container.-->
<!--~~ <header1>
<p lang="de">Zwischenüberschrift der ersten Ebene in den Sonderumgebungen Box und Container.
Besitzt eine ID, damit darauf verwiesen werden kann.</p>
<p lang="en">First-level heading in special markup `<box> and containers `<container>.
Has an ID, in order to reference on it.</p>
~~-->
<!ELEMENT header1 (%inline;)* >
<!ATTLIST header1
   %id.attrib;
>


<!--  doc: Zwischenüberschrift der zweiten Ebene in den Sonderumgebungen Box und Container.-->
<!--~~ <header2>
<p lang="de">Zwischenüberschrift der zweiten Ebene in den Sonderumgebungen Box und Container.
Besitzt eine ID, damit darauf verwiesen werden kann.</p>
<p lang="en">Second-level heading in special markup `<box> and containers `<container>.
Has an ID, in order to reference on it.</p>
~~-->
<!ELEMENT header2 (%inline;)* >
<!ATTLIST header2
    %id.attrib;
>


<!--  doc: Zwischenüberschrift der dritten Ebene in den Sonderumgebungen Box und Container.-->
<!--~~ <header3>
<p lang="de">Zwischenüberschrift der dritten Ebene in den Sonderumgebungen Box und Container.
Besitzt eine ID, damit darauf verwiesen werden kann.</p>
<p lang="en">Third-level heading in special markup `<box> and containers `<container>.
Has an ID, in order to reference on it.</p>
~~-->
<!ELEMENT header3 (%inline;)* >
<!ATTLIST header3
    %id.attrib;
>


<!--  doc: Spitzmarke erster Ebene. Keine echte Klammerung der Inhalte. Bitte sparsam einsetzen. Spitzmarken ersetzen nicht die Gliederung mittels Überschriften.-->
<!--~~ <paratitle1>
<p lang="de">Spitzmarke erster Ebene. Keine echte Klammerung der Inhalte. Bitte sparsam einsetzen. Spitzmarken ersetzen nicht die Gliederung mittels Überschriften.
Besitzt eine ID, damit darauf verwiesen werden kann.</p>
<p lang="en">First-level para title. Symbolizes no genuine nesting of content. Please use para titles sparely. Para titles are not replacing the structure via section titles.
Has an ID, in order to reference on it.</p>
~~-->
<!ELEMENT paratitle1 (%inline;| %math.qname;)* >
<!ATTLIST paratitle1
    switch (yes) #IMPLIED
    hide-level ( 1 | 2 ) #IMPLIED
    %id.attrib;
>


<!--  doc: Spitzmarke zweiter Ebene. Keine echte Klammerung der Inhalte. Bitte sparsam einsetzen. Spitzmarken ersetzen nicht die Gliederung mittels Überschriften.-->
<!--~~ <paratitle2>
<p lang="de">Spitzmarke zweiter Ebene. Keine echte Klammerung der Inhalte. Bitte sparsam einsetzen. Spitzmarken ersetzen nicht die Gliederung mittels Überschriften.
Besitzt eine ID, damit darauf verwiesen werden kann.</p>
<p lang="en">Second-level para title. Symbolizes no genuine nesting of content. Please use para titles sparely. Para titles are not replacing the structure via section titles.
Has an ID, in order to reference on it.</p>
~~-->
<!ELEMENT paratitle2 (%inline;| %math.qname;)* >
<!ATTLIST paratitle2
    switch (yes) #IMPLIED
    hide-level ( 1 | 2 ) #IMPLIED
    %id.attrib;
>


<!-- doc: Markiert einen normalen Absatz. Über das Attribut @type kann einem Absatz ein spezielles Format für Kleingedrucktes zugewiesen werden.-->
<!--~~ <para>
<p lang="de">Markiert einen normalen Absatz. Über das Attribut @type kann einem Absatz ein spezielles Format für Kleingedrucktes zugewiesen werden.<br/> 
Bedeutung von Kleingedrucktem: interessante Hintergrundinformationen – nicht prüfungsrelevant, aber wissenwert.
Formeln innerhalb eines Absatzes sind möglich (m:math). Das Element formula ist in diesem Fall nicht erforderlich.
Besitzt eine ID, damit darauf verwiesen werden kann.</p>

<p lang="en">Marks a normal paragraph. By means of the attribute @type, a special property (petit) for small printed text can be assigned to a paragraph. 
It indicates interesting background information – not relevant for the examination, but worth knowing.<br/> 
Inline formulas are possible (m:math). The element formula is not needed here. Has an ID, in order to reference on it.</p>

~~-->
<!ELEMENT para (%inline; | %math.qname; | primdoi)* >
<!ATTLIST para
    type  (petit)  #IMPLIED
    switch (yes) #IMPLIED
    hide-level ( 1 | 2 ) #IMPLIED
    %id.attrib;
>


<!--  doc: Element für die Kennzeichnung von Zitaten innerhalb eines Kapitels. Es wird zwischen dem Zitattext und dem Ursprung des Zitats (Quelle) unterschieden.-->
<!--~~ <quote>
<p lang="de">Element für die Kennzeichnung von Zitaten innerhalb eines Kapitels. Es wird zwischen dem Zitattext und dem Ursprung des Zitats (Quelle) unterschieden.
Besitzt eine ID, damit darauf verwiesen werden kann.</p>
<p lang="en">Element to markup quotations inside chapters. There is differentiation between the quoted text and the origin of the quote.
Has an ID, in order to reference on it.</p>
~~-->
<!ELEMENT quote (para+, origin?) >
<!ATTLIST quote
    %id.attrib;>
    
    
<!--  doc: Kennzeichnet den/die Ursprung/Quelle des Zitats.-->
<!--~~ <origin>
<p lang="de">Kennzeichnet den/die Ursprung/Quelle des Zitats.</p>
<p lang="en">Indicates the origin of a quote.</p>
~~-->
<!ELEMENT origin (#PCDATA | emph | sup | sub | notInFont)* >


<!--  doc: ACHTUNG: Das Element wurde bisher noch nicht aktiv verwendet. Bei Bedarf bitte beim Team Content Management melden.-->
<!--~~ <figurecollection>
 <p lang="de">Umfasst eine Bildserie, d.h. Einzeldarstellungen, die miteinander in Beziehung stehen. 
Das Attribut @type hat den Wert "sectionalanatomy" für Schnittbildserien.<br/>
ACHTUNG: Das Element wurde bisher noch nicht aktiv verwendet. Bei Bedarf bitte beim Team Content Management melden.</p>
<p lang="en">For picture-series, i.e. pictures which are standing in relation to each other. Caution: This element has not yet been used. If needed contact Team Content Management, before using it.</p>
 ~~-->
<!ELEMENT figurecollection (meta?, title?, (figure+)) >
<!ATTLIST figurecollection
   type      (sectionalanatomy)  #IMPLIED
   %id.attrib;
>

<!--  doc: Ist die Klammer für alle Multimedia-Elemente (Audio, Video, Graphic). Die Elemente dürfen innerhalb einer figure nicht gemischt vorkommen.
Ein Tableau wird für den Satz benötigt, wenn es mehrere sinnvolle und trennbare Einzelabbildungen innerhalb einer figure gibt.
Nutzen Sie counter="no", um einen Multimediacontainer von der Zählung auszunehmen. -->
<!--~~ <figure>
<p lang="de">Ist die Klammer für alle Multimedia-Elemente `<audio>, `<video>, `<graphic>. Die Elemente dürfen innerhalb einer &lt;figure> nicht gemischt vorkommen.
Ein Tableau wird für den Satz benötigt, wenn es mehrere sinnvolle und trennbare Einzelabbildungen innerhalb einer &lt;figure> gibt.
Nutzen Sie counter="no", um einen Multimediacontainer von der Zählung auszunehmen.
Besitzt eine ID, damit darauf verwiesen werden kann.</p>

<p lang="en">The element is the container for all multimedia elements `<audio>, `<video>, `<graphic>. The elements should not be mixed within one &lt;figure>.
A `<tableau> is necessary for the automatically generated PDF, if several subfigures exist and are displayed as a group of images.
Use the counter="no" in order to exclude a figure from counting.
Has an ID, in order to reference on it.</p>

~~switch
<p lang="de">Für Onlineapplikationen: Damit kann eine Section aus-/eingeblendet werden.</p>
<p lang="en">For online applications: Used to hide/show content.</p>
~~-->
<!ELEMENT figure (meta?, title?, (legend?, alttitle?, subfigure+, tableau?))>
<!ATTLIST figure
   type          CDATA  #IMPLIED
   counter       (yes | no) #IMPLIED
   number        CDATA  #IMPLIED   
   switch (yes) #IMPLIED
   hide-level ( 1 | 2 ) #IMPLIED
   %id.attrib;  
>


<!--  doc: Klammerelement eines einzelnen Multimedia-Elements (Audio, Video, Graphic).-->
<!--~~ <subfigure>
<p lang="de">Klammert jeweils eines der Multimedia-Elemente `<audio>, `<video>, `<graphic>.
Für jedes Multimedia-Element muss genau ein subfigure-Element verwendet werden.</p>
<p lang="en">This element is used generally as a container for all multimedia objects `<audio>, `<video>, `<graphic>. 
One subfigure element must be used for each multimedia element.</p>
~~-->
<!ELEMENT subfigure (meta?, keywords?, (graphic | audio | video | graphic3d), legend?) >
<!ATTLIST subfigure
   %id.attrib;
>

<!--  doc: Tableau heißt eine vorgegebene Bildkompostion mehrerer, inhaltlich zusammengehöriger Einzelabbildungen. Diese Zusammenstellung wird genau in dieser Form im 3B2-Satz verwendet. 
Für andere Medienkanäle (Epub, Online) werden die einzelnen Teilabbildungen verarbeitet. D.h. ein Tableau muss sich sinnvoll trennen lassen.-->
<!--~~ <tableau>
<p lang="de">Tableau heißt eine vorgegebene Bildkompostion mehrerer, inhaltlich zusammengehöriger Einzelabbildungen. Diese Zusammenstellung wird genau in dieser Form im 3B2-Satz verwendet. 
Für andere Medienkanäle (Epub, Online) werden die einzelnen Teilabbildungen verarbeitet. D.h. ein Tableau muss sich sinnvoll trennen lassen.
Dazu müssen alle Teilabbildungen des Tableaus in separaten `<graphic> im XML-Dokument referenziert sein.</p>
<p lang="en">This element is explicitly used for embedding groups of images as one graphic into the document. This composition is used in the 3B2-Typesetting prosess.
Other media channels (epub, online) use the single subfigures. This means a tableau needs to be separable.
Therefore each subfigure needs to be referenced in separate `<graphic> in the XML document.</p>
~~-->
<!ELEMENT tableau (graphic) >


<!-- doc: Referenziert eine Abbildung. Tragen Sie den Dateinamen in das Attribut @fileref ein.-->
<!--~~ <graphic>
<p lang="de">Referenziert eine Abbildung. Tragen Sie den Dateinamen in das Attribut @fileref ein.
Besitzt eine ID, damit darauf verwiesen werden kann.</p>
<p lang="en">References a graphic. Enter the filename in the attribute @fileref.
Has an ID, in order to reference on it.</p>

~~ size
<p lang="de">Größenangabe einer Abbildung in Stufen (xs, s, m, l, xl). Es kann nur entweder size oder sizex und sizey verwendet werden.</p>
<p lang="en">Indication of size of an image in steps (xs, s, m, l, xl). It can be only used (size) or (sizex and sizey).</p>

~~ sizex 
<p lang="de">Horizontale Größenangabe; optional.
Die Attribute sizex und sizey sollten immer zusammen verwendet werden. Sie erlauben es, die Grafik exakt zu skalieren.</p>

<p lang="en">Horicontal indication of size; optional.
Sizex and sizey should be only used together.</p>

~~ sizey 
<p lang="de">Vertikale Größenangabe; optional.
Die Attribute sizex und sizey sollten immer zusammen verwendet werden. Sie erlauben es, die Grafik exakt zu skalieren.</p>
<p lang="en">Vertical indication of size; optional.
sizex and sizey should be only used together.</p>

~~-->    
<!ELEMENT graphic EMPTY >
<!ATTLIST graphic
   fileref   CDATA  #REQUIRED
   rights  CDATA  #IMPLIED
   source  CDATA  #IMPLIED   
   position  (left | center | right) #IMPLIED
   size      (xs | s | m | l | xl) #IMPLIED 
   sizex     CDATA #IMPLIED 
   sizey     CDATA #IMPLIED 
   type ( image | graphic | scout | orientation | colorLegend ) #IMPLIED
   alt     CDATA #IMPLIED      
   %id.attrib;
>


<!--  doc: Hiermit können Zusatzinhalte in Form eines Videos eingebunden werden. Tragen Sie den Dateinamen in das Attribut @fileref ein.-->
<!--~~ <video>
<p lang="de">Hiermit können Zusatzinhalte in Form eines Videos eingebunden werden. Tragen Sie den Dateinamen in das Attribut @fileref ein.</p>
<p lang="en">This serves to incorporate videos for electronic versions in the document. Enter the filename in the attribute @fileref.</p>


~~-->
<!ELEMENT video EMPTY >
<!ATTLIST video
   fileref CDATA #REQUIRED  
   rights  CDATA  #IMPLIED
   source  CDATA  #IMPLIED   
   %id.attrib;
>


<!--  doc: Hiermit können Zusatzinhalte in Form einer Audiodatei eingebunden werden. Tragen Sie den Dateinamen in das Attribut @fileref ein.-->
<!--~~ <audio>
<p lang="de">Hiermit können Zusatzinhalte in Form einer Audiodatei eingebunden werden. Tragen Sie den Dateinamen in das Attribut @fileref ein.</p>
<p lang="en">This allows audio elements to be attached for electronic versions of the document. Enter the filename in the attribute @fileref.</p>

~~ source
<p lang="de">Quellenangaben einer Grafik, eines Videos oder einer Audiodatei.</p>
<p lang="en">Source of a graphic, video or audio.</p>

~~ rights 
<p lang="de">Rechteinhaber.</p>
<p lang="en">Holder of the rights.</p>
~~-->
<!ELEMENT audio EMPTY >
<!ATTLIST audio
   fileref CDATA #REQUIRED
   rights  CDATA  #IMPLIED
   source  CDATA  #IMPLIED   
   %id.attrib;
>


<!-- doc: Referenziert eine 3D-Abbildung.-->
<!--~~ <graphic3d>
<p lang="de">Referenziert eine 3D-Abbildung.
Besitzt eine ID, damit darauf verwiesen werden kann.</p>
<p lang="en">References a 3D graphic. Has an ID, in order to reference on it.</p>


~~-->    
<!ELEMENT graphic3d EMPTY >
<!ATTLIST graphic3d
   fileref   CDATA  #REQUIRED
   preview   CDATA  #IMPLIED
   type (presentation | model | view | tour) #REQUIRED
   alt     CDATA #IMPLIED      
   %id.attrib;
>
<!--  doc: Das Element umfasst die einzelnen Absätze einer Bildunterschrift.-->
<!--~~ <legend>
<p lang="de">Das Element umfasst die einzelnen Absätze einer Bildunterschrift.
Es sind sowohl einzelne Absätze als auch einfache Aufzählungen innerhalb der Legende zulässig.</p>
<p lang="en">The element brackets the individual paragraphs of a figure’s legend. 
Individual paragraphs as well as simple enumerations are permissible inside legends.</p>
~~-->
<!ELEMENT legend (para | simplelist)+  >


<!--  doc: Definiert eine Aufzählung. Es ist eine Verschachtelung von maximal 3 Ebenen vorgesehen und valide.
Das Attribut @type gibt die Art der Liste an: ungeordnet (dash), numerisch (num) oder mit Buchstaben (alpha). 
Per @startum legen Sie den Beginn der Listenzählung fest, falls diese nicht mit 1. oder a) beginnen. Es wird immer eine Zahl erwartet.
Buchstaben müssen auf Zahlen abgebildet werden (Startwert „e)“ entspricht „5“ weil „e“ der fünfte Buchstabe im Alphabet ist-->
<!--~~ <listing>
<p lang="de">Definiert eine Aufzählung. Es ist eine Verschachtelung von maximal 3 Ebenen vorgesehen und valide.
Das Attribut @type gibt die Art der Liste an: ungeordnet (dash), numerisch (num) oder mit Buchstaben (alpha).
Per @startum legen Sie den Beginn der Listenzählung fest, falls diese nicht mit 1. oder a) beginnen. Es wird immer eine Zahl erwartet,
Buchstaben müssen auf Zahlen abgebildet werden (Startwert „e)“ entspricht „5“ weil „e“ der fünfte Buchstabe im Alphabet ist.</p>
<p lang="en">Defines a list. It is possible to nest at most 3 levels.
The attribute @type indicates the type of list: unordered (dash), numeric (num) or alphabetical (alpha).
With @startum the beginning of the counting gets defined.
If automatically numbered lists are not supposed to start with 1. or a), any starting value desired can be specified here. 
A number is always expected; letters must be mapped onto numbers (starting value “e” corresponds to “5”), because E is the fifth letter in the alphabet.</p>


~~ type
<p lang="de">Das Attribut @type gibt die Art der Liste an: ungeordnet (dash), numerisch (num) oder mit Buchstaben (alpha).</p>
<p lang="en">The attribute @type indicates the type of list: unordered (dash), numeric (num) or alphabetical (alpha).</p>

~~ startum
<p lang="de">Per @startum legen Sie den Beginn der Listenzählung fest, falls diese nicht mit 1. oder a) beginnen. Es wird immer eine Zahl erwartet,
Buchstaben müssen auf Zahlen abgebildet werden (Startwert „e)“ entspricht „5“ weil „e“ der fünfte Buchstabe im Alphabet ist.</p>
<p lang="en">With @startum the beginning of the counting gets defined.
If automatically numbered lists are not supposed to start with 1. or a), any starting value desired can be specified here. 
A number is always expected; letters must be mapped onto numbers (starting value “e” corresponds to “5”), because E is the fifth letter in the alphabet.</p>
~~-->


<!ELEMENT listing (litem)+ >
<!ATTLIST listing 
    type (alpha | dash | num) "dash"
    startnum  CDATA #IMPLIED
    switch (yes) #IMPLIED
    hide-level ( 1 | 2 ) #IMPLIED
>


<!--  doc: Ein Aufzählungspunkt einer Liste. Er enthält mindestens einen Absatz und bei verschachtelten Listen auch eine weitere Liste.-->
<!--~~ <litem>
<p lang="de">Ein Aufzählungspunkt einer Liste. Er enthält mindestens einen Absatz und bei verschachtelten Listen auch eine weitere Liste.</p>
<p lang="en">Represents an item in a list. It contains at least one paragraph, and in the case of nested lists, one additional list.</p>
~~-->
<!ELEMENT litem (para | box | figure | table | listing)* >
<!ATTLIST litem
   type   (special) #IMPLIED
>


<!--  doc: Dieses Element wird nur in Abbildungslegenden für einfache und kurze Aufzählungen benutzt.-->
<!--~~ <simplelist>
<p lang="de">Dieses Element wird nur in Abbildungslegenden für einfache und kurze Aufzählungen benutzt. 
Die Attribute @type und @startnum verhalten sich wie bei normalen Listen</p>
<p lang="en">The element is only used inside figure legends for short and simple enumerations.
The attributs @type and @startnum act the same as in normal lists.</p>
~~-->
<!ELEMENT simplelist (simplelitem)+ >
<!ATTLIST simplelist 
    type (alpha | dash | num ) "dash"
    startnum  CDATA #IMPLIED
>


<!--  doc: Ein Aufzählungspunkt in "einfachen" Listen innerhalb von Abbildungslegenden. Die Liste hat nur eine Ebene und besteht nur aus Absätzen.-->
<!--~~ <simpleitem>
 
<p lang="de">Ein Aufzählungspunkt in "einfachen" Listen innerhalb von Abbildungslegenden. Die Liste hat nur eine Ebene und besteht nur aus Absätzen.</p>
<p lang="en">The element represents an item in a simple list. The list has only one level and consists only of paragraphs.</p>
~~-->
<!ELEMENT simplelitem (para)+ >
<!ATTLIST simplelitem
   type   (special) #IMPLIED
>


<!--  doc: Dieses Element dient der Auszeichnung eines Abkürzungsverzeichnisses oder eines Glossars. Es umfasst die Abkürzung, den ausgeschriebenen Begriff und eine optionale Erklärung des Begriffs.
Dadurch lässt es sich auch als Glossar verwenden. Die Verwendung für das ein oder andere wird im Attribut @type festgelegt.-->
<!--~~ <definitionlist>
<p lang="de">Dieses Element dient der Auszeichnung eines Abkürzungsverzeichnisses oder eines Glossars. Es umfasst die Abkürzung, den ausgeschriebenen Begriff und eine optionale Erklärung des Begriffs.
Dadurch lässt es sich auch als Glossar verwenden. Die Verwendung für das ein oder andere wird im Attribut @type festgelegt.
Besitzt eine ID, damit darauf verwiesen werden kann.</p>
<p lang="en">This element serves as the markup of abbreviation lists or glossarys. It contains the abbreviation, the term and its optional explanation. 
Thus it can be used as a glossary, too. The usage is defined via the attribute @type.
Has an ID, in order to reference on it.</p>


~~type
<p lang="de">Die Verwendung als Abkürzungsverzeichnis oder als Glossar wird im Attribut @type festgelegt.</p>
<p lang="en">The usage as a abbrevation list or as a glossary gets defined via the attribute @type.</p>
~~-->

<!ELEMENT definitionlist (definitionitem+) >
<!ATTLIST definitionlist 
   type (abbreviation | glossary) #IMPLIED
   %id.attrib;
>


<!-- doc: Das Element klammert jeweils eine komplette Abkürzung und Erklärung innerhalb der Abkürzungsliste.-->
<!--~~ <definitionitem>
<p lang="de">Das Element klammert jeweils eine komplette Abkürzung und Erklärung innerhalb der Abkürzungsliste.
Besitzt eine ID, damit darauf verwiesen werden kann.</p>
<p lang="en">The element brackets the complete abbreviation and definition within a list of abbreviations.
Has an ID, in order to reference on it.</p>
~~-->
<!ELEMENT definitionitem (abbrev?, term+, definition?) >
<!ATTLIST definitionitem
	%lang.attrib;
	%id.attrib;
>


<!--  doc: Beinhaltet die abgekürzte Schreibweise eines Begriffs im Abkürzungsverzeichnis.-->
<!--~~ <abbrev>
<p lang="de">Beinhaltet die abgekürzte Schreibweise eines Begriffs im Abkürzungsverzeichnis.
Besitzt eine ID, damit darauf verwiesen werden kann.</p>
<p lang="en">Contains the abbreviated spelling inside a list of abbreviations.
Has an ID, in order to reference on it.</p>
~~-->
<!ELEMENT abbrev (%inline;| %math.qname;)*>
<!ATTLIST abbrev 
    %lang.attrib;
	%id.attrib;
>


<!--  doc: Ausgeschriebener Begriff einer Abkürzung im Abkürzungsverzeichnis.-->
<!--~~ <term>
<p lang="de">Ausgeschriebener Begriff einer Abkürzung im Abkürzungsverzeichnis.
Besitzt eine ID, damit darauf verwiesen werden kann.</p>
<p lang="en">Containes the abbreviation in full in the list of abbreviations.
Has an ID, in order to reference on it.</p>
~~-->
<!ELEMENT term (%inline;| %math.qname;)*>
<!ATTLIST term 
    %lang.attrib;
    %id.attrib;
>


<!--  doc: Dient der weiterführenden Erklärung eines Begriffs, oftmals in Verbindung mit einem Glossar.-->
<!--~~ <definition>
<p lang="de">Dient der weiterführenden Erklärung eines Begriffs, oftmals in Verbindung mit einem Glossar.
Besitzt eine ID, damit darauf verwiesen werden kann.</p>
<p lang="en">This element is optional and provides a further explanation of the term within a list of abbreviations.
Has an ID, in order to reference on it.</p>
~~-->
<!ELEMENT definition (%inline;| %math.qname;)*>
<!ATTLIST definition
	%lang.attrib;
    %id.attrib;
>


<!--  doc: Als Box wird eine auffällige Hervorhebung im Text bezeichnet. Jede Box erhält entsprechend ihrer didaktischen Bedeutung eine unterschiedliche Auszeichnung (Attribut @type).-->
<!--~~ <box>
<p lang="de">Als Box wird eine auffällige Hervorhebung im Text bezeichnet. Jede Box erhält entsprechend ihrer didaktischen Bedeutung eine unterschiedliche Auszeichnung (Attribut @type).
Die Bedeutung der einzelnen Werte entnehmen Sie bitte der Redaktionsrichtlinie/TReX-Anleitung bzw. dem  <a href="http://wiki.l42.net/Thieme/3._XML-Bearbeitung/Boxen">Wiki</a>.
Für Sonderumgebungen wurden die Überschriften `<header1> bis `<header3> definiert, wobei `<header3> auf Grund von `<title> nicht mehr benutzt werden sollte.
Das Attribut @size mit dem Wert "l" kennzeichnet besonders große Hervorhebungen, die im Layout über zwei Spalten gehen sollen.
Besitzt eine ID, damit darauf verwiesen werden kann.</p>
<p lang="en">Defines a special markup in the text. Every box holds a different type according to the didactical meaning of the box (attribute @type). The meaning of box types can be withdrawn from the editors manual/TReX manual or 
<a href="http://wiki.l42.net/Thieme/3._XML-Bearbeitung/Boxen">Wiki</a>. For special markup, the headings `<header1> to `<header3> have been defined, whereas `<header3> should not be used anymore because of the presence of `<title>.
The attribute @size with the value "l" indicates that the box covers 2 columns in print layout. Has an ID, in order to reference on it.</p>

~~ type
<p lang="de">Jede Box erhält entsprechend ihrer didaktischen Bedeutung eine unterschiedliche Auszeichnung. Diese Bedeutung wird im Attribut @type zugewiesen. Die Bedeutung der unterschiedlichen Typen kann von der TReX-Anleitung oder im Wiki unter Wiki abgeleitet werden. Vita von Personen werden in eine Box vom Typ Vita abgebildet.</p>
<p lang="en">Every box holds a different type according to the didactical meaning of the box. This meaning is assigned in the attribute @type The meaning of box types can be withdrawn from the editors manual/TReX manual or Wiki. The new type='vita' allows a persons vita to be emphasized.</p>

~~ size
<p lang="de">Das Attribut @size mit dem Wert "l" kennzeichnet besonders große Hervorhebungen, die im Layout über zwei Spalten gehen sollen.</p>
<p lang="en">The attribute @size with the value "l" indicates that the box covers 2 columns in print layout.</p>
~~-->

<!ELEMENT box (title?, (para | figure | table | formula | header1 | header2 | header3 | listing)+)>
<!ATTLIST box
    type   (remember | caution | definition | summary | profile | exam | addition | practical | therapy | symptome | casestudy | technique | guideline | pitfall | raffle| background | pullquote | comment | other | vita)  #REQUIRED
    size (l) #IMPLIED
    switch (yes) #IMPLIED
    hide-level ( 1 | 2 ) #IMPLIED
    %id.attrib;
>


<!--  doc: Zeichnet eine Marginalie aus. Marginalien sind Randbemerkungen. Das bedeutet, sie sind kurz und prägnant, weil sie wenig Platz in Anspruch nehmen dürfen. 
Im Normalfall enthält eine Marginalie genau einen Absatz, maximal noch eine Spitzmarke und eine Aufzählung.-->
<!--~~ <marg>
<p lang="de">Zeichnet eine Marginalie aus. Marginalien sind Randbemerkungen. Das bedeutet, sie sind kurz und prägnant, weil sie wenig Platz in Anspruch nehmen dürfen. 
Im Normalfall enthält eine Marginalie genau einen Absatz, maximal noch eine Spitzmarke und eine Aufzählung.
Besitzt eine ID, damit darauf verwiesen werden kann.</p>
<p lang="en">Defines a marginal note. Marginal notes are short and concise, because they must not take up much space. 
Normally, a marginal note contains just one paragraph, and at most a paratitle and an enumeration.
Has an ID, in order to reference on it.</p>
~~-->
<!ELEMENT marg (paratitle1 | para | listing)* >
<!ATTLIST marg
    %id.attrib;
>


<!-- doc: Gespräch zwischen zwei und mehr Personen. Mehrere Antworten pro Frage sind möglich. -->
<!--~~ <interview>
<p lang="de">Gespräch zwischen zwei und mehr Personen. Mehrere Antworten pro Frage sind möglich.</p>
<p lang="en">Interview between two or more people. There can be more than one answer per question.</p>
~~-->
<!ELEMENT interview (question, (answer+))+ >


<!--  doc: Mit dem Element wird ein Formelabsatz, meist mit Formelzähler, gekennzeichnet. Das Element ist vor allem dann sinnvoll, wenn Formeln anders dargestellt
oder besonders hervorgehoben werden müssen. Es bietet darüber hinaus die Möglichkeit, Formeln einzubinden, die nur als Grafik vorliegen, wie beispielsweise chemische Formeln.-->
<!--~~ <formula>
<p lang="de">Mit dem Element wird ein Formelabsatz, meist mit Formelzähler, gekennzeichnet. Das Element ist vor allem dann sinnvoll, wenn Formeln anders dargestellt
oder besonders hervorgehoben werden müssen. Es bietet darüber hinaus die Möglichkeit, Formeln einzubinden, die nur als Grafik vorliegen, wie beispielsweise chemische Formeln.
Die Zählung von Formeln wird über das Attribut „counter“ gesteuert.
Mathematische Formeln können auch direkt im Text ohne &lt;formula> verwendet werden. Siehe `<m:math>. Besitzt eine ID, damit darauf verwiesen werden kann.</p>
<p lang="en">The element is used to identify a paragraph that contains a formula. The element is mainly useful if formula have to be represented differently or specially emphasized. 
It also permits incorporating formulas that are only available as graphics, such as chemical formulas.
The counting of formulas is controlled by the attribute “counter”, which replaces the element counter.
Mathematical formulas can also be used directly inside a paragraph without &lt;formula>. See `<m:math>. Has an ID, in order to reference on it.</p>

~~-->
<!ELEMENT formula (%inline; | %math.qname; | graphic )* >
<!ATTLIST formula
    counter (yes | no) #IMPLIED
    type (math | chem | calc) #IMPLIED
    switch (yes) #IMPLIED
    hide-level ( 1 | 2 ) #IMPLIED
    %id.attrib;  
>

<!--  doc: Tabellenaufbau gemäß dem XHTML-Modell. Tabellen werden unterteilt in `<thead>, `<tbody> und `<tfoot> formatiert.-->
<!--~~ <table>
<p lang="de">Tabellenaufbau gemäß dem XHTML-Modell. Tabellen werden unterteilt in `<thead>, `<tbody> und `<tfoot> formatiert.
Eine Thieme-spezifisch Ergänzung sind die Attribute @counter und @size</p>
<p lang="en">Table, corresponding to the XHTML model. Tables are subdivided into `<thead>, `<tbody> and `<tfoot>. 
An Thieme specific addition are the attributes @counter and @size.</p>

~~ id
<p lang="de">Eindeutiger Bezeichner; optional.
Erlaubt es auf eine Tabelle zu verweisen.</p>
<p lang="en">Unique identifier; optional.
Permits a reference onto a table.</p>

~~ type
<p lang="de">Beliebiger Text; optional.
Ermöglicht eine zusätzliche Qualifizierung.</p>
<p lang="en">Arbitrary text; optional.
Permits an additional qualification.</p>

~~ align
<p lang="de">Festgelegte Werte; optional.
Gibt die Ausrichtung der Tabelle im Satzspiegel an, wenn sie schmaler ist als derselbe. Mögliche Werte sind links (left), mittig (center) und rechts (right).</p>
<p lang="en">Fixed values; optional.
Specifies the alignment of the table on the type page, if it is smaller than the latter. Possible values: “left”, “center”, and “right”.</p>

~~ border
<p lang="de">Beliebiger Text; optional.
Spezifiziert die Linienstärke der Tabellenumrandung.</p>
<p lang="en">Arbitrary text; optional.
Specifies the line width of the table border.</p>

~~ bgcolor
<p lang="de">Beliebiger Text; optional.
Hintergrundfarbe der gesamten Tabelle.</p>
<p lang="en">Arbitrary text; optional.
Background color of the entire table.</p>

~~ cellpadding
<p lang="de">Beliebiger Text; optional.
Abstand zwischen dem Zellenrahmen und dem enthaltenen Text. Der Wert ist für alle 4 Seiten gleich.</p>
<p lang="en">Arbitrary text; optional.
Space between the frame of a table cell and the text it contains. The value is the same for all four sides.</p>

~~ cellspacing
<p lang="de">Beliebiger Text; optional.
Abstand zwischen den Tabellenzellen (wird nicht verwendet).</p>
<p lang="en">Arbitrary text; optional.
Space between the table cells (is not used).</p>

~~ frame
<p lang="de">Festgelegte Werte; optional.
Zellenseiten an denen die Tabellenumrandung dargestellt wird.</p>
<p lang="en">Fixed values; optional.
Sides of the cell at which the table border is shown.</p>

~~ rules
<p lang="de">Festgelegte Werte; optional.
Legt fest, welche Linien innerhalb der Tabelle dargestellt werden, nur horizontale Linien (rows), nur vertikale Linien (cols) alle Linien (all).</p>
<p lang="en">Fixed values; optional.
Specifies which lines are shown within the table: only horizontal lines (rows), only vertical ones (cols), or all (all).</p>

~~ width
<p lang="de">Beliebiger Text; optional.
Gibt normalerweise die Breite der Tabelle oder Spalte in absoluten (z. B. 125 px) oder relativen (z. B. 100%) Werten an.</p> 
<p lang="en">Arbitrary text; optional.
Normally specifies the width of the table or column in absolute (e.g. 125 px) or relative (e.g. 100%) values.</p>

~~ size
<p lang="de">Feste Auswahl; optional.
Wird in Verbindung mit der TReX-Formatvorlage für die festgelegten Werte „s“, „m“, „l“ und „xl“ benutzt (für 1, 1½, 2 spaltig und >100% Satzspiegel).</p>
<p lang="en">Fixed values; optional.
In connection with the TReX template, it is used for the fixed values “s”, “m”, “l” and “xl” (for one, over one, two columns and > 100% type area).</p>


~~-->
<!ELEMENT table    (meta?, caption?, (colgroup? | col*), thead?, tbody, tfoot?) >
<!ATTLIST table    
    align        (left|center|right)         #IMPLIED
    border       CDATA                       #IMPLIED
    bgcolor      CDATA                       #IMPLIED
    cellpadding  CDATA                       #IMPLIED
    cellspacing  CDATA                       #IMPLIED
    frame        (void|above|below|hsides|lhs|rhs|vsides|box|border) #IMPLIED
    rules        (none|groups|rows|cols|all) #IMPLIED
    width        CDATA                      #IMPLIED
    size         (s | m | l | xl )           #IMPLIED    
    counter       (yes | no) #IMPLIED
    switch (yes) #IMPLIED
    hide-level ( 1 | 2 ) #IMPLIED
    type  CDATA #IMPLIED
    %id.attrib;
>


<!--  doc: Zeichnet die Tabellenüberschrift aus. -->
<!--~~ <caption>
<p lang="de">Zeichnet die Tabellenüberschrift aus.</p>
<p lang="en">Heading of a table.</p>

~~ align
<p lang="de">Mögliche Werte top, bottom, left, right; optional.
Gibt die horizontale Textausrichtung an.</p>
<p lang="en">Possible values: top, bottom, left, right; optional.
Specifies the horizontal text alignment.</p>
~~-->
<!ELEMENT caption    (%inline;)* >
<!ATTLIST caption    align  (top|bottom|left|right)        #IMPLIED
>


<!--  doc: Dieses Element klammert alle <col>-Elemente. Darin ist die  Spaltenanzahl festgelegt. Die Anzahl der col-Elemente muss mit der tatsächlichen Anzahl von `<td> Elementen pro Zeile übereinstimmen. -->
<!--~~ <colgroup>
<p lang="de">Dieses Element klammert alle `<col>-Elemente. Darin ist die Spaltenanzahl festgelegt. Die Anzahl der col-Elemente muss mit der tatsächlichen Anzahl von `<td> Elementen pro Zeile übereinstimmen.</p>
<p lang="en">This element brackets all `<col> elements. Therein the number of columns is determined. The number of col elements must be equal to the number of `<td> elements for each table row.</p>

~~ align 
<p lang="de">Mögliche Werte left, center, right, justify, char; optional.</p>
<p lang="en">Possible values: left, center, right, justify, char; optional.</p>

~~ valign 
<p lang="de">Mögliche Werte top, middle, bottom, baseline; optional.  Vorgabe für die vertikale Ausrichtung in der Tabellenspalte und Tabellenzellen.
</p>
<p lang="en">Possible values: top, middle, bottom, baseline; optional. Specification of the vertical alignment in the table column or cell.

</p>


~~-->
<!ELEMENT colgroup (col)+ >
<!ATTLIST colgroup
    align   (left|center|right|justify|char) #IMPLIED
    valign  (top|middle|bottom|baseline)     #IMPLIED
    width   CDATA                            #IMPLIED
>


<!-- doc: Definiert in Tabellen die Breite einer Spalte. Dafür wird nur das Attribut „width“ verwendet. Als Werte sind nur Zahlen mit den optionalen Einheiten %, px oder pt erlaubt.-->
<!--~~ <col>
<p lang="de">Definiert in Tabellen die Breite einer Spalte. Dafür wird nur das Attribut „width“ verwendet. Als Werte sind nur Zahlen mit den optionalen Einheiten %, px oder pt erlaubt. Dieses Element wird vom eFlow nicht zwingend benötigt, evtl. aber von anderen Prozessen. Wird als optionales Element beibehalten.</p>
<p lang="en">Defines the width of a column for a table. Only the attribute “width” is used for this. As  values only numbers with the optional units %, px or pt are allowed. This element is not required by eFlow, but may be required by other processes. It is an optional element.</p>

~~ align
<p lang="de">Mögliche Werte left, center, right, justify, char; optional.
Vorgabe für die horizontale Ausrichtung in der Tabellenspalte.</p>
<p lang="en">Possible values: left, center, right, justify, char; optional.
Specification of the horizontal alignment in the table column.</p>




~~-->
<!ELEMENT col    EMPTY >
<!ATTLIST col
    align   (left|center|right|justify|char) #IMPLIED
    valign  (top|middle|bottom|baseline)     #IMPLIED
    width   CDATA                            #REQUIRED
>


<!--  doc: Tabellenkopf. Er wiederholt sich beim Seitenumbruch auf jeder Seite.-->
<!--~~ <thead>
<p lang="de">Tabellenkopf. Er wiederholt sich beim Seitenumbruch auf jeder Seite.</p>
<p lang="en">Table header. Is repeated on each page after page breaks.</p>

~~ align
<p lang="de">Festgelegte Werte; optional.
Vorgabe für die horizontale Ausrichtung aller Tabellenzellen.</p>
<p lang="en">Fixed values; optional.
Specification of the horizontal alignment of all table cells.</p>


~~-->
<!ELEMENT thead  (tr)+ >
<!ATTLIST thead  
    align    (left|center|right|justify|char) #IMPLIED
    valign   (top|middle|bottom|baseline)     #IMPLIED
>


<!--  doc: Tabelleninhalt. Umfasst alles außer dem Tabellenkopf und -fuß.-->
<!--~~ <tbody>
<p lang="de">Tabelleninhalt. Umfasst alles außer dem Tabellenkopf und -fuß.</p>
<p lang="en">Main part of a table, comprising everything except the table header and footer.</p>

~~ align
<p lang="de">Festgelegte Werte; optional.
Vorgabe für die horizontale Ausrichtung aller Tabellenzellen.</p>
<p lang="en">Fixed values; optional.
Specification of the horizontal alignment of all table cells.</p>

~~-->
<!ELEMENT tbody  (tr)+ >
<!ATTLIST tbody  
    align    (left|center|right|justify|char) #IMPLIED
    valign   (top|middle|bottom|baseline)     #IMPLIED
>


<!--  doc: Tabellenfuß. Er wird üblicherweise für Tabellenfußnoten und sonstige Anmerkungen zur Tabelle verwendet. Wiederholt sich beim Seitenumbruch auf jeder Seite.-->
<!--~~ <tfoot>
<p lang="de">Tabellenfuß. Er wird üblicherweise für Tabellenfußnoten und sonstige Anmerkungen zur Tabelle verwendet. Wiederholt sich beim Seitenumbruch auf jeder Seite.</p>
<p lang="en">Table footer. Is usually used for table footnotes and other remarks about the table; is repeated on each page after page breaks.</p>

~ align
<p lang="de">Festgelegte Werte; optional.
Vorgabe für die horizontale Ausrichtung aller Tabellenzellen.</p>
<p lang="en">Fixed values; optional.
Specification of the horizontal alignment of all table cells.</p>


~~-->
<!ELEMENT tfoot  (tr)+ >
<!ATTLIST tfoot  
    align    (left|center|right|justify|char) #IMPLIED
    valign   (top|middle|bottom|baseline)     #IMPLIED
>


<!--  doc: Kennzeichnet eine Tabellenzeile. Eine Zeile besteht aus mehreren Zellen `<td>.-->
<!--~~ <tr>
<p lang="de">Kennzeichnet eine Tabellenzeile. Eine Zeile besteht aus mehreren Zellen `<td>.</p>
<p lang="en">Defines a table row. One row is composed of several cells.</p>

~ align
<p lang="de">Festgelegte Werte; optional.
Vorgabe für die horizontale Ausrichtung aller Tabellenzellen.</p>
<p lang="en">Fixed values; optional.
Specification of the horizontal alignment of all table cells.</p>


~~-->
<!ELEMENT tr     (td | th)+ >
<!ATTLIST tr     
    align    (left|center|right|justify|char) #IMPLIED
    bgcolor  CDATA                            #IMPLIED
    valign   (top|middle|bottom|baseline)     #IMPLIED
>


<!--  doc: Tabellenzelle (Abkürzung für table data). In einer Zelle sind Aufzählungen, Abbildungen (ohne Legende und Zähler) und Formeln möglich.
Für Tabellenzwischenüberschriften muss `<subtitle> benutzt werden. Zusätzlich muss @colspan über alle Zellen gesetzt sein.-->
<!--~~ <td>
<p lang="de">Tabellenzelle (Abkürzung für table data). In einer Zelle sind Aufzählungen, Abbildungen (ohne Legende und Zähler) und Formeln möglich.
Für Tabellenzwischenüberschriften muss `<subtitle> benutzt werden. Zusätzlich muss @colspan über alle Zellen gesetzt sein. Die Angabe colspan="2" bedeutet, dass zwei Spalten miteinander verbunden sind; 
colspan="1" muss nicht eingetragen werden, weil das der Standard ist.</p>
<p lang="en">Table cell (abbreviation for “table data”). A table cell may contains enumerations, illustrations (without legend and counting) and formulas. 
Use `<subtitle> to receive a table subheading. In addition the @colspan must be set across all table cells in a row. The declaration colspan="2" means that 2 columns are merged; colspan="1" doesn't have to be specified, 
because it is the default.</p>

~~ align
<p lang="de">Festgelegte Werte; optional.
Vorgabe für die horizontale Ausrichtung der Tabellenzelle.</p>
<p lang="en">Fixed values; optional.
Specification of the horizontal alignment of the table cell.</p>


~~ colspan
<p lang="de">Ganzzahliger Wert; optional.
Anzahl der Spalten, die die Tabellenzelle überspannt. Die Angabe colspan="2" bedeutet, dass zwei Spalten miteinander verbunden sind; 
colspan="1" muss nicht eingetragen werden, weil das der Standard ist.</p>
<p lang="en">(whole number; optional)
Number of columns which the table cell spans. The declaration colspan="2" means that 2 columns are merged; colspan="1" doesn't have to be specified, 
because it is the default.</p>

~~ rowspan 
<p lang="de">Ganzzahliger Wert; optional.
Anzahl der Reihen, die die Tabellenzelle überspannen. (s. colspan)</p>
<p lang="en">Whole number; optional.
Number of rows which the table cell span. (l. colspan)</p>


~~-->
<!ELEMENT td     (para | listing | subtitle | formula | figure)* >
<!ATTLIST td     
    align    (left|center|right|justify|char) #IMPLIED
    bgcolor  CDATA                            #IMPLIED
    colspan  NMTOKEN                          #IMPLIED
    rowspan  NMTOKEN                          #IMPLIED
    valign   (top|middle|bottom|baseline)     #IMPLIED
    width    CDATA                            #IMPLIED
>


<!--  doc: Das Element wird zur Auszeichnung eines vertikalen Tabellenkopfes benutzt und ist immer die erste Spalte. -->
<!--~~ <th>
<p lang="de">Das Element wird zur Auszeichnung eines vertikalen Tabellenkopfes benutzt und ist immer die erste Spalte.</p>
<p lang="en">The element is used to markup a vertical table header and it is always the first column.</p>

~~-->
<!ELEMENT th     (para | figure)* >
<!ATTLIST th     
    align    (left|center|right|justify|char) #IMPLIED
    bgcolor  CDATA                            #IMPLIED
    colspan  NMTOKEN                          #IMPLIED
    rowspan  NMTOKEN                          #IMPLIED
    valign   (top|middle|bottom|baseline)     #IMPLIED
    width    CDATA                            #IMPLIED
>


<!--  doc: Einfache Literaturangabe ohne zusätzliche Strukturierung wie in `<litref>. Für deutschsprachige Bücher wird bisher ausschließlich &lt;literature> benutzt.-->
<!--~~ <literature>
<p lang="de">Einfache Literaturangabe ohne zusätzliche Strukturierung wie in `<litref>. Für deutschsprachige Bücher wird bisher ausschließlich &lt;literature> benutzt.</p>
<p lang="en">Simple bibliographical reference, without additional structuring as in `<litref>. For German books only &lt;literature> is used.</p>

~~-->
<!ELEMENT literature (%inline;)* >
<!ATTLIST literature
          %id.attrib; 
>


<!-- doc: Das Element <emph> markiert eine Hervorhebung im Text mit den möglichen Auszeichnungen fett (bold), kursiv (italic), gesperrt (space), farbig (special), hinterlegt (marker) und unterstrichen (under).
Der spezielle Wert "switch" heißt, dass der Textinhalt ausgeblendet werden kann. Die Verwendung ist den Onlineprojekten vorbehalten.-->
<!--~~ <emph>
<p lang="de">Das Element &lt;emph> markiert eine Hervorhebung im Text mit den möglichen Auszeichnungen fett (bold), kursiv (italic), gesperrt (space), farbig (special), hinterlegt (marker) und unterstrichen (under).
Der Wert "switch" heißt, dass der Textinhalt ausgeblendet werden kann. Die Verwendung ist den Onlineprojekten vorbehalten.</p>
<p lang="en">The element &lt;emph> marks an emphasis in the text, with the possible types "bold", "italic", "space" (letterspaced), "special" (colored), "marker" (highlighted) and "under" (underlined). 
The value “switch” means that the content is hidden and is only used in online applications.</p>

~~ type
<p lang="de">Festgelegte Werte für Textgestaltung; erforderlich.</p>
<p lang="en">Defined values for text design; required.</p>
~~-->
<!ELEMENT emph (%inline;)* >
<!ATTLIST emph
    type (bold | italic | space | under | special | sc | marker | switch) #REQUIRED
>

<!-- doc: Das Element <hide> kennzeichnet Inhalte, die per Applikationslogik ausgeblendet werden können.
Dieses Element/Attribut wurde mit v3.2 der DTD für via medici eingeführt. Der Usecase ist die Reduktion längerer Texte durch einen Nutzer zu einer verkürzten Schnelllesespur oder einem Skript.-->
<!--~~ <hide>
<p lang="de">Das Element &lt;hide> und das Attribut hide-level kennzeichnen Inhalte, die sich per Applikationslogik ausblenden lassen.
Dieses Element/Attribut wurde mit v3.2 der DTD für via medici eingeführt. Der Usecase ist die Reduktion längerer Texte durch einen Nutzer zu einer verkürzten Schnelllesespur oder einem Skript.</p>
<p lang="en">The element &lt;hide> and the attribute hide-level mark content, that can be hidden only by the application itself.
The element/attribute hat been inplemented in the DTD v3.2. The use case is the reduction of a long text version to a fast track version or a script.</p>

~~ level
<p lang="de">Festgelegte Werte; erforderlich.</p>
<p lang="en">Defined values; required.</p>
~~-->
<!ELEMENT hide (%inline;)*>
<!ATTLIST hide
	level ( 1 | 2 ) #REQUIRED
>
	
	
<!--  doc: Markiert tiefgestellten Text. Wird typischerweise in chemischen Formeln benutzt.-->
<!--~~ <sub>
<p lang="de">Markiert tiefgestellten Text. Wird typischerweise in chemischen Formeln benutzt.</p>
<p lang="en">Marks subscripted text, typically for expressions in chemical formulas.</p>
~~-->
<!ELEMENT sub (#PCDATA | emph | sub | sup | notInFont)* >


<!-- doc: Markiert hochgestellten Text. Wird typischerweise in chemischen Formeln benutzt.-->
<!--~~ <sup>
<p lang="de">Markiert hochgestellten Text. Wird typischerweise in chemischen Formeln benutzt.</p>
<p lang="en">Marks superscripted text, typically for expressions in chemical formulas.</p>
~~-->
<!ELEMENT sup (#PCDATA | emph | sub | sup | notInFont)* >


<!--  doc: Es handelt sich um einen Softreturn.-->
<!--~~ <br>
<p lang="de">Es handelt sich um einen Softreturn.</p>
<p lang="en">Defines a soft return.</p>
~~-->
<!ELEMENT br EMPTY >


<!--  doc: Das Element <notInFont> markiert Zeichen, die nicht in den Thieme Schriften „Thieme Argo 2011“ und „Thieme Gulliver 2011“ enthalten sind.-->
<!--~~ <notInFont>
<p lang="de">Das Element &lt;notInFont> dient dazu, Zeichen zu markieren, die nicht in den Thieme Schriften „Thieme Argo 2011“ und „Thieme Gulliver 2011“ enthalten sind.
Darüber lassen sich im XML falsche Sonderzeichen suchen und ersetzen.</p>
<p lang="en">The element &lt;notInFont> serves to mark characters that are not contained in the Thieme fonts „Thieme Argo 2011“ and „Thieme Gulliver 2011“.
Moreover it can be used to identify and replace “wrong” symbols.</p>

~~ fname 
<p lang="de">Name der Schrift, die dieses Sonderzeichen enthält; optional.</p>
<p lang="en">Font name that contains the special character; optional.</p>
~~-->
<!ELEMENT notInFont (#PCDATA)* >
<!ATTLIST notInFont
    fname CDATA  #IMPLIED
>


<!--  doc: Kennzeichnet eine Fußnote. Fußnoten werden generell als Inlineelemente verwendet.-->
<!--~~ <footnote>
<p lang="de">Kennzeichnet eine Fußnote. Fußnoten werden generell als Inlineelemente verwendet.</p>
<p lang="en">The element designates a footnote. Footnotes are used as inline elements in general.</p>

~~ type
<p lang="de">Beliebiger Text; optional.</p>
<p lang="en">Arbitrary text; optional.
Permits an additional qualification, such as for asterisk footnotes.</p>
~~-->
<!ELEMENT footnote (para+) >
<!ATTLIST footnote
    id ID  #IMPLIED
    type CDATA  #IMPLIED
>


<!--  doc: Enthält den Verweis auf eine andere Stelle im Dokument, z. B. eine Abbildung oder eine Tabelle. Das Linkziel muss nicht zwingend im selben Dokument sein, um ein valides XML zu erhalten.
Bei Seitenverweisen wird immer ein Begriff verlinkt, der sich für online anklicken lässt. Die Seitenzahl und der Text "S." werden für das Buch automatisch generiert.
Für Verweise ins Internet benutzen Sie bitte <uri>.-->
<!--~~ <link>
<p lang="de">Enthält den Verweis auf eine andere Stelle im Dokument, z. B. eine Abbildung oder eine Tabelle. Das Linkziel muss nicht zwingend im selben Dokument sein, um ein valides XML zu erhalten.
Bei Seitenverweisen wird immer ein Begriff verlinkt, der sich für online anklicken lässt. Die Seitenzahl und der Text "S." werden für das Buch automatisch generiert.
Für Verweise ins Internet benutzen Sie bitte `<uri>.</p>
<p lang="en">The element contains a reference to another point in the document, such as an illustration or a table. The destination of the link must not necessarily be in the same document to get a valid XML. 
For a reference to an external target, such as a web page, please use the element `<uri>.</p>

~~ idref
<p lang="de">Eindeutiger Bezeichner; erforderlich.</p>
<p lang="en">Unique identifier; required.</p>

~~ target
<p lang="de">Art des Ziels; optional.
Mögliche Unterscheidungen von Links sind: Seite, Buchteil, Kapitel, Tabellen, Abbildungen, Audio, Video, Formeln, Exkurse, Medikamente und Literaturangaben.</p>
<p lang="en"> Type of target; optional.
Means all internal references. Possible values are: page, part, chapter, table, figure, audio, video, formula, excursus, medicine and literature.</p>
~~-->
<!ELEMENT link (#PCDATA | emph | sup | sub | notInFont)* >
<!ATTLIST link
   target (page | part | section | table | figure | audio | video | formula | excursus | literature | box | medicine | qac) #REQUIRED
   %idref.attrib;
>


<!--  doc: Dient der Verlinkung von Webseiten. 
Neu ist die Angabe einer URI vom Typ "qrcode" für die automatische Erzeugung eines QR-Codes sowie das Arttibut "access-date".-->
<!--~~ <uri>
<p lang="de">Dient der Verlinkung von Webseiten. 
Neu ist die Angabe einer URI vom Typ "qrcode" für die automatische Erzeugung eines QR-Codes sowie das Attribut "access-date"</p>
<p lang="en">The element is used to capture internet resources, e.g. websites.
New type "qrcode" to generate qr codes automatically from the url and new attribute "access-date".</p>

~~ href
<p lang="de">Beliebiger Text; erforderlich.
Internetadresse der Webseite.</p>
<p lang="en">(arbitrary text; required)
Internet address of the website.</p>

~~ type
<p lang="de">Festgelegte Auswahl; optional.
Ermöglicht eine zusätzliche Qualifizierung mittels der Werte „url“, „email“ oder „qrcode“.</p>
<p lang="en">Fixed values; optional.
Additonal information by setting one of the values “url”, “email” or “qrcode”</p>

~~ access-date
<p lang="de">YYYY-MM-DD; optional.
Datum des Zugriffs auf die Website.</p>
<p lang="en">(YYYY-MM-DD; optional)
Access date of the website.</p>
~~-->
<!ELEMENT uri (#PCDATA | notInFont)* >
<!ATTLIST uri
   href  CDATA   #REQUIRED
   type (url | email | qrcode) #IMPLIED
   access-date NMTOKEN #IMPLIED
>


<!--  doc: DEPRECATED. Nicht mehr benutzen.-->
<!--~~ <target>
<p lang="de">Nicht mehr benutzen. Achtung: In Boxen weiterhin erlaubt.</p>
<p lang="en">Not to be used. Still allowed in element box.</p>
~~-->

<!ELEMENT target EMPTY>
<!ATTLIST target
  %id.attrib;
  related CDATA #IMPLIED
>


<!--  doc: Stellt einen Eintrag für das Sachregister dar. Die drei Attribute @emph, @ref und @index ermöglichen es, alle Varianten für Indexeinträge aus der TReX-Formatvorlage zu übernehmen.
Das Indexmodell ist in der Hinsicht restriktiver, als dass Einträge nicht mehr übersprungen werden dürfen. (siehe hierzu auch die Beschreibung von `<entry1> bis `<entry6>).-->
<!--~~ <indexentry>
<p lang="de">Stellt einen Eintrag für das Sachregister dar. Die drei Attribute @emph, @ref und @index ermöglichen es, alle Varianten für Indexeinträge aus der TReX-Formatvorlage zu übernehmen.
Das Indexmodell ist in der Hinsicht restriktiver, als dass Einträge nicht mehr übersprungen werden dürfen. (siehe hierzu auch die Beschreibung von `<entry1> bis `<entry6>).</p>
<p lang="en">The element represents an entry for the subject index. The three attributes @emph, @ref and @index allow adopting all variants of index entries from the TReX template. 
The index model has been restricted with regard, as that it’s not allowed to omit individual levels of an index entry. (see also the description of `<entry1> to `<entry6>).
</p>

~~ emph
<p lang="de">Auswahl aus 3 Hervorhebungen; optional.
Gibt an, ob der entsprechende Eintrag im Sachregister besonders hervorgehoben werden soll, indem seine  Seitenzahl fett (bold), kursiv (italic) oder fettkursiv (bolditalic) dargestellt wird.</p>
<p lang="en">Selection from three emphases; optional.
Specifies whether the corresponding entry in the subject index should be specially emphasized by displaying its page number in “bold”, “italic”, or “bolditalic”.</p>

~~ ref
<p lang="de">Beliebiger Text; optional.
Text für Verweise auf andere Einträge, z. B. „siehe entry1“</p>
<p lang="en">Arbitrary text; optional.
Text for references to other entries, e.g. “see entry1“</p>

~~ index
<p lang="de">Beliebiger Text; optional.
Gibt an, dass dieser Eintrag für ein bestimmtes Register verwendet werden soll, z. B. Autoren- oder Sachregister.</p>
<p lang="en">Arbitrary text; optional.
Specifies that this entry is to be used for a particular index, such as the author or subject index.</p>
~~-->
<!ELEMENT indexentry (entry1, (entry2, (entry3, (entry4, (entry5, (entry6)?)?)?)?)?) >
<!ATTLIST indexentry
    emph  (bold | italic | bolditalic)  #IMPLIED
    ref     CDATA  #IMPLIED
    index   CDATA  #IMPLIED
    %id.attrib;
>


<!--  doc: Die Elemente `<entry1> bis `<entry6> werden für die Ebenen 1-6 eines Indexeintrages verwendet.-->
<!--~~ <entry1>
<p lang="de">Die Elemente `<entry1> bis `<entry6> werden für die Ebenen 1-6 eines Indexeintrages verwendet. 
Um sicherzustellen, dass jede Ebene genau einmal vorkommt, und dass nicht mehr als 6 Ebenen verwendet werden, gibt es 6 verschiedene Elemente.
Da in Indexeinträgen Hoch- und Tiefstellungen benötigt werden, z. B. für CO2, war das alte Modell mit Attributwerten nicht mehr ausreichend.</p>
<p lang="en">The elements `<entry1> to `<entry6> are used for levels 1 to 6 of an index entry. In order to ensure that each level occurs precisely once, and that no more than six levels are 
used, there are six different elements. Since superscripts and subscripts are needed in index entries, for example for “CO2”, the old model with attribute values was no longer sufficient.</p>
~~-->
<!ELEMENT entry1 (#PCDATA | sub | sup)* >
<!ATTLIST entry1
    sort     CDATA  #IMPLIED
 >


<!--  doc: Die Elemente `<entry1> bis `<entry6> werden für die Ebenen 1-6 eines Indexeintrages verwendet.-->
<!--~~ <entry2>
<p lang="de">Die Elemente `<entry1> bis `<entry6> werden für die Ebenen 1-6 eines Indexeintrages verwendet. 
Um sicherzustellen, dass jede Ebene genau einmal vorkommt, und dass nicht mehr als 6 Ebenen verwendet werden, gibt es 6 verschiedene Elemente.
Da in Indexeinträgen Hoch- und Tiefstellungen benötigt werden, z. B. für CO2, war das alte Modell mit Attributwerten nicht mehr ausreichend.</p>
<p lang="en">The elements `<entry1> to `<entry6> are used for levels 1 to 6 of an index entry. In order to ensure that each level occurs precisely once, and that no more than six levels are 
used, there are six different elements. Since superscripts and subscripts are needed in index entries, for example for “CO2”, the old model with attribute values was no longer sufficient.</p>
~~-->
<!ELEMENT entry2 (#PCDATA | sub | sup)* >
<!ATTLIST entry2
    sort     CDATA  #IMPLIED
 >

<!--  doc: Die Elemente `<entry1> bis `<entry6> werden für die Ebenen 1-6 eines Indexeintrages verwendet.-->
<!--~~ <entry3>
<p lang="de">Die Elemente `<entry1> bis `<entry6> werden für die Ebenen 1-6 eines Indexeintrages verwendet. 
Um sicherzustellen, dass jede Ebene genau einmal vorkommt, und dass nicht mehr als 6 Ebenen verwendet werden, gibt es 6 verschiedene Elemente.
Da in Indexeinträgen Hoch- und Tiefstellungen benötigt werden, z. B. für CO2, war das alte Modell mit Attributwerten nicht mehr ausreichend.</p>
<p lang="en">The elements `<entry1> to `<entry6> are used for levels 1 to 6 of an index entry. In order to ensure that each level occurs precisely once, and that no more than six levels are 
used, there are six different elements. Since superscripts and subscripts are needed in index entries, for example for “CO2”, the old model with attribute values was no longer sufficient.</p>
~~-->
<!ELEMENT entry3 (#PCDATA | sub | sup)* >
<!ATTLIST entry3
    sort     CDATA  #IMPLIED
 >


<!--  doc: Die Elemente `<entry1> bis `<entry6> werden für die Ebenen 1-6 eines Indexeintrages verwendet.-->
<!--~~ <entry4>
<p lang="de">Die Elemente `<entry1> bis `<entry6> werden für die Ebenen 1-6 eines Indexeintrages verwendet. 
Um sicherzustellen, dass jede Ebene genau einmal vorkommt, und dass nicht mehr als 6 Ebenen verwendet werden, gibt es 6 verschiedene Elemente.
Da in Indexeinträgen Hoch- und Tiefstellungen benötigt werden, z. B. für CO2, war das alte Modell mit Attributwerten nicht mehr ausreichend.</p>
<p lang="en">The elements `<entry1> to `<entry6> are used for levels 1 to 6 of an index entry. In order to ensure that each level occurs precisely once, and that no more than six levels are 
used, there are six different elements. Since superscripts and subscripts are needed in index entries, for example for “CO2”, the old model with attribute values was no longer sufficient.</p>
~~-->
<!ELEMENT entry4 (#PCDATA | sub | sup)* >
<!ATTLIST entry4
    sort     CDATA  #IMPLIED
 >

<!--  doc: Die Elemente `<entry1> bis `<entry6> werden für die Ebenen 1-6 eines Indexeintrages verwendet.-->
<!--~~ <entry5>
<p lang="de">Die Elemente `<entry1> bis `<entry6> werden für die Ebenen 1-6 eines Indexeintrages verwendet. 
Um sicherzustellen, dass jede Ebene genau einmal vorkommt, und dass nicht mehr als 6 Ebenen verwendet werden, gibt es 6 verschiedene Elemente.
Da in Indexeinträgen Hoch- und Tiefstellungen benötigt werden, z. B. für CO2, war das alte Modell mit Attributwerten nicht mehr ausreichend.</p>
<p lang="en">The elements `<entry1> to `<entry6> are used for levels 1 to 6 of an index entry. In order to ensure that each level occurs precisely once, and that no more than six levels are 
used, there are six different elements. Since superscripts and subscripts are needed in index entries, for example for “CO2”, the old model with attribute values was no longer sufficient.</p>

~~-->
<!ELEMENT entry5 (#PCDATA | sub | sup)* >
<!ATTLIST entry5
    sort     CDATA  #IMPLIED
 >

<!--  doc: Die Elemente `<entry1> bis `<entry6> werden für die Ebenen 1-6 eines Indexeintrages verwendet.-->
<!--~~ <entry6>
<p lang="de">Die Elemente `<entry1> bis `<entry6> werden für die Ebenen 1-6 eines Indexeintrages verwendet. 
Um sicherzustellen, dass jede Ebene genau einmal vorkommt, und dass nicht mehr als 6 Ebenen verwendet werden, gibt es 6 verschiedene Elemente.
Da in Indexeinträgen Hoch- und Tiefstellungen benötigt werden, z. B. für CO2, war das alte Modell mit Attributwerten nicht mehr ausreichend.</p>
<p lang="en">The elements `<entry1> to `<entry6> are used for levels 1 to 6 of an index entry. In order to ensure that each level occurs precisely once, and that no more than six levels are 
used, there are six different elements. Since superscripts and subscripts are needed in index entries, for example for “CO2”, the old model with attribute values was no longer sufficient.</p>
~~-->
<!ELEMENT entry6 (#PCDATA | sub | sup)* >
<!ATTLIST entry6
    sort     CDATA  #IMPLIED
 >
 
 <!-- doc: Primärdaten Primdoi -->
<!--~~ <primdoi>
<p lang="de">Primärdaten DOI.</p>
<p lang="en">Primary data DOI</p>
~~-->
<!ELEMENT primdoi (#PCDATA)>
