<?xml version="1.0" encoding="UTF-8"?>
<!-- 
  Schematron als Ergänzung zur KIS DTD
  Patrick Schwarz, (c) Georg Thieme Verlag KG Stuttgart
  Changelog:
    v0.1 initial release, ps, 15.03.2012
    v1.0, aufgeräumt, Prüfung im Images- und Rootordner, Check für alte Boxtypen und leere Elemente
    v1.1, 24.08.12 Dateipfad für Abbildungsprüfung umgestellt, da nicht mehr funktionsfähig
    v1.2, 29.11.12 Links ohne id aufzählen; Prüfung Datumsangaben, ISBN-Nummer, Materialnummer; URL-Filter gegen Schematron-Abbruch bei Sonderzeichen (Abb.)
    v1.3, 14.12.12 Neues Metadatenmodell ergänzt
    v1.4, 07.01.13 Warnungen und Fehler korrigiert
    v1.5, 04.02.13 Formulierung, empty Element Prüfung korrigiert
    v1.6, 25.02.13 Prüfregeln für Tabellen, externe Links, x-Level, leere Dateinamen in Abbildungen, Section-Titellänge
    v1.7, 20.03.13 Prüfung nach mehrfach gesetzten meta-Elementen, Prüfung nach unnötigen emphs
    v1.8, 11.04.13 Bugfix Section-Titellänge und uri-Prüfung, Deprecated-Elemente
    v1.9, 10.07.13 Keine figure,box,table in listing; para beginnt mit Leerzeichen; Absatzprüfung; Tabellenkopfzeile; Listenebenen; Sectionabsatz (Lu)
    v1.10,30.08.13 Fehlerhafte Regel zum Prüfen von überflüssigen Leerzeichen vorerst entfernt
    v1.11,09.10.13 Link mit target page muss echten Text beinhalten (si), front/backmatter-Prüfung, Blockadenprüfung (arj), col-width-Werte, indexentry-Leerzeichen, kein Link im title (arj), uri als Fehler, Prüfung auf doppelte personid-Werte (arj)
    v1.12,04.06.14 Part-Prüfungen erweitert, notInFont-Info (si), keine Umlaute in IDs (si), keine Links auf Abbildungen ohne Legende (si)
    v1.13,27.06.14 Abb ohne Legende: Nur Warnung, Probleme bei Anwendung der Link-Regeln behoben, Versionsbezeichnung entfernt, Alte Boxen: Fehler (arj)
    v1.14,31.07.14 Kommentare als Hinweis anzeigen (Lu); Prüfung von leeren Elementen auf Elemente eingegrenzt, col/rowspan-Überprüfung neu geschrieben (md), alte Metaprüfungen entfernt
    v1.15,22.08.14 a/v-@id-Prüfung (arj), Nur Warnung bei mehrfach verwendeten Meta-Elementen (Lu)
    v1.16,24.10.14 collaborator aus meta-Duplikatprüfung entfernt, box-H-Prüfung entfernt, deprecated-Elemente entfernt, backmatter entfernt, div. Tabellenprüfungen, div. Linkprüfungen, Section @counter/@level, @index-Info, Prüfung ob Tab/Abb verlinkt (si)
    v1.17,24.11.14 Beschreibende Titel eingefügt, Texte und Variablen angepasst (für Doku), Prüfung auf unterschiedliche Bilderordner entfernt, Bugfix: Tab/Abb-Boxprüfung, Abb-Fileprüfung deaktivieren, wenn keine Abb. verlinkt, div. error-Level angepasst, Abb.-link-Prüfung auf title erweitert, Kommentarprüfung entfernt (Lu)
    v1.18,02.03.15 Prüfung auf fehlerhafte Zitate (ps); Whitespace-Prüfung eingeschränkt, xlevel entfernt, URLs angepasst, Boxenprüfung eingeschränkt, Absatzprüfungen für Doku restrukturiert, emph-Prüfung korrigiert
    v1.19,14.04.15 Tabellenkopfprüfung korrigiert, Legendenprüfung E-Produkte (si,arj)
    v2.0, 17.04.15 SQF: Diverse Schematron Quick Fixes integriert
    v2.1, 17.06.15 Globale Quickfixes vorerst entfernt, da durch Art und Weise der Umsetzung Performanceprobleme auftreten, Prüfung auf Abbildungsduplikate in einer Figure, Fehlerbehebung Listing-Check
    v2.2, 17.07.15 Verweisprüfung in Abbildungen optimiert, Prüfung der Dateiendungen, @id-Prüfung für audio/video entfernt
    v2.3, 24.09.15 Keine Info mehr bei leeren targets, entry4-6 bewarnen, fehlende doi bewarnen
    v2.4, 10.12.15 SQFs für emph korrigiert
    v2.5, 19.02.16 Fehler in doppelt angelegten SQF-IDs behoben
    v2.6, 30.11.16 Weiteres Blockadezeichen aufgenommen (fhj), "link" aus Prüfung leerer Elemente ausgenommen (si), Sprache-Metadatum prüfen (arj), Trailer-Hinweis (si), ePub-Prüfwert von 512000 auf 400000 geändert (si), Abbildungsprüfung für censhare deaktiviert
    v2.7, 05.02.17 Fehler, wenn mehr als eine startnum
    v2.8, 21.03.17 Legenden an Abbildungen in Tabellen verboten (si), Prüfung auf verbotene Zeichen (arj), DOI-Prüfung (fhj)
    v2.9, 14.04.17 Korrektur Schreibfehler
    v2.10,20.11.17 Prüfung auf leere Attribute
    v2.11,05.02.18 Bugfix: Schematron funktioniert nicht bei XMLs mit fehlerhafter figure/video-Struktur (fhj), personid als Fehler (fhj) und leere Elemente als Warnung hochgestuft
    v2.12,01.03.18 rights wird auf 3rdparty überprüft #OXY-20
    v2.13,08.03.18 Bugfix Abbildungsprüfung: leere filerefs geben Duplikatfehler aus
    v2.14,16.03.18 Medienprüfung für censhare erweitert und Fehler in Medienprüfung beseitigt CS-P#5925175
    v2.15,23.03.18 title und shorttitle wurden doppelt auf Inhalt geprüft
    v2.16,16.04.18 Link-ID-Prüfung angepasst, damit Schematronprüfung bei doppelten IDs nicht abstürzt
    v2.17,25.04.18 Erweiterung URI-Prüfung #OXY-109 (si)
    v2.18,17.05.18 Weitere Einschränkung der URI-Prüfung (Leerzeichen verboten), da das Schematron so nicht mehr funktioniert
    v2.19,18.07.18 DOI-Prüfung auf document/meta beschränkt (Änderugn durch neues Metadatenmodell)
    v3.0, 07.02.19 Änderungen aufgrund DTD-Anpassung: Prüfung auf document/section entfernt; metaInfo und anaSectio aus der Liste der deprecated Elemente entfernt
    v3.1, 27.11.19 Prüfung auf leere Titel verschärft #OXY-115, Prüfung auf leere Legenden eingebaut und para in td/th aus Prüfung ausgeschlossen #OXY-184, #OXY-106
    v3.2, 20.05.20 Korrektur der Absatzprüfung in Legenden (IT-44637)
    v4.0, 27.01.21 Schematronprüfungen für Zeitschriften von data2type ergänzt (KPNF-2503); Warnmeldung zum target-Element entfernt (OXY-242)
    v4.1, 26.04.21 Prüfung der hide-level bzw. hide@level (OXY-252); Prüfung auf doppelte Quellenangaben in figure-Containern (KPNF-2656 und Mantis-2357)
    v4.2, 30.04.21 Country-Tagging bei Affiliation/Korrespondenzadresse, correspaddressCountry (Mail von Laura Diemand); DEAKTIVIERT: Prüfung auf doppelte Quellenangaben in figure-Containern (KPNF-2656 und Mantis-2357)
    v4.3, 06.05.21 Prüfung der hidel-level um eine Prüfung auf darin enthaltene switch ergänzt (OXY-252)
    v4.4, 09.06.21 Prüfung der hidel-level ergänzt (OXY-252)
    v4.5, 25.10.21 Erkennen censhare-Pfad in fileref-Attribut (OXY-219), Doppelter Divis in Indexeinträgen (OXY-211) und Prüfungen für XMLFirst (OXY-264)
    v4.6, 23.12.21 Neue Prüfung auf abstract und abstracttranslated für XMLFirst (OXY-277), jnref für XMLFirst (OXY-264) 
    v4.7, 23.12.21 Neue Prüfung für Sprachangaben in den Elementen language, metadata type='language' und im Attribut language (OXY-239)
    v4.8, 02.02.22 Korrektur Prüfung title (OXY-283), Neue Prüfung für Teilabbildungslegenden (IT-65487)
    v4.9, 10.05.22 Neue Prüfung für Auszeichnungen in Keywords (OXY-268), Korrektur Prüfung fileref-Attribut (OXY-287), Neue Prüfungen name in jnref und Boxtypen für XMLFirst (OXY-264), Korrektur Fehlerhierarchie für rights-Prüfung 3rd party (OXY-298)
    v4.10,02.09.22 Neue Prüfung titletranslated für XMLFirst (OXY-264)
    v4.11,18.04.23, Neue Prüfung fileref (OXY-215), Püfungen für IDs in Referenzen zurückgenommen (OXY-230)
    v5.0, 22.06.23, Überarbeitung nach Korrekturen aus ProM (OXY-213)
-->

<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt3" xmlns:sqf="http://www.schematron-quickfix.com/validator/process" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <title>KIS Schematron</title>
    <ns uri="java:java.io.File" prefix="f"/>
    <ns uri="java:java.net.URI" prefix="u"/>
    <ns prefix="m" uri="http://www.w3.org/1998/Math/MathML"/>
    <let name="idrefs" value="//link/@idref"/>
    <let name="ids" value="//@id"/>
    <let name="id_elements" value="
            ('subfigure',
            'figure',
            'table',
            'box',
            'formula',
            'para',
            'definitionitem',
            'literature',
            'paratitle1',
            'paratitle2',
            'header1',
            'header2',
            'header3',
            'subtitle',
            'section',
            'part',
            'jnref',
            'bkref',
            'chref',
            'otherref')"/>
    <let name="all_filerefs" value="count(//@fileref)"/>
    <let name="empty_filerefs" value="count(//@fileref[. = ''])"/>
    <let name="cs_filerefs" value="count(//@fileref[starts-with(., 'censhare:///') and doc-available(tokenize(., '/storage')[1])])"/>
    <let name="fs_filerefs" value="count(//@fileref[not(. = '') and not(starts-with(., 'censhare:///')) and f:exists(f:new(resolve-uri(replace(., '[^a-zA-Z0-9_\-\.]', ''), base-uri())))])"/>
    <!--<let name="fs_filerefs" value="0"/>-->
    <let name="valid_filerefs" value="$fs_filerefs + $cs_filerefs"/>

    <phase id="books">
        <active pattern="info"/>
        <active pattern="metadata"/>
        <active pattern="links"/>
        <active pattern="figures"/>
        <active pattern="tables"/>
        <active pattern="tablesBoxes"/>
        <active pattern="listing"/>
        <active pattern="container"/>
        <active pattern="indexentry"/>
        <active pattern="partsection"/>
        <active pattern="para"/>
        <active pattern="text"/>
        <active pattern="hidelevel"/>
        <active pattern="deprecated"/>
        <active pattern="doubledDivisIndex"/>
        <active pattern="language"/>
        <active pattern="qblock"/>
        <active pattern="sectionLiterature"/>
        <active pattern="mmlTex"/>
        <active pattern="accessibility"/>
    </phase>

    <phase id="journals">
        <!-- <active pattern="fz_contentXML_section1Root"/>
        <active pattern="fz_contentXML_section1Title"/>-->
        <active pattern="trademarks"/>
        <active pattern="dates"/>
        <active pattern="issueNumber"/>
        <active pattern="doubledDOI"/>
        <active pattern="doubledElementsLitref"/>
        <active pattern="emptyAuthors"/>
        <active pattern="startingWithPunctuation"/>
        <active pattern="startingWithDOI"/>
        <active pattern="searchProcessingInstruction"/>
        <active pattern="textContentInLitref"/>
        <active pattern="fz_sectionLitref"/>
        <active pattern="metadataSpaces"/>
        <active pattern="captionStartingWithNumber"/>
        <active pattern="legendStartingWithNumber"/>
        <active pattern="categoryLayoutColor"/>
        <active pattern="cme"/>
        <active pattern="authorAffiliation"/>
        <active pattern="correspaddressEmailPhone"/>
        <active pattern="correspaddressCountry"/>
        <active pattern="correspauthorAddress"/>
        <active pattern="emptyPara"/>
        <!--ADD 2020-12-04 from KIS Schematron Abgleich mit Buch.pdf - Patterns aus kis-check.sch; modifizierte Patterns beginnen mit fz_für Datenstruktur Fachzeitschriften -->
        <active pattern="fz_info"/>
        <active pattern="fz_metadata_subset_DOI_startnum"/>
        <active pattern="fz_links"/>
        <active pattern="figures"/>
        <active pattern="fz_tables"/>
        <active pattern="listing"/>
        <active pattern="container"/>
        <active pattern="fz_partsection"/>
        <active pattern="fz_para"/>
        <active pattern="fz_text"/>
        <active pattern="deprecated"/>
        <active pattern="litref"/>
        <active pattern="fz_abstract"/>
        <active pattern="fz_jnref"/>
        <active pattern="language"/>
        <active pattern="fz_keywords"/>
        <active pattern="fz_container"/>
        <active pattern="fz_title"/>
        <active pattern="fz_metadata"/>
    </phase>

    <!--Global Quickfixes-->
    <sqf:fixes>
        <sqf:fix id="duplicates">
            <sqf:description>
                <sqf:title ref="fix_duplicates_title_de fix_duplicates_title_en"/>
                <sqf:p ref="fix_duplicates_p_de fix_duplicates_p_en"/>
            </sqf:description>
            <sqf:delete use-when="not(@type)" match="parent::*/*[name() = current()/name() and not(generate-id() = generate-id(current()))]"/>
            <sqf:delete use-when="@type" match="parent::*/*[name() = current()/name() and not(generate-id() = generate-id(current())) and @type = current()/@type]"/>
        </sqf:fix>

        <sqf:fix id="remvalue">
            <sqf:description>
                <sqf:title ref="fix_remvalue_title_de fix_remvalue_title_en"/>
                <sqf:p ref=" fix_remvalue_p_de fix_remvalue_p_en"/>
            </sqf:description>
            <sqf:delete/>
        </sqf:fix>
        <sqf:fix id="remelm">
            <sqf:description>
                <sqf:title xml:lang="de" ref="fix_remelm_title_de fix_remelm_title_en"/>
                <sqf:p xml:lang="de" ref="fix_remelm_p_de fix_remelm_p_en"/>
            </sqf:description>
            <sqf:replace>
                <sqf:keep select="child::node()"/>
            </sqf:replace>
        </sqf:fix>
        <sqf:fix id="addtitle">
            <sqf:description>
                <sqf:title xml:lang="de" ref="fix_addtitle_title_de fix_addtitle_title_en"/>
                <sqf:p xml:lang="de" ref="fix_addtitle_p_de fix_addtitle_p_en"/>
            </sqf:description>
            <sqf:add target="title" node-type="element" position="first-child"/>
        </sqf:fix>
        <sqf:fix id="addlegend">
            <sqf:description>
                <sqf:title xml:lang="de" ref="fix_addlegend_title_de fix_addlegend_title_en"/>
                <sqf:p xml:lang="de" ref="fix_addlegend_p_de fix_addlegend_p_en"/>
            </sqf:description>
            <sqf:add>
                <legend xmlns="">
                    <para>█</para>
                </legend>
            </sqf:add>
        </sqf:fix>
        <!--ADD 2020-12-04 aus Schematron Fachzeitschriften (XML1stFZ_Schematron-Regeln.xlsx)-->
        <sqf:fix id="deleteTrademarks">
            <sqf:description>
                <sqf:title xml:lang="de" ref="fix_deleteTrademarks_title_de fix_deleteTrademarks_title_en"/>
                <sqf:p xml:lang="de" ref="fix_deleteTrademarks_p_de fix_deleteTrademarks_p_en"/>
            </sqf:description>
            <sqf:delete use-when="matches(., '^[\s]*[(®℠™|TM|SM)]+[\s]*$')" match="parent::*"/>
            <sqf:stringReplace use-when="matches(., '[\w]*[®℠™]+[\w]*')" regex="[®℠™]+"/>
        </sqf:fix>
        <sqf:fix id="deleteDOIorPubmed">
            <sqf:description>
                <sqf:title xml:lang="de" ref="fix_deleteDOIorPubmed_title_de fix_deleteDOIorPubmed_title_en"/>
                <sqf:p xml:lang="de" ref="fix_deleteDOIorPubmed_p_de fix_deleteDOIorPubmed_p_en"/>
            </sqf:description>
            <sqf:delete/>
        </sqf:fix>
        <sqf:fix id="deleteEmptyName">
            <sqf:description>
                <sqf:title xml:lang="de" ref="fix_deleteEmptyName_title_de fix_deleteEmptyName_title_en"/>
                <sqf:p xml:lang="de" ref="fix_deleteEmptyName_p_de fix_deleteEmptyName_p_en"/>
            </sqf:description>
            <sqf:delete/>
        </sqf:fix>
        <sqf:fix id="deleteStartingPunctuation">
            <sqf:description>
                <sqf:title xml:lang="de" ref="fix_deleteStartingPunctuation_title_de fix_deleteStartingPunctuation_title_en"/>
                <sqf:p xml:lang="de" ref="fix_deleteStartingPunctuation_p_de fix_deleteStartingPunctuation_p_en"/>
            </sqf:description>
            <sqf:stringReplace regex="^[\s\.\,;\-\?_\!]+[\s]*.*$">
                <xsl:analyze-string select="." regex="([\s\\.\\,;\-\\?_\\!]+)(\s)*(.*)">
                    <xsl:matching-substring>
                        <xsl:copy-of select="regex-group(3)"/>
                    </xsl:matching-substring>
                </xsl:analyze-string>
            </sqf:stringReplace>
        </sqf:fix>

        <sqf:fix id="deleteStartingDOI">
            <sqf:description>
                <sqf:title xml:lang="de" ref="fix_deleteStartingDOI_title_de fix_deleteStartingDOI_title_en"/>
                <sqf:p xml:lang="de" ref="fix_deleteStartingDOI_p_de fix_deleteStartingDOI_p_en"/>
            </sqf:description>
            <sqf:stringReplace regex="^doi:?[\s]*.*$">
                <xsl:analyze-string select="." regex="(doi:?[\s]*)(.*)">
                    <xsl:matching-substring>
                        <xsl:copy-of select="regex-group(2)"/>
                    </xsl:matching-substring>
                </xsl:analyze-string>
            </sqf:stringReplace>
        </sqf:fix>
        <sqf:fix id="deleteProcessingInstruction">
            <sqf:description>
                <sqf:title xml:lang="de" ref="fix_deleteProcessingInstruction_title_de fix_deleteProcessingInstruction_title_en"/>
                <sqf:p xml:lang="de" ref="fix_deleteProcessingInstruction_p_de fix_deleteProcessingInstruction_p_en"/>
            </sqf:description>
            <sqf:delete/>
        </sqf:fix>
        <sqf:fix id="deleteTextNodes">
            <sqf:description>
                <sqf:title xml:lang="de" ref="fix_deleteTextNodes_title_de fix_deleteTextNodes_title_en"/>
                <sqf:p xml:lang="de" ref="fix_deleteTextNodes_p_de fix_deleteTextNodes_p_en"/>
            </sqf:description>
            <sqf:delete match="text()"/>
        </sqf:fix>
        <sqf:fix id="addReferences">
            <sqf:description>
                <sqf:title xml:lang="de" ref="fix_addReferences_title_de fix_addReferences_title_en"/>
                <sqf:p xml:lang="de" ref="fix_addReferences_p_de fix_addReferences_p_en"/>
            </sqf:description>
            <sqf:add match="." node-type="attribute" target="type">references</sqf:add>
        </sqf:fix>
        <sqf:fix id="deleteStartingNumber">
            <sqf:description>
                <sqf:title xml:lang="de" ref="fix_deleteStartingNumber_title_de fix_deleteStartingNumber_title_en"/>
                <sqf:p xml:lang="de" ref="fix_deleteStartingNumber_p_de fix_deleteStartingNumber_p_en"/>
            </sqf:description>
            <sqf:delete use-when="matches(., '^[\s]*[\d]+[\s]*.*$')" match="parent::emph"/>
            <sqf:stringReplace regex="^[\d]+[\s]*.*$">
                <xsl:analyze-string select="." regex="([\d]+[\s]*)(.*)">
                    <xsl:matching-substring>
                        <xsl:copy-of select="regex-group(2)"/>
                    </xsl:matching-substring>
                </xsl:analyze-string>
            </sqf:stringReplace>
        </sqf:fix>
        <sqf:fix id="addResponse">
            <sqf:description>
                <sqf:title xml:lang="de" ref="fix_addResponse_title_de fix_addResponse_title_en"/>
                <sqf:p xml:lang="de" ref="fix_addResponse_p_de fix_addResponse_p_en"/>
            </sqf:description>
            <sqf:add node-type="element" position="first-child" target="response">█ Bitte richtige Antwort markieren. // Please mark the correct answer. █</sqf:add>
        </sqf:fix>
        <sqf:fix id="addResponseText">
            <sqf:description>
                <sqf:title xml:lang="de" ref="fix_addResponseText_title_de fix_addResponseText_title_en"/>
                <sqf:p xml:lang="de" ref="fix_addResponseText_p_de fix_addResponseText_p_en"/>
            </sqf:description>
            <sqf:replace match="response" target="response" node-type="element" select="' █ Bitte richtige Antwort markieren. // Please mark the correct answer. █'"/>
        </sqf:fix>
        <sqf:fix id="deleteEmptyPara">
            <sqf:description>
                <sqf:title xml:lang="de" ref="fix_deleteEmptyPara_title_de fix_deleteEmptyPara_title_en"/>
                <sqf:p xml:lang="de" ref="fix_deleteEmptyPara_p_de fix_deleteEmptyPara_p_en"/>
            </sqf:description>
            <sqf:delete/>
        </sqf:fix>

    </sqf:fixes>

    <diagnostics xml:id="sqf">
        <diagnostic id="fix_duplicates_title_de" xml:lang="de">Duplikate entfernen</diagnostic>
        <diagnostic id="fix_duplicates_p_de" xml:lang="de">Entfernt Duplikate und behält das ausgewählte Element bei</diagnostic>
        <diagnostic id="fix_remvalue_title_de" xml:lang="de">Eintrag entfernen</diagnostic>
        <diagnostic id="fix_remvalue_p_de" xml:lang="de">Löscht den selektierten Knoten</diagnostic>
        <diagnostic id="fix_remelm_title_de" xml:lang="de">Element entfernen</diagnostic>
        <diagnostic id="fix_remelm_p_de" xml:lang="de">Löscht das Element, behält den Elementinhalt jedoch bei</diagnostic>
        <diagnostic id="fix_addtitle_title_de" xml:lang="de">Titel hinzufügen</diagnostic>
        <diagnostic id="fix_addtitle_p_de" xml:lang="de">Fügt einen Titel hinzu</diagnostic>
        <diagnostic id="fix_addlegend_title_de" xml:lang="de">Legende hinzufügen</diagnostic>
        <diagnostic id="fix_addlegend_p_de" xml:lang="de">Legende an die Figure anhängen</diagnostic>
        <diagnostic id="fix_deleteTrademarks_title_de" xml:lang="de">Trademarks löschen</diagnostic>
        <diagnostic id="fix_deleteTrademarks_p_de" xml:lang="de">Löscht Trademarks aus dem textlichen Inhalt</diagnostic>
        <diagnostic id="fix_deleteDOIorPubmed_title_de" xml:lang="de">DOI oder Pubmed löschen</diagnostic>
        <diagnostic id="fix_deleteDOIorPubmed_p_de" xml:lang="de">Löscht nachfolgende id-Elemente vom typ DOI oder pubmed, wenn bereits ein anderes vorhanden ist.</diagnostic>
        <diagnostic id="fix_deleteEmptyName_title_de" xml:lang="de">Entfernen des leeren author-Elements</diagnostic>
        <diagnostic id="fix_deleteEmptyName_p_de" xml:lang="de">Löscht das leere Kindelement von name='author'.</diagnostic>
        <diagnostic id="fix_deleteStartingPunctuation_title_de" xml:lang="de">Interpunktions- Leerzeichen am Anfang entfernen</diagnostic>
        <diagnostic id="fix_deleteStartingPunctuation_p_de" xml:lang="de">Entfernt eines der Interpunktionszeichen .,?! oder Leerzeichen am Anfang eines Strings in Literaturreferenz</diagnostic>
        <diagnostic id="fix_deleteStartingDOI_title_de" xml:lang="de">Den Text 'doi:' am Anfang entfernen</diagnostic>
        <diagnostic id="fix_deleteStartingDOI_p_de" xml:lang="de">Entfernt den Textstring doi: am Anfang des Elements id[@type='doi']</diagnostic>
        <diagnostic id="fix_deleteProcessingInstruction_title_de" xml:lang="de">Processing instruction entfernen</diagnostic>
        <diagnostic id="fix_deleteProcessingInstruction_p_de" xml:lang="de">Entfernt eine processing instruction aus Literaturreferenzen</diagnostic>
        <diagnostic id="fix_deleteTextNodes_title_de" xml:lang="de">Textknoten innerhalb von litref</diagnostic>
        <diagnostic id="fix_deleteTextNodes_p_de" xml:lang="de">Entfernt einen nicht leeren Textknoten innerhalb von name</diagnostic>
        <diagnostic id="fix_addReferences_title_de" xml:lang="de">Fügt Attribut type='references' hinzu</diagnostic>
        <diagnostic id="fix_addReferences_p_de" xml:lang="de">Fügt in einem section-Element, das ein litref-Element besitzt, das Attribut type mit dem Wert 'references' hinzu</diagnostic>
        <diagnostic id="fix_deleteStartingNumber_title_de" xml:lang="de">Abbildungs-/Titelnummern in Legenden</diagnostic>
        <diagnostic id="fix_deleteStartingNumber_p_de" xml:lang="de">Entfernt führende Nummern in table/caption und/oder figure/legend</diagnostic>
        <diagnostic id="fix_addResponse_title_de" xml:lang="de">Einfügen eines leeren response-Elements</diagnostic>
        <diagnostic id="fix_addResponse_p_de" xml:lang="de">Das Element response wird mit 'Blockade' und dem Text "Bitte richtige Antwort markieren" eingefügt.</diagnostic>
        <diagnostic id="fix_addResponseText_title_de" xml:lang="de">Einfügen einer Blockade bei leerem response-Element</diagnostic>
        <diagnostic id="fix_addResponseText_p_de" xml:lang="de">Das leere Element response wird um die 'Blockade' und dem Text "Bitte richtige Antwort markieren" ergänzt.</diagnostic>
        <diagnostic id="fix_deleteEmptyPara_title_de" xml:lang="de">Löscht leere para-Elemente</diagnostic>
        <diagnostic id="fix_deleteEmptyPara_p_de" xml:lang="de">Das Element para wird wenn es leer ist gelöscht.</diagnostic>




        <!-- EN -->
        <diagnostic id="fix_duplicates_title_en" xml:lang="en">Remove duplicates</diagnostic>
        <diagnostic id="fix_duplicates_p_en" xml:lang="en">Removes duplicates and keeps the selected element</diagnostic>
        <diagnostic id="fix_remvalue_title_en" xml:lang="en">Remove entry</diagnostic>
        <diagnostic id="fix_remvalue_p_en" xml:lang="en">Deletes the selected node</diagnostic>
        <diagnostic id="fix_remelm_title_en" xml:lang="en">Delete element</diagnostic>
        <diagnostic id="fix_remelm_p_en" xml:lang="en">Deletes the element but keeps its content</diagnostic>
        <diagnostic id="fix_addtitle_title_en" xml:lang="en">Add title</diagnostic>
        <diagnostic id="fix_addtitle_p_en" xml:lang="en">Add a title</diagnostic>
        <diagnostic id="fix_addlegend_title_en" xml:lang="en">Add legend</diagnostic>
        <diagnostic id="fix_addlegend_p_en" xml:lang="en">Adds a legend to a figure</diagnostic>
        <diagnostic id="fix_deleteTrademarks_title_en" xml:lang="en">Delete trademark symbols</diagnostic>
        <diagnostic id="fix_deleteTrademarks_p_en" xml:lang="en">Deletes trademark symbols from the text</diagnostic>
        <diagnostic id="fix_deleteDOIorPubmed_title_en" xml:lang="en">Delete DOI or Pubmed</diagnostic>
        <diagnostic id="fix_deleteDOIorPubmed_p_en" xml:lang="en">Deletes subsequent id-elements of the type DOI or pubmed if an element of this type already exists.</diagnostic>
        <diagnostic id="fix_deleteEmptyName_title_en" xml:lang="en">Delete empty author element</diagnostic>
        <diagnostic id="fix_deleteEmptyName_p_en" xml:lang="en">Deletes the empty child element of name='author'.</diagnostic>
        <diagnostic id="fix_deleteStartingPunctuation_title_en" xml:lang="en">Delete punctuation marks or blank space at the start of a string</diagnostic>
        <diagnostic id="fix_deleteStartingPunctuation_p_en" xml:lang="en">Removes any punctuation mark (.,?!) or blank spaces at the start of a string in a list of references</diagnostic>
        <diagnostic id="fix_deleteStartingDOI_title_en" xml:lang="en">Delete text 'doi:' at the start of a string</diagnostic>
        <diagnostic id="fix_deleteStartingDOI_p_en" xml:lang="en">Removes the string of characters 'doi:' at the start of the element id[@type='doi']</diagnostic>
        <diagnostic id="fix_deleteProcessingInstruction_title_en" xml:lang="en">Remove processing instruction</diagnostic>
        <diagnostic id="fix_deleteProcessingInstruction_p_en" xml:lang="en">Removes a processing instruction in a list of references</diagnostic>
        <diagnostic id="fix_deleteTextNodes_title_en" xml:lang="en">Delete text nodes in litref</diagnostic>
        <diagnostic id="fix_deleteTextNodes_p_en" xml:lang="en">Removes an unempty text node in the element name</diagnostic>
        <diagnostic id="fix_addReferences_title_en" xml:lang="en">Add an attribute named type with value references</diagnostic>
        <diagnostic id="fix_addReferences_p_en" xml:lang="en">Adds an attribute of the name type with the value references to a section element, that contains a litref element</diagnostic>
        <diagnostic id="fix_deleteStartingNumber_title_en" xml:lang="en">Delete numbers at the start of figure legends / table captions</diagnostic>
        <diagnostic id="fix_deleteStartingNumber_p_en" xml:lang="en">Deletes numbers at the start of a string in figure legends or table captions</diagnostic>
        <diagnostic id="fix_addResponse_title_en" xml:lang="en">Add an empty response element</diagnostic>
        <diagnostic id="fix_addResponse_p_en" xml:lang="en">Adds the element response with the character "full block" and the text "Bitte richtige Antwort markieren".</diagnostic>
        <diagnostic id="fix_addResponseText_title_en" xml:lang="en">Add the character "full block" to an empty response element</diagnostic>
        <diagnostic id="fix_addResponseText_p_en" xml:lang="en">Adds the character "full block" and the text "Bitte richtige Antwort markieren" to the previously empty element response.</diagnostic>
        <diagnostic id="fix_deleteEmptyPara_title_en" xml:lang="en">Delete an empty para</diagnostic>
        <diagnostic id="fix_deleteEmptyPara_p_en" xml:lang="en">The element para is deleted if empty.</diagnostic>
    </diagnostics>

    <pattern id="info">
        <title>Infomeldungen</title>
        <rule context="/" role="Versionsinfo und Statistik">
            <report test="." role="info" diagnostics="info_01_de info_01_en"/>
            <report test="." role="info" diagnostics="info_02_de info_02_en"/>
            <report test="." role="info" diagnostics="info_03_de info_03_en"/>
            <report test=".[//@index]" role="info" diagnostics="info_04_de info_04_en"/>
            <!--<report test="." role="info"> [Statistik] Dokumentgröße: <value-of select="round(string-length(unparsed-text(document-uri(.))) div 1024)"/> kB</report>-->
            <report test="$valid_filerefs = 0 and //@fileref" role="warn" diagnostics="info_05_de info_05_en"/>
        </rule>
    </pattern>

    <diagnostics>
        <diagnostic id="info_01_de" xml:lang="de"> [Statistik] Links: <value-of select="count(//link[@idref = $ids])"/> valide + <value-of select="count($idrefs) - count(//link[@idref = $ids])"/> invalide + <value-of select="count(//link[not(@idref)])"/> leer = <value-of select="count(//link)"/> gesamt </diagnostic>
        <diagnostic id="info_02_de" xml:lang="de"> [Statistik] Linkziele: <value-of select="count($ids[. = $idrefs])"/> genutzt + <value-of select="count($ids) - count(//@id[. = $idrefs])"/> ungenutzt = <value-of select="count($ids)"/> gesamt </diagnostic>
        <diagnostic id="info_03_de" xml:lang="de"> [Statistik] Medien: <value-of select="$valid_filerefs"/> verknüpft + <value-of select="$all_filerefs - $valid_filerefs - $empty_filerefs"/> fehlerhaft + <value-of select="$empty_filerefs"/> leer = <value-of select="$all_filerefs"/> gesamt </diagnostic>
        <diagnostic id="info_04_de" xml:lang="de"> [Statistik] Indices: <value-of select="string-join(distinct-values(//@index), ', ')"/></diagnostic>
        <diagnostic id="info_05_de" xml:lang="de"> Es konnte keine Abbildung im Dateisystem gefunden werden, daher wurde die Abbildungsprüfung nicht ausgeführt.</diagnostic>
        <!-- EN -->
        <diagnostic id="info_01_en" xml:lang="en"> [Statistic] Links: <value-of select="count(//link[@idref = $ids])"/> valid + <value-of select="count($idrefs) - count(//link[@idref = $ids])"/> invalid + <value-of select="count(//link[not(@idref)])"/> empty = <value-of select="count(//link)"/> total </diagnostic>
        <diagnostic id="info_02_en" xml:lang="en"> [Statistic] Link targets: <value-of select="count($ids[. = $idrefs])"/> used + <value-of select="count($ids) - count(//@id[. = $idrefs])"/> unused = <value-of select="count($ids)"/> total </diagnostic>
        <diagnostic id="info_03_en" xml:lang="en"> [Statistic] Media: <value-of select="$valid_filerefs"/> referenced + <value-of select="$all_filerefs - $valid_filerefs - $empty_filerefs"/> invalid + <value-of select="$empty_filerefs"/> empty = <value-of select="$all_filerefs"/> total </diagnostic>
        <diagnostic id="info_04_en" xml:lang="en"> [Statistic] Indices: <value-of select="string-join(distinct-values(//@index), ', ')"/></diagnostic>
        <diagnostic id="info_05_en" xml:lang="en"> No figure could be found in the file system, therefore the path check for figures has not been executed.</diagnostic>
    </diagnostics>

    <pattern id="metadata">
        <title>Metadatenprüfungen</title>
        <rule role="Doppelte Metadaten prüfen" id="rule-2" abstract="true">
            <!--       <report test="count(parent::*/*[name()=current()/name() and @type=current()/@type])>1" sqf:fix="duplicates">Das Element <name/> mit Attributwert <value-of select="@type"/> ist mehrfach gesetzt. Bitte entfernen Sie doppelte Einträge</report>
            <report test="count(parent::*/*[name()=current()/name() and not(@type)])>1" sqf:fix="duplicates">Das Element <name/> wurde mehrfach verwendet. Bitte entfernen Sie die doppelten Angaben</report>
     -->
        </rule>
        <rule context="personid" role="Prüfung auf doppelte GP-Nummern">
            <report test="string-length(normalize-space(.)) = 0" diagnostics="metadata_01_de metadata_01_en"/>
            <report test="string-length(normalize-space(.)) > 0 and count(ancestor::contributors/person[@type=current()/parent::person/@type]/personid[. = current()]) > 1" diagnostics="metadata_02_de metadata_02_en"/>
            
        </rule>
        <rule context="materialid" role="Gültigkeit der Materialnummer prüfen">
            <report test="((. = '1234560101') or (. = '1010654321') or (not(matches(., '^\d{6,10}$')) or (string-length(.) = 0)))" role="error" sqf:fix="april" diagnostics="metadata_03_de metadata_03_en"/>
            <!--report test=". = '1010654321'" sqf:fix="april" diagnostics="metadata_04_de metadata_04_en"/>
            <assert test="matches(., '^\d{6,10}$') or string-length(.) = 0" sqf:fix="april" diagnostics="metadata_05_de metadata_05_en"/-->
            <extends rule="rule-2"/>

            <sqf:fix id="april">
                <sqf:description>
                    <sqf:title ref="fix_april_title_de fix_april_title_en"/>
                </sqf:description>
                <sqf:stringReplace regex="^.+$" match="text()" select="codepoints-to-string(reverse(string-to-codepoints(substring(replace(., '\D', '0'), 1, 10))))"/>
            </sqf:fix>
        </rule>
        <rule context="isbn" role="Gültigkeit der ISBN-Nummer prüfen">
            <let name="checksum" value="number(substring(., string-length(), 1))"/>
            <let name="digits" value="
                    for $i in reverse(string-to-codepoints(substring(., 1, string-length() - 1)))
                    return
                        $i - 48"/>
            <let name="calculation" value="
                    sum((for $i in $digits[(position()) mod 2 = 1]
                    return
                        $i * 3,
                    for $i in $digits[(position()) mod 2 = 0]
                    return
                        $i)) mod 10"/>
            <report test="
                    string-length(.) ne 13 or (if ($calculation ne 0) then
                        (10 - $calculation)
                    else
                        0) ne $checksum" role="error" diagnostics="metadata_06_de metadata_06_en"/>
            <extends rule="rule-2"/>
        </rule>

        <!--rule context="language">
            <assert test="contains(upper-case(/*/@language), .)" role="warn" sqf:fix="metalanguage" diagnostics="metadata_07_de metadata_07_en"/>
            <sqf:fix id="metalanguage">
                <sqf:description>
                    <sqf:title ref="fix_metalanuage_title_de fix_metalanuage_title_en"/>
                </sqf:description>
                <sqf:stringReplace regex=".+" match="text()" select="upper-case(substring-before(/*/@language, '-'))"/>
            </sqf:fix>
        </rule-->

        <rule context="docdate" role="Gültigkeit des Datums prüfen">
            <assert test="matches(., '^([\d]{4})-(1[0-2]|0[1-9])-(3[0-1]|0[1-9]|[1-2][\d])$')" role="error" diagnostics="metadata_08_de metadata_08_en"/>
            <extends rule="rule-2"/>
        </rule>
        <rule context="doi">
            <report test="matches(., '[^a-z0-9\.\-/]')" diagnostics="metadata_09_de metadata_09_en"/>
            <extends rule="rule-2"/>
        </rule>
        <rule context="meta/*[not(name() = 'collaborator')]" role="Doppelte Metadaten prüfen">
            <extends rule="rule-2"/>
        </rule>
        <rule context="document/meta">
            <assert test="doi" role="error" diagnostics="metadata_10_de metadata_10_en"/>
        </rule>
        <rule context="@startnum">
            <sqf:fix id="startnum-dups">
                <sqf:description>
                    <sqf:title ref="fix_startnum-dups_title_de fix_startnum-dups_title_en"/>
                    <sqf:p ref="fix_startnum-dups_p_de fix_startnum-dups_p_en"/>
                </sqf:description>
                <sqf:delete match="//(document | section)/@startnum[not(generate-id() = generate-id(current()))]"/>
            </sqf:fix>
            <report test="count(//(document | section)/@startnum) > 1" sqf:fix="startnum-dups" diagnostics="metadata_11_de metadata_11_en"/>
        </rule>
    </pattern>

    <diagnostics>
        <diagnostic id="metadata_01_de" xml:lang="de">Das Element <value-of select="name()"/> darf nicht leer sein.</diagnostic>
        <diagnostic id="metadata_02_de" xml:lang="de">Die GP-Nummer <value-of select="current()"/> in <value-of select="name()"/> wurde mehrfach verwendet. Bitte entfernen Sie das Duplikat.</diagnostic>
        <diagnostic id="metadata_03_de" xml:lang="de">Die Materialnummer muss aus einer sechs- bis zehnstelligen Zahl bestehen, die weder die Beispielnummer noch die umgekehrte Beispielnummer ist.</diagnostic>
        <!--diagnostic id="metadata_04_de" xml:lang="de">Auch die umgekehrte Beispielnummer darf nicht als Materialnummer verwendet werden.</diagnostic>
        <diagnostic id="metadata_05_de" xml:lang="de">Die Materialnummer muss aus einer sechs- bis zehnstelligen Zahl bestehen.</diagnostic-->
        <diagnostic id="metadata_06_de" xml:lang="de">Die ISBN-Nummer hat eine ungültige Prüfziffer und sollte überprüft werden.</diagnostic>
        <diagnostic id="metadata_07_de" xml:lang="de">Die Sprache des Dokuments weicht von der Sprachangabe in den Metadaten ab. Bitte prüfen Sie die Sprachangaben.</diagnostic>
        <diagnostic id="metadata_08_de" xml:lang="de">Das Datum sollte auf JJJJ-MM-TT geändert werden, damit es ISO 8601 entspricht.</diagnostic>
        <diagnostic id="metadata_09_de" xml:lang="de">Der DOI darf nur Buchstaben, Zahlen, Punkte, Bindestriche und Slashes (/) enthalten.</diagnostic>
        <diagnostic id="metadata_10_de" xml:lang="de">Dieses Werk enthält keinen DOI, dieser wird für den Buchprozess jedoch benötigt (Ausnahme: TRIAS)</diagnostic>
        <diagnostic id="metadata_11_de" xml:lang="de">Das Dokument enthält mehrere Startnummern, darf aber nur eine Startnummer enthalten.</diagnostic>
        <!-- quickfixes -->
        <diagnostic id="fix_april_title_de">Ändere die Nummer</diagnostic>
        <diagnostic id="fix_metalanguage_title_de">An Dokumentsprache angleichen</diagnostic>
        <diagnostic id="fix_startnum-dups_title_de">Duplikate entfernen</diagnostic>
        <diagnostic id="fix_startnum-dups_p_de">Entfernt Duplikate und behält das ausgewählte Element bei</diagnostic>
        <!-- EN -->
        <diagnostic id="metadata_01_en" xml:lang="en">The element <value-of select="name()"/> should not be empty.</diagnostic>
        <diagnostic id="metadata_02_en" xml:lang="en">The business partner number <value-of select="current()"/> in <value-of select="name()"/> was used more than once. Please remove the duplicate.</diagnostic>
        <diagnostic id="metadata_03_en" xml:lang="en">This sample number should not be used as a material number.</diagnostic>
        <diagnostic id="metadata_04_en" xml:lang="en">Also the reversed sample number should not be used as a material number.</diagnostic>
        <diagnostic id="metadata_05_en" xml:lang="en">The material number should consist of a number with six to ten digits.</diagnostic>
        <diagnostic id="metadata_06_en" xml:lang="en">The check digit of this isbn is invalid and should be corrected.</diagnostic>
        <diagnostic id="metadata_07_en" xml:lang="en">The language of the document differs from the language specified in the metadata. Please check the language information.</diagnostic>
        <diagnostic id="metadata_08_en" xml:lang="en">The date should be changed to YYYY-MM-DD to comply with ISO 8601.</diagnostic>
        <diagnostic id="metadata_09_en" xml:lang="en">The DOI may only contain letters, numbers, dots, hyphens and slashes (/).</diagnostic>
        <diagnostic id="metadata_10_en" xml:lang="en">This work does not contain a DOI, which is however required for books.</diagnostic>
        <diagnostic id="metadata_11_en" xml:lang="en">The document contains several start numbers but should contain only one start number.</diagnostic>
        <!-- quickfixes -->
        <diagnostic id="fix_april_title_en">Change the number</diagnostic>
        <diagnostic id="fix_metalanguage_title_en">Change to document language</diagnostic>
        <diagnostic id="fix_startnum-dups_title_en">Remove duplicates</diagnostic>
        <diagnostic id="fix_startnum-dups_p_en">Removes duplicates and keeps the selected element</diagnostic>
    </diagnostics>

    <pattern id="links">
        <title>Verlinkungen</title>
        <rule context="link/@idref" role="Gültigkeitsprüfungen für gesetzte Links">
            <report test="matches(., '[^A-Za-z0-9:_\.\-]')" sqf:fix="sonderzeichen" diagnostics="links_01_de links_01_en"/>
            <assert test=". = $ids" role="warn" diagnostics="links_02_de links_02_en"/>
            <sqf:fix id="sonderzeichen">
                <sqf:description>
                    <sqf:title ref="fix_sonderzeichen_title_de fix_sonderzeichen_title_en"/>
                    <sqf:p ref="fix_sonderzeichen_p_de fix_sonderzeichen_p_en"/>
                </sqf:description>
                <let name="clean_id" value="replace(., '[^A-Za-z0-9:_\.\-]', '_')"/>
                <sqf:replace node-type="attribute" match="$ids[. = current()]" target="id" use-when="not($ids[. = $clean_id])">
                    <value-of select="$clean_id"/>
                </sqf:replace>
                <sqf:replace node-type="attribute" target="idref" use-when="not($ids[. = $clean_id])">
                    <value-of select="$clean_id"/>
                </sqf:replace>
            </sqf:fix>
        </rule>
        <rule context="link[@idref = $ids]" role="Gültigkeitsprüfung für alle Links">
            <let name="id" value="@idref"/>
            <let name="element" value="(//*[@id = $id])[1]"/>
            <report role="error" test="@idref = $ids and @target = ('audio', 'figure', 'video') and not($element/name() = ('figure', 'subfigure'))" diagnostics="links_03_de links_03_en"/>
            <report role="error" test="@idref = $ids and @target = ('box', 'formula', 'part', 'section', 'table') and not($element/name() = @target)" sqf:fix="target" diagnostics="links_04_de links_04_en"/>
            <!--OPEN Als Linkziel ist litref erlaubt, moniert wird jnref als ungültiges Ziel, jnref ist aber Kind von litref, sollte es nicht gültig sein-->
            <report role="error" test="@idref = $ids and @target = 'literature' and not($element/name() = ('literature', 'litref'))" diagnostics="links_05_de links_05_en"/>
            <report role="error" test="@idref = $ids and @target = 'excursus' and not($element/name() = ('section'))" diagnostics="links_06_de links_06_en"/>
            <report test="@target = 'page' and string-length(normalize-space(.)) = 0" diagnostics="links_07_de links_07_en"/>
            <report role="warn" test="@target = ('audio', 'figure', 'video', 'table') and (following-sibling::node()[1]/@target = 'page' or string-length(normalize-space(following-sibling::node()[1])) &lt; 5 and following-sibling::node()[2]/@target = 'page')" diagnostics="links_08_de links_08_en"/>
            <sqf:fix id="target">
                <sqf:description>
                    <sqf:title ref="fix_target_title_de fix_target_title_en"/>
                    <sqf:p ref="fix_target_p_de fix_target_p_en"/>
                </sqf:description>
                <sqf:add target="target" node-type="attribute" select="$element/name()" use-when="$element/name() = ('box', 'formula', 'part', 'section', 'table')"/>
            </sqf:fix>
        </rule>
        <rule context="uri" role="Uris prüfen">
            <assert test="@type = 'email' or matches(@href, '^(https?|ftp)://[^\s/$\.?#\\]+\.[^\s\\]+$')" diagnostics="links_09_de links_09_en"/>
            <report test="@type = 'email' and not(matches(@href, '^[^0-9\s]\S+@\S+\.\S+$'))" diagnostics="links_10_de links_10_en"/>
        </rule>
        <rule context="para/text() | emph/text() | footnote/text() | literature/text()" role="Text mit möglichen Uris">
            <report test="contains(., 'www.') or contains(., 'http')" sqf:fix="uri" diagnostics="links_11_de links_11_en"/>
            <report role="error" test="matches(., '[^0-9\s]\S+@\S+\.\S+')" sqf:fix="uri-mail" diagnostics="links_12_de links_12_en"/>
            <sqf:fix id="uri">
                <sqf:description>
                    <sqf:title ref="fix_uri_title_de fix_uri_title_en"/>
                    <sqf:p ref="fix_uri_p_de fix_uri_p_en"/>
                </sqf:description>
                <sqf:stringReplace regex="(((https?|ftp)://|www\.)[^\s/$.?#].[^\s]*)">
                    <xsl:analyze-string select="." regex="(((https?|ftp)://|www\.)[^\s/$.?#].[^\s]*)">
                        <xsl:matching-substring>
                            <uri xmlns="" href="{if(starts-with(regex-group(1),'www')) then 'http://' else ''}{regex-group(1)}">
                                <xsl:copy-of select="regex-group(1)"/>
                            </uri>
                        </xsl:matching-substring>
                    </xsl:analyze-string>
                </sqf:stringReplace>
            </sqf:fix>
            <sqf:fix id="uri-mail">
                <sqf:description>
                    <sqf:title ref="fix_uri-mail_title_de fix_uri-mail_title_en"/>
                    <sqf:p ref="fix_uri-mail_p_de fix_uri-mail_p_en"/>
                </sqf:description>
                <sqf:stringReplace regex="(\S+@\S+\.\S+)">
                    <xsl:analyze-string select="." regex="(\S+@\S+\.\S+)">
                        <xsl:matching-substring>
                            <uri xmlns="" href="{regex-group(1)}" type="email">
                                <xsl:copy-of select="regex-group(1)"/>
                            </uri>
                        </xsl:matching-substring>
                    </xsl:analyze-string>
                </sqf:stringReplace>
            </sqf:fix>
        </rule>
        <rule context="figure" role="Prüfung auf fehlerhaft verlinkte Abbildungen">
            <assert test="@counter = 'no' or .//@id = $idrefs" role="warn" diagnostics="links_13_de links_13_en"/>
            <report test="//link[@idref = current()//@id and @target = ('audio', 'figure', 'video')] and not(.//legend | .//title)" role="error" sqf:fix="addlegend" diagnostics="links_14_de links_14_en"/>
            <let name="filerefs" value=".//@fileref[string-length(normalize-space()) > 0]"/>
            <assert test="count(distinct-values($filerefs)) = count($filerefs)" diagnostics="links_15_de links_15_en"/>
        </rule>
        <rule context="table" role="Prüfung auf fehlerhaft verlinkte Tabellen">
            <assert test="@counter = 'no' or .//@id = $idrefs" role="warn" diagnostics="links_16_de links_16_en"/>
        </rule>
    </pattern>

    <diagnostics>
        <diagnostic id="links_01_de" xml:lang="de">IDs dürfen keine Sonderzeichen enthalten, da dies zu Problemen in EPUBs oder Webanwendungen führen könnte.</diagnostic>
        <diagnostic id="links_02_de" xml:lang="de">Link <value-of select="current()"/> hat kein gültiges Ziel, in der Gesamtstruktur muss dieser Fehler behoben werden.</diagnostic>
        <diagnostic id="links_03_de" xml:lang="de">Dieser Link mit @target=<value-of select="@target"/> verweist auf <value-of select="$element/name()"/> und nicht auf eine Abbildung. Das Ziel muss (sub-)figure sein.</diagnostic>
        <diagnostic id="links_04_de" xml:lang="de">Dieser Link mit @target=<value-of select="@target"/> verweist auf <value-of select="$element/name()"/>, muss aber auf <value-of select="@target"/> verweisen.</diagnostic>
        <diagnostic id="links_05_de" xml:lang="de">Dieser Link mit @target=<value-of select="@target"/> verweist auf <value-of select="$element/name()"/> und nicht auf eine Literaturstelle. Das Ziel muss literature oder litref sein.</diagnostic>
        <diagnostic id="links_06_de" xml:lang="de">Dieser Link mit @target=<value-of select="@target"/> verweist auf <value-of select="$element/name()"/> und nicht auf ein Kapitel. Das Ziel muss section sein.</diagnostic>
        <diagnostic id="links_07_de" xml:lang="de">Dieser Seitenverweis muss echten Text zwischen &lt;link ...&gt; und &lt;/link&gt; beinhalten.</diagnostic>
        <diagnostic id="links_08_de" xml:lang="de">Laut Redaktionsrichtlinie darf auf einen Abbildungs- oder Tabellenverweis kein Seitenverweis folgen.</diagnostic>
        <diagnostic id="links_09_de" xml:lang="de">Die angegebene URL ist nicht zulässig, da sie falsch formatiert ist oder ungültige Zeichen beinhaltet.</diagnostic>
        <diagnostic id="links_10_de" xml:lang="de">Die angegebene E-Mail ist nicht zulässig.</diagnostic>
        <diagnostic id="links_11_de" xml:lang="de">In diesem Absatz ist eine Webadresse nicht verlinkt. Damit Links anklickbar sind, müssen diese mit uri ausgezeichnet werden.</diagnostic>
        <diagnostic id="links_12_de" xml:lang="de">Möglicherweise ist in diesem Absatz eine E-Mail-Adresse nicht verlinkt. Damit Links anklickbar sind, müssen diese mit uri ausgezeichnet werden.</diagnostic>
        <diagnostic id="links_13_de" xml:lang="de">Diese nummerierte <value-of select="name()"/> ist nicht im Text verlinkt, es sollten aber alle <value-of select="name()"/>s im Text referenziert sein (redaktionelle Anforderung).</diagnostic>
        <diagnostic id="links_14_de" xml:lang="de">Auf diesen Abbildungscontainer wurde verlinkt (<value-of select=".//@id[. = $idrefs]"/>). Er benötigt daher einen Titel oder eine Legende, damit eine Abbildungsnummer generiert werden kann.</diagnostic>
        <diagnostic id="links_15_de" xml:lang="de">In dieser Figure wurde dieselbe Abbildung mehrfach referenziert, bitte Duplikate löschen.</diagnostic>
        <diagnostic id="links_16_de" xml:lang="de">Diese nummerierte <value-of select="name()"/> ist nicht im Text verlinkt, es sollten aber alle <value-of select="name()"/>s im Text referenziert sein (redaktionelle Anforderung).</diagnostic>
        <!-- quick fixes -->
        <diagnostic id="fix_sonderzeichen_title_de" xml:lang="de">Sonderzeichen aus IDs entfernen und durch Unterstriche ersetzen.</diagnostic>
        <diagnostic id="fix_sonderzeichen_p_de" xml:lang="de">Dieser SQFix entfernt Sonderzeichen aus IDs</diagnostic>
        <diagnostic id="fix_target_title_de" xml:lang="de">Target-Attribut korrigieren</diagnostic>
        <diagnostic id="fix_target_p_de" xml:lang="de">Ändert das @target, damit es zum Zielknoten passt</diagnostic>
        <diagnostic id="fix_uri_title_de" xml:lang="de">Webadressen umwandeln</diagnostic>
        <diagnostic id="fix_uri_p_de" xml:lang="de">Versuche, die Webadressen in uri umzuwandeln</diagnostic>
        <diagnostic id="fix_uri-mail_title_de" xml:lang="de">E-Mail-Adressen umwandeln</diagnostic>
        <diagnostic id="fix_uri-mail_p_de" xml:lang="de">Versuche, die E-Mail-Adresse in uri umzuwandeln</diagnostic>


        <!-- EN -->
        <diagnostic id="links_01_en" xml:lang="en">IDs must not contain special characters, since this could cause problems in ePubs or web applications.</diagnostic>
        <diagnostic id="links_02_en" xml:lang="en">Link <value-of select="current()"/> has no valid target</diagnostic>
        <diagnostic id="links_03_en" xml:lang="en">This link with the @target=<value-of select="@target"/> refers to <value-of select="$element/name()"/> and not to a figure. The target should be (sub-)figure.</diagnostic>
        <diagnostic id="links_04_en" xml:lang="en">This link with the @target=<value-of select="@target"/> refers to <value-of select="$element/name()"/>, but should link to <value-of select="@target"/>.</diagnostic>
        <diagnostic id="links_05_en" xml:lang="en">This link with the @target=<value-of select="@target"/> refers to <value-of select="$element/name()"/> and not to a literature reference. The target should be either literature or litref.</diagnostic>
        <diagnostic id="links_06_en" xml:lang="en">This link with the @target=<value-of select="@target"/> refers to <value-of select="$element/name()"/> and not to a section. The target should be section.</diagnostic>
        <diagnostic id="links_07_en" xml:lang="en">This link should contain real text.</diagnostic>
        <diagnostic id="links_08_en" xml:lang="en">According to the editorial guidelines a figure or table reference must not be followed by a page reference.</diagnostic>
        <diagnostic id="links_09_en" xml:lang="en">The specified URL is not allowed, because it is formatted incorrectly or contains invalid characters.</diagnostic>
        <diagnostic id="links_10_en" xml:lang="en">The specified email is not allowed.</diagnostic>
        <diagnostic id="links_11_en" xml:lang="en">A web address in this paragraph is not linked. For links to be clickable, they must be marked with uri.</diagnostic>
        <diagnostic id="links_12_en" xml:lang="en">An e-mail address in this paragraph is not linked. For links to be clickable, they must be marked with uri.</diagnostic>
        <diagnostic id="links_13_en" xml:lang="en">This <value-of select="name()"/> is not linked, however all <value-of select="name()"/>s should be linked.</diagnostic>
        <diagnostic id="links_14_en" xml:lang="en">This figure container was linked to (<value-of select=".//@id[. = $idrefs]"/>). It therefore needs a title or legend so that a figure number can be generated.</diagnostic>
        <diagnostic id="links_15_en" xml:lang="en">In this figure the same image is referenced multiple times, please delete duplicates.</diagnostic>
        <diagnostic id="links_16_en" xml:lang="en">This <value-of select="name()"/> is not linked, however all <value-of select="name()"/>s should be linked.</diagnostic>
        <!-- quick fixes -->
        <diagnostic id="fix_sonderzeichen_title_en" xml:lang="en">Remove special characters from IDs and replace them with underscores.</diagnostic>
        <diagnostic id="fix_sonderzeichen_p_en" xml:lang="en">This SQFix removes special characters from IDs</diagnostic>
        <diagnostic id="fix_target_title_en" xml:lang="en">Correct the attribute @target</diagnostic>
        <diagnostic id="fix_target_p_en" xml:lang="en">Changes @target so it fits with the target node</diagnostic>
        <diagnostic id="fix_uri_title_en" xml:lang="en">Add uri to web addresses</diagnostic>
        <diagnostic id="fix_uri_p_en" xml:lang="en">Attempt to add uri to web addresses</diagnostic>
        <diagnostic id="fix_uri-mail_title_en" xml:lang="en">Add uri to e-mail addresses</diagnostic>
        <diagnostic id="fix_uri-mail_p_en" xml:lang="en">Attempt to add uri to e-mail addresses</diagnostic>
    </diagnostics>
        
    
    <pattern id="figures">
        <title>Mediencontainer</title>
        <rule context="@fileref[not[self::relpdfio]]" role="Gültigkeit der Medien prüfen">
            <let name="is_cs" value="starts-with(., 'censhare:///')"/>
            <report test="not($is_cs) and matches(., '[^a-zA-Z0-9_\-\. ]')" diagnostics="figures_01_de figures_01_en"/>
            <report test="not($is_cs) and matches(., '[A-Z ]')" role="warn" diagnostics="figures_02_de figures_02_en"/>
            <assert test="(matches(., '^[&#33;-&#126;]+$'))" diagnostics="figures_22_de figures_22_en"/>
            
        </rule>

        <rule context="@fileref" role="Gültigkeit der Medien prüfen">
            <let name="is_cs" value="starts-with(., 'censhare:///')"/>
            <report test="not($all_filerefs = $empty_filerefs) and string-length() = 0" diagnostics="figures_03_de figures_03_en"/>
            <report test="not($is_cs) and $valid_filerefs &gt; 0 and not(f:exists(f:new(resolve-uri(replace(., '[^a-zA-Z0-9_\-\.]', ''), base-uri()))))" role="warn" diagnostics="figures_04_de figures_04_en"/>
            <report test="$is_cs and $valid_filerefs &gt; 0 and not(doc-available((tokenize(., '/storage')[1])))" diagnostics="figures_05_de figures_05_en"/>
            <report test="matches(., 'censhare:/service')" role="error" diagnostics="figures_19_de figures_19_en"/>
            <report test="matches(., 'censhare://service')" role="error" diagnostics="figures_21_de figures_21_en"/>
            <assert test="(matches(., '^[&#33;-&#126;]+$'))" diagnostics="figures_22_de figures_22_en"/>
         </rule>

        <rule context="figure[count(subfigure) > 1]/subfigure" role="Prüfung auf Teilabbildungslegenden">
            <assert test="legend" sqf:fix="addlegends" diagnostics="figures_06_de figures_06_en"/>
            <sqf:fix id="addlegends">
                <sqf:description>
                    <sqf:title ref="fix_addlegends_title_de fix_addlegends_title_en"/>
                    <sqf:p ref="fix_addlegends_p_de fix_addlegends_p_en"/>
                </sqf:description>
                <sqf:add match="parent::*/subfigure[not(legend)]" position="last-child">
                    <legend xmlns="">
                        <para>█</para>
                    </legend>
                </sqf:add>
            </sqf:fix>
        </rule>
        <rule context="figure//para" role="Prüfung auf subfigures">
            <report test="//link[@idref = current()//@id and @target = ('audio', 'figure', 'video')]" diagnostics="figures_07_de figures_07_en"/>
        </rule>
        <rule context="tableau/graphic" role="Tableaus prüfen">
            <report test="@* except @fileref" sqf:fix="tableauclean" diagnostics="figures_08_de figures_08_en"/>
            <sqf:fix id="tableauclean">
                <sqf:description>
                    <sqf:title ref="fix_tableauclean_title_de fix_tableauclean_title_en"/>
                    <sqf:p ref="fix_tableauclean_p_de fix_tableauclean_p_en"/>
                </sqf:description>
                <sqf:delete match="@* except @fileref"/>
            </sqf:fix>
        </rule>
        <rule context="figure[subfigure/(video | audio)]" role="Prüfen auf nicht erlaubte Teilmedien">
            <report test="count(subfigure) &gt; 1" diagnostics="figures_09_de figures_09_en"/>
            <assert test="legend" role="error" sqf:fix="addlegend" diagnostics="figures_10_de figures_10_en"/>
        </rule>
        <rule context="audio" role="Prüfe audio-Attribute">
            <assert test="ends-with(@fileref, '.mp3')" role="error" diagnostics="figures_11_de figures_11_en"/>
        </rule>
        <rule context="video" role="Prüfe video-Attribute">
            <assert test="ends-with(@fileref, '.mp4')" role="error" diagnostics="figures_12_de figures_12_en"/>
        </rule>
        <rule context="graphic[not(@fileref = '') and not(starts-with(@fileref, 'censhare://'))]" role="Prüfe graphic-Attribute">
            <assert test="matches(@fileref, '\.(eps|tif|jpg|png|gif|svg)$')" role="warn" diagnostics="figures_13_de figures_13_en"/>
        </rule>
        <rule context="@rights" role="Prüfe rights-Attribut">
            <assert test=". = '3rdparty'" role="error" sqf:fix="thirdparty remvalue" diagnostics="figures_14_de figures_14_en"/>
            <sqf:fix id="thirdparty">
                <sqf:description>
                    <sqf:title ref="fix_thirdparty_title_de fix_thirdparty_title_en"/>
                    <sqf:p ref="fix_thirdparty_p_de fix_thirdparty_p_en"/>
                </sqf:description>
                <sqf:replace node-type="attribute" target="rights">3rdparty</sqf:replace>
            </sqf:fix>
        </rule>
        <rule context="table//figure" role="Prüfe Abbildungen in Tabellen">
            <assert test="@counter = 'no'" diagnostics="figures_15_de figures_15_en"/>
            <report test=".//legend" sqf:fix="remelm" diagnostics="figures_16_de figures_16_en"/>
        </rule>
        <rule context="figure[not(title)]/legend[para]">
            <report test="string-length(normalize-space(.)) = 0" diagnostics="figures_17_de figures_17_en"/>
        </rule>
        <rule context="(figure | subfigure)[./meta/metadata[@type = 'source']]">
            <report test="(.//graphic | .//audio | .//video)/@source" role="error" diagnostics="figures_18_de figures_18_en"/>
        </rule>
        <rule context="subfigure[@id]/legend">
            <report test="./simplelist[not(preceding-sibling::para)]" role="error" diagnostics="figures_20_de figures_20_en"/>
        </rule>
    </pattern>

    <diagnostics>
        <diagnostic id="figures_01_de" xml:lang="de">Die Mediendatei <value-of select="."/> enthält Sonderzeichen und kann nicht geprüft werden.</diagnostic>
        <diagnostic id="figures_02_de" xml:lang="de">Die Mediendatei <value-of select="."/> sollte keine Leerzeichen oder Großbuchstaben enthalten.</diagnostic>
        <diagnostic id="figures_03_de" xml:lang="de">Sie müssen diesem Mediencontainer einen Dateinamen geben.</diagnostic>
        <diagnostic id="figures_04_de" xml:lang="de">Die Mediendatei <value-of select="."/> fehlt im Dateisystem.</diagnostic>
        <diagnostic id="figures_05_de" xml:lang="de">Die Mediendatei <value-of select="."/> fehlt in censhare.</diagnostic>
        <diagnostic id="figures_06_de" xml:lang="de">Abbildungen mit mehr als einer Teilabbildung benötigen Teilabbildungslegenden.</diagnostic>
        <diagnostic id="figures_07_de" xml:lang="de">Bei Verweisen auf (Teil-)Abbildungen muss die id des (sub-)figure-Elements genutzt werden.</diagnostic>
        <diagnostic id="figures_08_de" xml:lang="de">Die Tableau-Abbildung darf außer @fileref keine weiteren Attribute beinhalten.</diagnostic>
        <diagnostic id="figures_09_de" xml:lang="de">Eine <value-of select="name()"/> mit audio oder video darf nur eine subfigure beinhalten.</diagnostic>
        <diagnostic id="figures_10_de" xml:lang="de">Eine <value-of select="name()"/> mit <value-of select="(subfigure/(video | audio))[1]"/><!--<name path="(subfigure/(video | audio))[1]"/>--> benötigt für e-Produkte eine Legende.</diagnostic>
        <diagnostic id="figures_11_de" xml:lang="de"><value-of select="name()"/> benötigt als Dateiendung '.mp3'.</diagnostic>
        <diagnostic id="figures_12_de" xml:lang="de"><value-of select="name()"/> benötigt als Dateiendung '.mp4'.</diagnostic>
        <diagnostic id="figures_13_de" xml:lang="de"><value-of select="name()"/> benötigt als Dateiendung '.eps', '.tif', '.jpg', '.png', '.gif', '.svg'.</diagnostic>
        <diagnostic id="figures_14_de" xml:lang="de"><value-of select="name()"/> darf nur 3rdparty enthalten.</diagnostic>
        <diagnostic id="figures_15_de" xml:lang="de">Abbildungen in Tabellen müssen immer auf counter=no gesetzt sein.</diagnostic>
        <diagnostic id="figures_16_de" xml:lang="de">Abbildungen in Tabellen dürfen keine Legenden beinhalten.</diagnostic>
        <diagnostic id="figures_17_de" xml:lang="de">Legenden in Abbildungen ohne Titel dürfen nicht leer bleiben, da dies bei der Höhenberechnung der Grafiken im eFlow stört.</diagnostic>
        <diagnostic id="figures_18_de" xml:lang="de">Die Quellenangaben dürfen nur einmal gepflegt werden: entweder in @source oder als metadata@type='source'.</diagnostic>
        <diagnostic id="figures_19_de" xml:lang="de">Fehlerhafter censhare-Pfad (censhare:/ statt censhare:///)</diagnostic>
        <diagnostic id="figures_20_de" xml:lang="de">Eine Abbildung, auf die verwiesen wird, darf nicht nur eine &lt;simplelist&gt; in der Legende enthalten. Bitte vor der Liste einen inhaltlich sinnvollen &lt;para&gt; oder notfalls einen leeren &lt;para&gt; ergänzen.</diagnostic>
        <diagnostic id="figures_21_de" xml:lang="de">Fehlerhafter censhare-Pfad (censhare:// statt censhare:///)</diagnostic>
        <diagnostic id="figures_22_de" xml:lang="de">Zulässig sind nur ASCII-Code-Zeichen (idealerweise nur Ziffern, Groß-, Kleinbuchstaben, Unter-, Bindestriche, Punkt). Umlaute und andere Sonderzeichen verursachen einen Abbruch des 3B2-Prozesses.</diagnostic>
        
        <!-- quickfixes -->
        <diagnostic id="fix_addlegends_title_de" xml:lang="de">Legenden hinzufügen</diagnostic>
        <diagnostic id="fix_addlegends_p_de" xml:lang="de">Fügt die Struktur für Teilabbildungslegenden hinzu</diagnostic>
        <diagnostic id="fix_tableauclean_title_de" xml:lang="de">Falsche Attribute entfernen</diagnostic>
        <diagnostic id="fix_tableauclean_p_de" xml:lang="de">Alle falsch gesetzten Attribute löschen</diagnostic>
        <diagnostic id="fix_thirdparty_title_de" xml:lang="de">3rdparty setzen</diagnostic>
        <diagnostic id="fix_thirdparty_p_de" xml:lang="de">Den Attibutwert in 3rdparty ändern</diagnostic>
        <!-- EN -->
        <diagnostic id="figures_01_en" xml:lang="en">The media file <value-of select="."/> contains special characters and cannot be checked.</diagnostic>
        <diagnostic id="figures_02_en" xml:lang="en">The media file <value-of select="."/> should not contain blank spaces or capital letters.</diagnostic>
        <diagnostic id="figures_03_en" xml:lang="en">You must assign a file name to this media container.</diagnostic>
        <diagnostic id="figures_04_en" xml:lang="en">The media file <value-of select="."/> is missing from the file system.</diagnostic>
        <diagnostic id="figures_05_en" xml:lang="en">The media file <value-of select="."/> is missing in censhare.</diagnostic>
        <diagnostic id="figures_06_en" xml:lang="en">Figures with more than one subfigure require subfigure legends.</diagnostic>
        <diagnostic id="figures_07_en" xml:lang="en">For references to figures, the (sub-)figure element must be used.</diagnostic>
        <diagnostic id="figures_08_en" xml:lang="en">This tableau-figure should not contain attributes other than @fileref.</diagnostic>
        <diagnostic id="figures_09_en" xml:lang="en">A <value-of select="name()"/> containing audio or video must contain only one subfigure.</diagnostic>
        <diagnostic id="figures_10_en" xml:lang="en">A <value-of select="name()"/> with <value-of select="(subfigure/name(video | audio))[1]"/> requires a legend for e-products.</diagnostic>
        <diagnostic id="figures_11_en" xml:lang="en"><value-of select="name()"/> requires '.mp3' as a file extension.</diagnostic>
        <diagnostic id="figures_12_en" xml:lang="en"><value-of select="name()"/> requires '.mp4' as a file extension.</diagnostic>
        <diagnostic id="figures_13_en" xml:lang="en"><value-of select="name()"/> requires '.eps', '.tif', '.jpg', '.png', '.gif', '.svg' as a file extension.</diagnostic>
        <diagnostic id="figures_14_en" xml:lang="en"><value-of select="name()"/> must contain 3rdparty only.</diagnostic>
        <diagnostic id="figures_15_en" xml:lang="en">Figures in tables must always be set to counter="no".</diagnostic>
        <diagnostic id="figures_16_en" xml:lang="en">Figures in tables must not contain legends.</diagnostic>
        <diagnostic id="figures_17_en" xml:lang="en">Legends in figures must not remain empty since this interferes with calculating the height of the figures in eFlow.</diagnostic>
        <diagnostic id="figures_18_en" xml:lang="en">The information on figure sources is redundant. You should either use @source or metadata@type='source'.</diagnostic>
        <diagnostic id="figures_19_en" xml:lang="en">Incorrect censhare path (censhare:/ instead of censhare:///)</diagnostic>
        <diagnostic id="figures_20_en" xml:lang="en">A referenced figure must not solely contain a &lt;simplelist&gt; in the legend. Please add a meaningful &lt;para&lt; or, if needed, an empty &lt;para&lt; before the list.</diagnostic>
        <diagnostic id="figures_21_en" xml:lang="en">Incorrect censhare path (censhare:// instead of censhare:///)</diagnostic>
        <diagnostic id="figures_22_en" xml:lang="en">Only ASCII code characters are permitted, as otherwise the 3B2 process will abort.</diagnostic>
        
        
        <!-- quickfixes -->
        <diagnostic id="fix_addlegends_title_en" xml:lang="en">Add legends</diagnostic>
        <diagnostic id="fix_addlegends_p_en" xml:lang="en">Adds the structure for subfigure legends</diagnostic>
        <diagnostic id="fix_tableauclean_title_en" xml:lang="en">Remove incorrect attributes</diagnostic>
        <diagnostic id="fix_tableauclean_p_en" xml:lang="en">Remove all incorrectly placed attributes</diagnostic>
        <diagnostic id="fix_thirdparty_title_en" xml:lang="en">Place 3rdparty</diagnostic>
        <diagnostic id="fix_thirdparty_p_en" xml:lang="en">Change the attribute value to 3rdparty</diagnostic>
    </diagnostics>

    <pattern id="tablesBoxes">
        <title>Tabellen in Boxen</title>
        <rule context="box/table" role="Prüfung auf Tabellengröße in Boxen">
            <assert test="@size = 's'" sqf:fix="boxsizes" diagnostics="tables_01_de tables_01_en"/>
            <sqf:fix id="boxsizes">
                <sqf:description>
                    <sqf:title ref="fix_boxsizes_title_de fix_boxsizes_title_en"/>
                    <sqf:p ref="fix_boxsizes_p_de fix_boxsizes_p_en"/>
                </sqf:description>
                <sqf:add target="size" node-type="attribute">s</sqf:add>
            </sqf:fix>
        </rule>
    </pattern>
    
    <diagnostics>
        <diagnostic id="tables_01_de" xml:lang="de">Tabellen in Boxen müssen die Größe "s" haben (@size).</diagnostic>
        <!-- quickfixes -->
        <diagnostic id="fix_boxsizes_title_de" xml:lang="de">size auf "s" setzen</diagnostic>
        <diagnostic id="fix_boxsizes_p_de" xml:lang="de">Setzt die Größenangabe der Tabelle auf den Wert "s"</diagnostic>
         <!-- EN -->
        <diagnostic id="tables_01_en" xml:lang="en">Tables in boxes must be of the size "s" (@size).</diagnostic>
        <!-- quickfixes -->
        <diagnostic id="fix_boxsizes_title_en" xml:lang="en">Set size to "s"</diagnostic>
        <diagnostic id="fix_boxsizes_p_en" xml:lang="en">Sets the size attribute of the table to the value "s"</diagnostic>
         </diagnostics>

    <pattern id="tables">
        <title>Tabellen</title>
        <rule context="col" role="Prüfe auf gültigen col-Wert">
            <assert test="matches(@width, '^\d+(%|px|pt)?$')" diagnostics="tables_02_de tables_02_en"/>
        </rule>
        <rule context="table" role="Colspan- und Tabellenkopf-Überprüfung bei Tabellen">
            <let name="colsnr" value=".//col/number(replace(@width, '[^\d]', ''))"/>
            <assert test="
                    count(.//tr) * count(.//col) = sum(for $n in .//(td | th)
                    return
                        number(($n/@colspan,
                        '1')[1]) * number(($n/@rowspan,
                        '1')[1]))" diagnostics="tables_03_de tables_03_en"/>
            <report test="count(distinct-values(.//col/replace(@width, '\d', ''))) > 1" subject="col" diagnostics="tables_04_de tables_04_en"/>
            <report test="max($colsnr) &gt; min($colsnr) * 10" role="warn" diagnostics="tables_05_de tables_05_en"/>
            <assert role="warn" test="thead" sqf:fix="addthead" diagnostics="tables_06_de tables_06_en"/>
            <sqf:fix id="addthead">
                <sqf:description>
                    <sqf:title ref="fix_addthead_title_de fix_addthead_title_en"/>
                    <sqf:p ref="fix_addthead_p_de fix_addthead_p_en"/>
                </sqf:description>
                <sqf:add target="thead" node-type="element" position="first-child" select="tbody/tr[1]"/>
                <sqf:delete match="tbody/tr[1]"/>
            </sqf:fix>
        </rule>
    </pattern>

    <diagnostics>
        <diagnostic id="tables_02_de" xml:lang="de">Der col-Wert ist ungültig. Erlaubt sind nur Zahlen; optional mit den Einheiten %, px oder p.</diagnostic>
        <diagnostic id="tables_03_de" xml:lang="de">Die Anzahl der Zellen ist ungültig. Bitte überprüfen Sie die Anzahl der col-Elemente, sowie die Attribute @colspan und @rowspan. Bei der Fehlersuche hilft die Autorenansicht.</diagnostic>
        <diagnostic id="tables_04_de" xml:lang="de">Es dürfen nur gleiche Maßeinheiten in einer Tabelle verwendet werden.</diagnostic>
        <diagnostic id="tables_05_de" xml:lang="de">Die Spaltenbreiten weisen extreme Verhältnisse auf (liegen mehr als um den Faktor 10 auseinander) und müssen überprüft werden.</diagnostic>
        <diagnostic id="tables_06_de" xml:lang="de">Die Tabelle hat keine Kopfzeile. Falls die Tabelle eine Kopfzeile besitzt, strukturieren Sie diese bitte mit thead.</diagnostic>
        <diagnostic id="tables_07_de" xml:lang="de">Tabelle Test</diagnostic>
        <!-- quickfixes -->
        <diagnostic id="fix_addthead_title_de" xml:lang="de">Erste Zeile in thead umwandeln</diagnostic>
        <diagnostic id="fix_addthead_p_de" xml:lang="de">Verschiebt die erste Zeile in ein thead-Element</diagnostic>
        <!-- EN -->
        <diagnostic id="tables_02_en" xml:lang="en">The col-value is invalid. Only numbers are allowed; optionally with the units %, px or pt.</diagnostic>
        <diagnostic id="tables_03_en" xml:lang="en">The number of cells is invalid. Please check the number of col-elements, as well as the attributes @colspan and @rowspan.</diagnostic>
        <diagnostic id="tables_04_en" xml:lang="en">Only the same units of measurement may be used in a table.</diagnostic>
        <diagnostic id="tables_05_en" xml:lang="en">The column widths feature extreme ratios (values more than a factor of 10 apart) and need to be checked.</diagnostic>
        <diagnostic id="tables_06_en" xml:lang="en">The table does not have a headline. If the table has a headline, please structure it with thead.</diagnostic>
        <diagnostic id="tables_07_en" xml:lang="en">Tabelle Test</diagnostic>

        <!-- quickfixes -->
        <diagnostic id="fix_addthead_title_en" xml:lang="en">Mark first line with thead</diagnostic>
        <diagnostic id="fix_addthead_p_en" xml:lang="en">Marks the first line with a thead element</diagnostic>
    </diagnostics>

    <pattern id="listing">
        <title>Auflistungen</title>
        <rule context="listing" role="Prüfung der Listenelemente">
            <report role="warn" test="count(ancestor::listing) &gt; 2" diagnostics="listing_01_de listing_01_en"/>
            <report role="warn" test=".//(figure | table | box)" diagnostics="listing_02_de listing_02_en"/>
        </rule>
    </pattern>

    <diagnostics>
        <diagnostic id="listing_01_de" xml:lang="de">Mehr als drei Listenebenen sollten aufgrund von Darstellungsproblemen vermieden werden.</diagnostic>
        <diagnostic id="listing_02_de" xml:lang="de">Abbildungen, Tabellen und Boxen sollte wegen Darstellungsproblemen in Templates und Online-Applikationen nicht in <value-of select="name()"/> verwendet werden.</diagnostic>
        <!-- EN -->
        <diagnostic id="listing_01_en" xml:lang="en">More than three list levels should be avoided due to display problems.</diagnostic>
        <diagnostic id="listing_02_en" xml:lang="en">Figures, tables and boxes should not be used in <value-of select="name()"/> due to display problems in templates and online applications.</diagnostic>
    </diagnostics>

    <pattern id="container">
        <title>Sonderumgebungen</title>
        <rule context="box" role="Fehlerhafte Boxen">
            <assert role="warn" test="title" sqf:fix="addtitle" diagnostics="container_01_de container_01_en"/>
            <report test=".[@size = 'l']/(figure, table)[following-sibling::node()[name()]]" role="warn" diagnostics="container_02_de container_02_en"/>
        </rule>
        <!-- Ausgenommen wegen Bug in Saxon 9.6.0.5, gelöst in Oxygen 19/Saxon 9.7.0.15 -->
        <!--<rule context="quote" role="Autorenangabe bei Zitaten">
            <report role="warn" test="para[matches(string-join(text(),' ') , '^(\S+[\s,]*)+\d{4}')]">Eine Autorenangabe muss im origin-Feld eines Zitates stehen</report>
        </rule>-->
        <rule context="ingredient" role="Prüfung auf fehlerhafte Überschriften in Rezepten">
            <report role="warn" test="emph" subject="emph" sqf:fix="titlereplace" diagnostics="container_03_de container_03_en"/>
            <sqf:fix id="titlereplace">
                <sqf:description>
                    <sqf:title ref="fix_titlereplace_title_de fix_titlereplace_title_en"/>
                </sqf:description>
                <sqf:add target="title" node-type="element" position="before" select="emph/node()"/>
                <sqf:delete/>
            </sqf:fix>
        </rule>
    </pattern>

    <diagnostics>
        <diagnostic id="container_01_de" xml:lang="de">Bitte vergeben Sie an diese Box (<value-of select="@type"/>) einen Titel mit dem Element title.</diagnostic>
        <diagnostic id="container_02_de" xml:lang="de">Tabellen und Abbildungen in Boxen müssen am Ende der Box stehen.</diagnostic>
        <diagnostic id="container_03_de" xml:lang="de">Handelt es sich hier um eine (Zwischen-)Überschrift, dann bitte als title kennzeichnen und die Zutaten gruppieren.</diagnostic>
        <!-- quickfixes -->
        <diagnostic id="fix_titlereplace_title_de" xml:lang="de">durch Titel ersetzen</diagnostic>
        <!-- EN -->
        <diagnostic id="container_01_en" xml:lang="en">Please assign a title marked with the element title to this box (<value-of select="@type"/>).</diagnostic>
        <diagnostic id="container_02_en" xml:lang="en">Tables and figures in boxes must be positioned at the end of the box.</diagnostic>
        <diagnostic id="container_03_en" xml:lang="en">This is probably a headline, it must be marked with title.</diagnostic>
        <!-- quickfixes -->
        <diagnostic id="fix_titlereplace_title_en" xml:lang="en">replace with title</diagnostic>
    </diagnostics>

    <pattern id="indexentry">
        <title>Indexeinträge</title>
        <rule context="indexentry" role="Indexentry-Prüfung">
            <report role="warn" test="ends-with(preceding-sibling::node()[1][self::text()], ' ') and starts-with(following-sibling::node()[1][self::text()], ' ')" diagnostics="indexentry_01_de indexentry_01_en">Mehr als ein Leerzeichen umgibt indexentry</report>
            <report test="entry4, entry5, entry6" diagnostics="indexentry_02_de indexentry_02_en"/>
        </rule>
    </pattern>

    <diagnostics>
        <diagnostic id="indexentry_01_de" xml:lang="de">Mehr als ein Leerzeichen umgibt indexentry.</diagnostic>
        <diagnostic id="indexentry_02_de" xml:lang="de">Mehr als drei Ebenen in indexentry sind nicht mehr erlaubt.</diagnostic>
        <!-- EN -->
        <diagnostic id="indexentry_01_en" xml:lang="en">More than on blank space surrounds indexentry.</diagnostic>
        <diagnostic id="indexentry_02_en" xml:lang="en">More than three levels in indexentry are no longer allowed.</diagnostic>
    </diagnostics>


    <pattern id="partsection">
        <title>Kapitel und Werkteile</title>
        <rule context="document[part]" role="Prüfung auf erforderliche Werkteile">
            <assert test="count(part[@type = 'frontmatter']) = 1" sqf:fix="addparttype addfmpart" diagnostics="partsection_01_de partsection_01_en"/>
            <report test="count(part[@type = 'content']) &lt; 1" diagnostics="partsection_02_de partsection_02_en"/>
            <sqf:fix id="addparttype">
                <sqf:description>
                    <sqf:title ref="fix_addparttype_title_de fix_addparttype_title_en"/>
                    <sqf:p ref="fix_addparttype_p_de fix_addparttype_p_en"/>
                </sqf:description>
                <sqf:add target="type" match="part" node-type="attribute" select="
                        if (count(//part) > 1 and generate-id() = generate-id(//part[1])) then
                            'frontmatter'
                        else
                            'content'"/>
            </sqf:fix>
            <sqf:fix id="addfmpart">
                <sqf:description>
                    <sqf:title ref="fix_addfmpart_title_de fix_addfmpart_title_en"/>
                    <sqf:p ref="fix_addfmpart_p_de fix_addfmpart_p_en"/>
                </sqf:description>
                <sqf:add match="meta" position="after">
                    <part xmlns="" type="frontmatter">
                        <section>
                            <title>Überschrift</title>
                            <para>Einfacher Absatz</para>
                        </section>
                    </part>
                </sqf:add>
            </sqf:fix>
        </rule>
        <rule context="part[@type = 'frontmatter']/title" role="Frontmatter-Prüfung">
            <report test="." sqf:fix="remvalue" diagnostics="partsection_03_de partsection_03_en"/>
        </rule>
        <rule context="part/section" role="Prüfung der EPub-Dateigröße">
            <let name="size" value="string-length(string-join(.//*/text(), '')) * 1.4"/>
            <let name="maxsize" value="800000"/>
            <report test="$size > $maxsize and count(.//processing-instruction()) = 0" role="warn" diagnostics="partsection_04_de partsection_04_en"/>
        </rule>
        <rule context="part/trailer">
            <report test="." role="info" diagnostics="partsection_05_de partsection_05_en"/>
        </rule>
        <rule context="section/section" role="Absatzprüfung">
            <assert test="* except (title | shorttitle)" sqf:fix="remvalue" diagnostics="partsection_06_de partsection_06_en"/>
            <report test="count(ancestor::section) &gt; 6" diagnostics="partsection_07_de partsection_07_en"/>
        </rule>
    </pattern>

    <diagnostics>
        <diagnostic id="partsection_01_de" xml:lang="de">Pro Werk muss genau ein Frontmatter-Teil enthalten sein.</diagnostic>
        <diagnostic id="partsection_02_de" xml:lang="de">Pro Werk muss mindestens ein Content-Teil enthalten sein. Bitte das entsprechende type-Attribut an part vergeben.</diagnostic>
        <diagnostic id="partsection_03_de" xml:lang="de">Der Frontmatter-Teil darf keinen Titel enthalten.</diagnostic>
        <diagnostic id="partsection_04_de" xml:lang="de">Dieses Kapitel ist voraussichtlich um <value-of select="round(($size - $maxsize) div 1024)"/> kB zu groß und muss für EPub mit einer PI getrennt werden.</diagnostic>
        <diagnostic id="partsection_05_de" xml:lang="de">Der Part-Trailer wird nicht in jedem Template/jeder Layout-Konfiguration ausgegeben – bitte Ergebnis prüfen!</diagnostic>
        <diagnostic id="partsection_06_de" xml:lang="de">Dieses Kapitel ist leer, es muss neben dem Titel noch weitere Elemente beinhalten.</diagnostic>
        <diagnostic id="partsection_07_de" xml:lang="de">Es dürfen nicht mehr als sieben Kapitelhierarchiestufen verwendet werden.</diagnostic>
        <!-- quick fixes -->
        <diagnostic id="fix_addparttype_title_de" xml:lang="de">Part-Typen hinzufügen</diagnostic>
        <diagnostic id="fix_addparttype_p_de" xml:lang="de">Den ersten Part als "frontmatter", alle weiteren als "content" auszeichnen</diagnostic>
        <diagnostic id="fix_addfmpart_title_de" xml:lang="de">Frontmatter-Teil hinzufügen</diagnostic>
        <diagnostic id="fix_addfmpart_p_de" xml:lang="de">Fügt einen leeren Frontmatter-Teil ein</diagnostic>

        <!-- EN -->
        <diagnostic id="partsection_01_en" xml:lang="en">Exactly one frontmatter part must be included per book.</diagnostic>
        <diagnostic id="partsection_02_en" xml:lang="en">At least one content part must be included per book.</diagnostic>
        <diagnostic id="partsection_03_en" xml:lang="en">The frontmatter part must not contain a title.</diagnostic>
        <diagnostic id="partsection_04_en" xml:lang="en">This chapter is expected to be <value-of select="round(($size - $maxsize) div 1024)"/> kB too large and must be split with a PI for ePub.</diagnostic>
        <diagnostic id="partsection_05_en" xml:lang="en">The part-trailer is not created in every template or layout configuration – please check the result!</diagnostic>
        <diagnostic id="partsection_06_en" xml:lang="en">This chapter is empty, it must contain other elements besides title.</diagnostic>
        <diagnostic id="partsection_07_en" xml:lang="en">No more than seven chapter hierarchy levels are allowed to be used.</diagnostic>
        <!-- quick fixes -->
        <diagnostic id="fix_addparttype_title_en" xml:lang="en">Add part types</diagnostic>
        <diagnostic id="fix_addparttype_p_en" xml:lang="en">Mark the first part as frontmatter, all subsequent parts as content</diagnostic>
        <diagnostic id="fix_addfmpart_title_en" xml:lang="en">Add frontmatter part</diagnostic>
        <diagnostic id="fix_addfmpart_p_en" xml:lang="en">Adds an empty frontmatter part</diagnostic>
    </diagnostics>


    <pattern id="para">
        <title>Absätze</title>
        <rule abstract="true" id="rule-1" role="Prüfung auf Whitespace">
            <report role="warn" test="starts-with(descendant::text()[1], ' ') and not(name(*[1]) = 'link')" diagnostics="para_01_de para_01_en"/>
        </rule>
        <rule context="emph" role="Prüfung der Auszeichnungen">
            <report role="warn" test="string-length(normalize-space()) = 0" sqf:fix="remelm" diagnostics="para_03_de para_03_en"/>
        </rule>
        <rule context="para" role="Paraprüfung">
            <report test="uri[@type = 'qrcode'] and count(descendant::text()| descendant::processing-instruction()) &gt; 1" diagnostics="para_04_de para_04_en"/>
            <extends rule="rule-1"/>
        </rule>
        <rule context="para | paratitle1 | paratitle2 | trailer | ingredient | header1 | header2 | header3" role="Prüfung Verweise">
            <report test="matches(., 'HYPERLINK|REF _Ref')" diagnostics="para_05_de para_05_en"/>
            <extends rule="rule-1"/>
        </rule>
        <rule context="comment()" role="Prüfung auf defekte Verweise">
            <report test="matches(., 'Nicht identfizierbares Feld')" diagnostics="para_06_de para_06_en"/>
        </rule>
        <rule context="notInFont" role="notInFont">
            <report role="warn" test="." diagnostics="para_07_de para_07_en"/>
        </rule>
        <rule context="processing-instruction('oxy_comment_start')" role="Oxygen-Kommentare">
            <report test="." role="warn" diagnostics="para_08_de para_08_en"/>
        </rule>
        <rule context="shorttitle" role="Titelprüfungen">
            <report test="string-length(normalize-space(string-join(./text(), ' '))) = 0" sqf:fix="addBlacks" diagnostics="para_09_de para_09_en"/>
            <sqf:fix id="addBlacks">
                <sqf:description>
                    <sqf:title ref="fix_addBlacks_title_de fix_addBlacks_title_en"/>
                    <sqf:p ref="fix_addBlacks_p_de fix_addBlacks_p_en"/>
                </sqf:description>
                <sqf:add> █ █ █ </sqf:add>
            </sqf:fix>
            <report role="warn" test="link, uri" diagnostics="para_10_de para_10_en"/>
            <extends rule="rule-1"/>
        </rule>
        <!-- jtl Test OXY-312-->
        <rule context="title" role="Titelprüfungen und Prüfung Verweise">
            <report test="matches(., 'HYPERLINK|REF _Ref')" diagnostics="para_05_de para_05_en"/>
            <report test="string-length(normalize-space(string-join(./text(), ' '))) = 0" sqf:fix="addBlacks" diagnostics="para_09_de para_09_en"/>
            <sqf:fix id="addBlacks">
                <sqf:description>
                    <sqf:title ref="fix_addBlacks_title_de fix_addBlacks_title_en"/>
                    <sqf:p ref="fix_addBlacks_p_de fix_addBlacks_p_en"/>
                </sqf:description>
                <sqf:add> █ █ █ </sqf:add>
            </sqf:fix>
            <report role="warn" test="link, uri" diagnostics="para_10_de para_10_en"/>
            <extends rule="rule-1"/>
        </rule>
        <!-- jtl Test OXY-312 Ende-->
        <rule context="section[count(ancestor-or-self::section) &lt; 3] | part" role="Prüfung der Titel-Länge eines Kapitels">
            <assert role="warn" test="string-length(normalize-space(string-join(title/text(), ' '))) &lt; 51 or shorttitle" subject="title" diagnostics="para_11_de para_11_en"/>
        </rule>
    </pattern>

    <diagnostics>
        <diagnostic id="para_01_de" xml:lang="de">Whitespace zu Beginn von <value-of select="name()"/></diagnostic>
        <diagnostic id="para_03_de" xml:lang="de">Dieses <value-of select="name()"/> wird wahrscheinlich nicht benötigt und kann entfernt werden.</diagnostic>
        <diagnostic id="para_04_de" xml:lang="de">Ein QR-Code link muss exklusiv in einem para stehen.</diagnostic>
        <diagnostic id="para_05_de" xml:lang="de">In diesem <value-of select="name()"/> ist ein defekter Verweis enthalten.</diagnostic>
        <diagnostic id="para_06_de" xml:lang="de">In diesem Absatz ist ein defekter Verweis enthalten.</diagnostic>
        <diagnostic id="para_07_de" xml:lang="de">Im Dokument sind <value-of select="name()"/>-Elemente enthalten.</diagnostic>
        <diagnostic id="para_08_de" xml:lang="de">Dieser Oxygen-Kommentar deutet auf eine unfertige XML-Datei hin.</diagnostic>
        <diagnostic id="para_09_de" xml:lang="de">Ein Titel darf nicht leer sein.</diagnostic>
        <diagnostic id="para_10_de" xml:lang="de">In <value-of select="name()"/> dürfen keine Links stehen</diagnostic>
        <diagnostic id="para_11_de" xml:lang="de">Dieser Titel ist als Kolumnentitel zu lang. Es sollte zusätzlich ein shorttitle angelegt werden.</diagnostic>
        <!-- quick fixes -->
        <diagnostic id="fix_emph-combine_title_de" xml:lang="de">Zusammenführen</diagnostic>
        <diagnostic id="fix_emph-combine_p_de" xml:lang="de">Mit vorhergehendem Element zusammenführen</diagnostic>
        <!-- EN -->
        <diagnostic id="para_01_en" xml:lang="en">Blank space at the beginning of <value-of select="name()"/>.</diagnostic>
        <diagnostic id="para_02_en" xml:lang="en">This <value-of select="name()"/> can be merged with the preceding <value-of select="name()"/>.</diagnostic>
        <diagnostic id="para_03_en" xml:lang="en">This <value-of select="name()"/> is probably not needed and can be removed.</diagnostic>
        <diagnostic id="para_04_en" xml:lang="en">A QR code link must stand alone in a para.</diagnostic>
        <diagnostic id="para_05_en" xml:lang="en">This <value-of select="name()"/> contains an incorrect reference.</diagnostic>
        <diagnostic id="para_06_en" xml:lang="en">This paragraph contains an incorrect reference.</diagnostic>
        <diagnostic id="para_07_en" xml:lang="en">This document contains <value-of select="name()"/>-elements.</diagnostic>
        <diagnostic id="para_08_en" xml:lang="en">This Oxygen comment indicates an unfinished XML file.</diagnostic>
        <diagnostic id="para_09_en" xml:lang="en">A title must not be empty.</diagnostic>
        <diagnostic id="para_10_en" xml:lang="en">The element <value-of select="name()"/> must not contain any links.</diagnostic>
        <diagnostic id="para_11_en" xml:lang="en">This title is too long as a column title. An additional shorttitle should be created.</diagnostic>
        <!-- quick fixes -->
        <diagnostic id="fix_emph-combine_title_en" xml:lang="en">Merge</diagnostic>
        <diagnostic id="fix_emph-combine_p_en" xml:lang="en">Merge with preceding element</diagnostic>
        <diagnostic id="fix_addBlacks_title_de" xml:lang="de">Blockaden einfügen</diagnostic>
        <diagnostic id="fix_addBlacks_p_de" xml:lang="de">Fügt drei Blockaden ein</diagnostic>
        <diagnostic id="fix_addBlacks_title_en" xml:lang="en">Insert blacks</diagnostic>
        <diagnostic id="fix_addBlacks_p_en" xml:lang="en">Inserts three blacks</diagnostic>
    </diagnostics>

    <pattern id="text">
        <title>Allgemeine Textprüfungen</title>
        <rule context="td/para | th/para">
            <!-- para in Tabellen aus Prüfungen ausschließen -->
        </rule>
        <rule context="
                *[not(name() = ('br',
                'graphic',
                'audio',
                'video',
                'col',
                'concept',
                'custom',
                'td',
                'th',
                'target'))]" role="Leere Elemente und Blockaden">
            <report role="warn" test="not(name() = ('link', 'personid', 'title', 'shorttitle')) and string-length(normalize-space(.)) = 0 and not(*)" diagnostics="text_01_de text_01_en"/>
            <report test="text()[matches(., '▀|▁|▂|▃|▄|▅|▆|▇|█|▉|▊|▋|▌|▍|▎|▏|▐|░|▒|▓|▔|▕|▖|▗|▘|▙|▚|▛|▜|▝|▞|▟|■')]" diagnostics="text_02_de text_02_en"/>
            <!-- sqf funktioniert nicht <sqf:stringReplace regex="[&amp;#x7f;-&amp;#x9f;]" match="text()"></sqf:stringReplace> -->
            <report test="text()[matches(., '[^\P{Cc}\n\t]')]" diagnostics="text_03_de text_03_en"/>
        </rule>
        <!-- Workaround, da sonst m:semantics geprüft wird auch wenn es keine Attribute hat -->
        <rule context="*[not(local-name() = 'semantics')]/@*[not(name() = 'fileref') and not (name() = 'alt')]" role="Allgemeine Attribut- und Blockadenprüfung">
            <report test="matches(., '▀|▁|▂|▃|▄|▅|▆|▇|█|▉|▊|▋|▌|▍|▎|▏|▐|░|▒|▓|▔|▕|▖|▗|▘|▙|▚|▛|▜|▝|▞|▟|■')" diagnostics="text_04_de text_04_en"/>
            <report test="string-length(.) = 0" diagnostics="text_05_de text_05_en"/>
        </rule>
    </pattern>

    <diagnostics>
        <diagnostic id="text_01_de" xml:lang="de">Das Element <value-of select="name()"/> ist leer</diagnostic>
        <diagnostic id="text_02_de" xml:lang="de">Die Blockade in <value-of select="name()"/> muss aufgelöst werden.</diagnostic>
        <diagnostic id="text_03_de" xml:lang="de">Aus <value-of select="name()"/> müssen ungültige Zeichen entfernt oder ersetzt werden: <value-of select="replace(., '[\P{Cc}\n\t]', '')"/>.</diagnostic>
        <diagnostic id="text_04_de" xml:lang="de">Die Blockade in <value-of select="ancestor::*[1]/name()"/>/@<value-of select="name()"/> muss aufgelöst werden.</diagnostic>
        <diagnostic id="text_05_de" xml:lang="de">Der Attributwert darf nicht leer sein.</diagnostic>

        <!-- EN -->
        <diagnostic id="text_01_en" xml:lang="en">The element <value-of select="name()"/> is empty.</diagnostic>
        <diagnostic id="text_02_en" xml:lang="en">The black square in <value-of select="name()"/> must be resolved.</diagnostic>
        <diagnostic id="text_03_en" xml:lang="en">Invalid characters must be removed or replaced from <value-of select="name()"/>: <value-of select="replace(., '[\P{Cc}\n\t]', '')"/>.</diagnostic>
        <diagnostic id="text_04_en" xml:lang="en">The black square in <value-of select="ancestor::*[1]/name()"/>/@<value-of select="name()"/> must be resolved.</diagnostic>
        <diagnostic id="text_05_en" xml:lang="en">The attibute value must not be empty.</diagnostic>
    </diagnostics>

    <pattern id="hidelevel">
        <title>Elemente ausblenden</title>
        <rule context=".[@hide-level = '2']">
            <report test="descendant::*[@hide-level = '2'] or descendant::hide[@level = '2']" diagnostics="hidelevel_01_de hidelevel_01_en"/>
        </rule>
        <rule context=".[@hide-level = '1']">
            <report test="descendant::*[@hide-level = '2'] or descendant::hide[@level = '2']" diagnostics="hidelevel_02_de hidelevel_02_en"/>
            <report test="descendant::*[@hide-level = '1'] or descendant::hide[@level = '1']" diagnostics="hidelevel_03_de hidelevel_03_en"/>
            <report test="descendant::*[@switch = 'yes'] or descendant::emph[@type = 'switch']" diagnostics="hidelevel_04_de hidelevel_04_en"/>
        </rule>
        <rule context=".[@switch = 'yes']">
            <report test="descendant::*[@hide-level = '2'] or descendant::hide[@level = '2']" diagnostics="hidelevel_05_de hidelevel_05_en"/>
            <report test="descendant::*[@hide-level = '1'] or descendant::hide[@level = '1']" diagnostics="hidelevel_05_de hidelevel_05_en"/>
            <report test="descendant::*[@switch = 'yes'] or descendant::emph[@type = 'switch']" diagnostics="hidelevel_05_de hidelevel_05_en"/>
        </rule>
        <rule context="emph[@type = 'switch']">
            <report test="descendant::hide[@level = '2']" diagnostics="hidelevel_06_de hidelevel_06_en"/>
            <report test="descendant::hide[@level = '1']" diagnostics="hidelevel_06_de hidelevel_06_en"/>
            <report test="descendant::emph[@type = 'switch']" diagnostics="hidelevel_06_de hidelevel_06_en"/>
        </rule>
        <rule context="hide[@level = '1']">
            <report test="descendant::hide[@level = '2']" diagnostics="hidelevel_07_de hidelevel_07_en"/>
            <report test="descendant::hide[@level = '1']" diagnostics="hidelevel_07_de hidelevel_07_en"/>
            <report test="descendant::emph[@type = 'switch']" diagnostics="hidelevel_07_de hidelevel_07_en"/>
        </rule>
        <rule context="hide[@level = '2']">
            <report test="descendant::hide[@level = '2']" diagnostics="hidelevel_08_de hidelevel_08_en"/>
        </rule>
    </pattern>

    <diagnostics>
        <diagnostic id="hidelevel_01_de" xml:lang="de">Ein hide-level=2 darf kein weiteres hide-level=2 bzw. hide@level=2 enthalten.</diagnostic>
        <diagnostic id="hidelevel_02_de" xml:lang="de">Ein hide-level=1 darf kein hide-level=2 bzw. hide@level=2 enthalten.</diagnostic>
        <diagnostic id="hidelevel_03_de" xml:lang="de">Ein hide-level=1 darf kein weiteres hide-level=1 bzw. hide@level=1 enthalten.</diagnostic>
        <diagnostic id="hidelevel_04_de" xml:lang="de">Ein hide-level=1 darf kein switch=yes bzw. emph type=switch enthalten.</diagnostic>
        <diagnostic id="hidelevel_05_de" xml:lang="de">Ein switch=yes darf kein @hide-level bzw. hide@level und kein emph@type=switch bzw. switch=yes enthalten.</diagnostic>
        <diagnostic id="hidelevel_06_de" xml:lang="de">Ein emph@type=switch darf kein hide@level oder ein weiteres emph@type=switch enthalten.</diagnostic>
        <diagnostic id="hidelevel_07_de" xml:lang="de">Ein hide@level=1 darf kein hide@level oder ein emph@type=switch enthalten.</diagnostic>
        <diagnostic id="hidelevel_08_de" xml:lang="de">Ein hide@level=2 darf kein hide@level=2 enthalten.</diagnostic>
        <!-- EN -->
        <diagnostic id="hidelevel_01_en" xml:lang="en">One hide-level=2 should not contain another hide-level=2 resp. hide@level=2.</diagnostic>
        <diagnostic id="hidelevel_02_en" xml:lang="en">One hidel-level=1 should not contain a hide-level=2 resp. hide@level=2.</diagnostic>
        <diagnostic id="hidelevel_03_en" xml:lang="en">One hide-level=2 should not contain another hide-level=1 resp. hide@level=1.</diagnostic>
        <diagnostic id="hidelevel_04_en" xml:lang="en">One hide-level=2 should not contain switch=yes resp. emph@type=switch.</diagnostic>
        <diagnostic id="hidelevel_05_en" xml:lang="en">One switch=yes should not contain a @hide-level resp. hide@level and not emph@type=switch resp. switch=yes.</diagnostic>
        <diagnostic id="hidelevel_06_en" xml:lang="en">One emph@type=switch should not contain a hide@level or another emph@type=switch.</diagnostic>
        <diagnostic id="hidelevel_07_en" xml:lang="en">One hide@level=1 should not contain a hide@level or an emph@type=switch.</diagnostic>
        <diagnostic id="hidelevel_08_en" xml:lang="en">One hide@level=2 should not contain a hide@level=2.</diagnostic>
    </diagnostics>

    <pattern id="deprecated">
        <title>Obsolete Elemente prüfen</title>
        <!-- 2021-01-27, hha: Warnmeldung zu target-Elementen entfernt, da nicht praktikabel (OXY-242) -->
        <!--<rule context="target" role="Deprecated-Elemente">
            <report role="warn" test="." sqf:fix="target-move unused-target unused-targets">Das Element <name/> sollte nicht mehr verwendet werden</report>

            <let name="element" value="//target[@id = current()/@id]"/>
            <let name="parent" value="$element/parent::*[name() = $id_elements][1]"/>
            <sqf:fix id="target-move" use-when="name() = 'target' and @id = $idrefs and ancestor::node()/name() = $id_elements">
                <sqf:description>
                    <sqf:title>Dieses <name/> auflösen und Links an <name path="$parent"/> verschieben</sqf:title>
                </sqf:description>
                <sqf:replace match="$idrefs[. = current()/@id]" target="idref" node-type="attribute">
                    <value-of select="($parent/@id,$element/@id)[1]"/>
                </sqf:replace>
                <sqf:add match="$parent[not(@id)]" target="id" node-type="attribute">
                    <value-of select="$element/@id"/>
                </sqf:add>
                <sqf:delete/>
            </sqf:fix>
            <sqf:fix id="unused-targets" use-when="not(@id = $idrefs)">
                <sqf:description>
                    <sqf:title>Alle nicht verwendeten <name/> entfernen</sqf:title>
                </sqf:description>
                <sqf:delete match="//target[not((@id = $idrefs))]"/>
            </sqf:fix>
            <sqf:fix id="unused-target" use-when="not(@id = $idrefs)">
                <sqf:description>
                    <sqf:title>Nicht verwendetes <name/> entfernen</sqf:title>
                </sqf:description>
                <sqf:delete/>
            </sqf:fix>
        </rule>-->
        <rule context="section" role="Prüfung auf @counter und @level">
            <report test="@counter" sqf:fix="remvalue-counter remvalues-counter" diagnostics="deprecated_01_de deprecated_01_en"/>
            <report role="warn" test="number(@level) = (1 to 7)" sqf:fix="remvalue-level remvalues-level" diagnostics="deprecated_02_de deprecated_02_en"/>
            <sqf:fix id="remvalue-counter">
                <sqf:description>
                    <sqf:title ref="fix_remvalues_title_de fix_remvalues_title_en"/>
                    <sqf:p ref="fix_remvalues_p_de fix_remvalues_p_en"/>
                </sqf:description>
                <sqf:delete match="@counter"/>
            </sqf:fix>
            <sqf:fix id="remvalue-level">
                <sqf:description>
                    <sqf:title ref="fix_remvalues_title_de fix_remvalues_title_en"/>
                    <sqf:p ref="fix_remvalues_p_de fix_remvalues_p_en"/>
                </sqf:description>
                <sqf:delete match="@level"/>
            </sqf:fix>
            <sqf:fix id="remvalues-counter">
                <sqf:description>
                    <sqf:title ref="fix_remvalues_title_de fix_remvalues_title_en"/>
                    <sqf:p ref="fix_remvalues_p_de fix_remvalues_p_en"/>
                </sqf:description>
                <sqf:delete match="//section/@counter"/>
            </sqf:fix>
            <sqf:fix id="remvalues-level">
                <sqf:description>
                    <sqf:title ref="fix_remvalues_title_de fix_remvalues_title_en"/>
                    <sqf:p ref="fix_remvalues_p_de fix_remvalues_p_en"/>
                </sqf:description>
                <sqf:delete match="//section/@level"/>
            </sqf:fix>
        </rule>
        <rule context="section/subtitle" role="Prüfung auf falsch verwendeten subtitle">
            <assert test="
                    preceding-sibling::*[1]/name() = ('title',
                    'titletranslated')" sqf:fix="to_paratitle" diagnostics="deprecated_03_de deprecated_03_en"/>
            <sqf:fix id="to_paratitle">
                <sqf:description>
                    <sqf:title ref="fix_to_paratitle_title_de fix_to_paratitle_title_en"/>
                    <sqf:p ref="fix_to_paratitle_p_de fix_to_paratitle_p_en"/>
                </sqf:description>
                <sqf:replace target="paratitle1" node-type="keep" select="child::node()"/>
            </sqf:fix>
        </rule>
    </pattern>

    <diagnostics>
        <diagnostic id="deprecated_01_de" xml:lang="de">Das @counter-Attribut darf an <value-of select="name()"/> nicht mehr verwendet werden.</diagnostic>
        <diagnostic id="deprecated_02_de" xml:lang="de">@level sollte nicht mehr verwendet werden und kann im Normalfall einfach gelöscht werden.</diagnostic>
        <diagnostic id="deprecated_03_de" xml:lang="de">Subtitle darf nur noch direkt nach title verwendet werden.</diagnostic>
        <!-- quick fixes -->
        <diagnostic id="fix_remvalues_title_de" xml:lang="de">Eintrag an allen <value-of select="name()"/> entfernen</diagnostic>
        <diagnostic id="fix_remvalues_p_de" xml:lang="de">Löscht den selektierten Knoten</diagnostic>
        <diagnostic id="fix_to_paratitle_title_de" xml:lang="de">In Paratitle konvertieren</diagnostic>
        <diagnostic id="fix_to_paratitle_p_de" xml:lang="de">Wandelt das selektierte Element in paratitle um</diagnostic>
        <!-- EN -->
        <diagnostic id="deprecated_01_en" xml:lang="en">The attribute @counter must not be used with <value-of select="name()"/> anymore.</diagnostic>
        <diagnostic id="deprecated_02_en" xml:lang="en">The attribute @level should no longer be used and can usually simply be deleted.</diagnostic>
        <diagnostic id="deprecated_03_en" xml:lang="en">Subtitle may only be used directly after title anymore.</diagnostic>
        <diagnostic id="fix_remvalues_title_en" xml:lang="en">Remove entry on all <value-of select="name()"/></diagnostic>
        <diagnostic id="fix_remvalues_p_en" xml:lang="en">Deletes the selected node</diagnostic>
        <diagnostic id="fix_to_paratitle_title_en" xml:lang="en">Change to paratitle</diagnostic>
        <diagnostic id="fix_to_paratitle_p_en" xml:lang="en">Changes the selected element to paratitle</diagnostic>
    </diagnostics>

    <!--ADD 2020-12-04 aus Schematron Fachzeitschriften (XML1stFZ_Schematron-Regeln.xlsx)-->
    <!-- Regel 1a -->
    <pattern id="fz_contentXML_section1Root">
        <title>Wurzelelement</title>
        <rule context="*[not(parent::*)]">
            <report test="not(name() = 'section')" diagnostics="fz_contentXML_section1Root_01_de fz_contentXML_section1Root_01_en"/>
            <report test="not(@startnum = '1')" diagnostics="fz_contentXML_section1Root_02_de fz_contentXML_section1Root_02_en"/>
        </rule>
    </pattern>

    <diagnostics>
        <diagnostic id="fz_contentXML_section1Root_01_de" xml:lang="de">Das Root-Element muss section heißen und das Attribut startnum mit dem Wert 1 beeinhalten.</diagnostic>
        <diagnostic id="fz_contentXML_section1Root_02_de" xml:lang="de">Das Root-Element section muss das Attribut startnum mit dem Wert 1 beeinhalten.</diagnostic>
        <!-- EN -->
        <diagnostic id="fz_contentXML_section1Root_01_en" xml:lang="en">The root element must be named section and contain the startnum attribute with the value 1.</diagnostic>
        <diagnostic id="fz_contentXML_section1Root_02_en" xml:lang="en">The root element section must contain the startnum attribute with the value 1.</diagnostic>
    </diagnostics>

    <!--Regel 1b-->
    <pattern id="fz_contentXML_section1Title">
        <title>Section title</title>
        <rule context="section[@startnum = '1']">
            <report test="not(title)" sqf:fix="addtitle" role="error" diagnostics="fz_contentXML_section1Title_01_de fz_contentXML_section1Title_01_en"/>
        </rule>
    </pattern>

    <diagnostics>
        <diagnostic id="fz_contentXML_section1Title_01_de" xml:lang="de">Die Datei hat nicht die erforderliche Struktur für die Konverter. Titel in TReX ergänzen und neues KIS-XML erzeugen oder manuell in KIS-XML strukturieren.</diagnostic>
        <!-- EN -->
        <diagnostic id="fz_contentXML_section1Title_01_en" xml:lang="en">The file does not have the required structure for the converters. Add title in TReX and create new KIS-XML or structure manually in KIS-XML.</diagnostic>
    </diagnostics>


    <!--Regel 2-->
    <pattern id="trademarks">
        <title>Trademarks</title>
        <rule context="text()" role="error">
            <report test="matches(., '[®℠™]+')" sqf:fix="deleteTrademarks" role="error" diagnostics="trademarks_01_de trademarks_01_en"/>
            <report test="matches(parent::sup, '^(TM|SM)$')" sqf:fix="deleteTrademarks" role="error" diagnostics="trademarks_01_de trademarks_01_en"/>
        </rule>
    </pattern>

    <diagnostics>
        <diagnostic id="trademarks_01_de" xml:lang="de">Trademarkzeichen ®, TM oder SM sollen nicht verwendet werden.</diagnostic>
        <!-- EN -->
        <diagnostic id="trademarks_01_en" xml:lang="en">The trademark signs ®, TM or SM should not be used.</diagnostic>
    </diagnostics>

    <pattern id="dates">
        <title>Datumsangaben</title>
        <rule context="
                text()[matches(., '(^|\s)(19|20)\d{2}($|\s)')][not(ancestor::*[name() = 'metadata'])][not(ancestor::*[name() = 'section' and @type = 'references'])][not(ancestor::*[name() = 'litref'])]
                | text()[matches(., '(^|\s)([0]?[1-9]|[1][0-2])(-|\.)([1][9]|[2][0])\d{2}($|\s)')][not(ancestor::*[name() = 'metadata'])][not(ancestor::*[name() = 'section' and @type = 'references'])][not(ancestor::*[name() = 'litref'])]
                | text()[matches(., '(?:(?:(^|\s)31(-|\.)(?:0?[13578]|1[02]))\2|(?:(^|\s)(?:29|30)(-|\.)(?:0?[13-9]|1[0-2])\4))(?:(?:[1][9]|[2][0])\d{2})|(?:(^|\s)29(-|\.)0?2\6(?:(?:(?:[1][9]|[2][0])(?:0[48]|[2468][048]|[13579][26])|(?:(?:16|[2468][048]|[3579][26])00))))|(?:(^|\s)0?[1-9]|1\d|2[0-8])(-|\.)(?:(?:0?[1-9])|(?:1[0-2]))\8(?:(?:[1][9]|[2][0])\d{2})($|\s)')][not(ancestor::*[name() = 'metadata'])][not(ancestor::*[name() = 'section' and @type = 'references'])][not(ancestor::*[name() = 'litref'])]" role="warn">
            <let name="blockadeContent" value="' █ Ersetze absolute durch relative Zeitangabe. // Replace absolute with relative time specification. █ '"/>

            <report test="." sqf:fix="blockadeDateDDMMYYYY" role="warn" diagnostics="dates_01_de dates_01_en"/>
            <sqf:fix id="blockadeDateDDMMYYYY">
                <sqf:description>
                    <sqf:title ref="fix_blockadeDate_title_de fix_blockadeDate_title_en"/>
                    <sqf:p ref="fix_blockadeDate_p_de fix_blockadeDate_p_en"/>
                </sqf:description>
                <sqf:replace target="{text()[matches(.,'(?:(?:(^|\s)31(-|\.)(?:0?[13578]|1[02]))\2|(?:(^|\s)(?:29|30)(-|\.)(?:0?[13-9]|1[0-2])\4))(?:(?:[1][9]|[2][0])\d\d)|(?:(^|\s)29(-|\.)0?2\6(?:(?:(?:[1][9]|[2][0])(?:0[48]|[2468][048]|[13579][26])|(?:(?:16|[2468][048]|[3579][26])00))))|(?:(^|\s)0?[1-9]|1\d|2[0-8])(-|\.)(?:(?:0?[1-9])|(?:1[0-2]))\8(?:(?:[1][9]|[2][0])\d\d)($|\s)')][not(ancestor::*[name()='metadata'])][not(ancestor::*[name()='section' and @type='references'])]}" node-type="keep">
                    <xsl:analyze-string select="." regex="(?:(?:(^|\s)31(-|\.)(?:0?[13578]|1[02]))\2|(?:(^|\s)(?:29|30)(-|\.)(?:0?[13-9]|1[0-2])\4))(?:(?:[1][9]|[2][0])\d\d)|(?:(^|\s)29(-|\.)0?2\6(?:(?:(?:[1][9]|[2][0])(?:0[48]|[2468][048]|[13579][26])|(?:(?:16|[2468][048]|[3579][26])00))))|(?:(^|\s)0?[1-9]|1\d|2[0-8])(-|\.)(?:(?:0?[1-9])|(?:1[0-2]))\8(?:(?:[1][9]|[2][0])\d\d)($|\s)">
                        <xsl:matching-substring>
                            <xsl:value-of select="."/>
                            <xsl:value-of select="$blockadeContent"/>
                        </xsl:matching-substring>
                        <xsl:non-matching-substring>
                            <xsl:analyze-string select="." regex="(^|\s)([0]?[1-9]|[1][0-2])(-|\.)([1][9]|[2][0])\d\d($|\s)">
                                <xsl:matching-substring>
                                    <xsl:value-of select="."/>
                                    <xsl:value-of select="$blockadeContent"/>
                                </xsl:matching-substring>
                                <xsl:non-matching-substring>
                                    <xsl:analyze-string select="." regex="(^|\s)([1][9]|[2][0])\d\d($|\s)">
                                        <xsl:matching-substring>
                                            <xsl:value-of select="."/>
                                            <xsl:value-of select="$blockadeContent"/>
                                        </xsl:matching-substring>
                                        <xsl:non-matching-substring>
                                            <xsl:value-of select="."/>
                                        </xsl:non-matching-substring>
                                    </xsl:analyze-string>
                                </xsl:non-matching-substring>
                            </xsl:analyze-string>
                        </xsl:non-matching-substring>
                    </xsl:analyze-string>
                </sqf:replace>
            </sqf:fix>
        </rule>
    </pattern>

    <diagnostics>
        <diagnostic id="dates_01_de" xml:lang="de">Der Text enthält ggf. absolute Zeitangaben. Bitte prüfen und ggf. vor Veröffentlichung korrigieren.</diagnostic>
        <!-- quick fixes -->
        <diagnostic id="fix_blockadeDate_title_de" xml:lang="de">Blockade setzen</diagnostic>
        <diagnostic id="fix_blockadeDate_p_de" xml:lang="de">Blockade nach String setzen</diagnostic>
        <!-- EN -->
        <diagnostic id="dates_01_en" xml:lang="en">The text may contain absolute dates. Please check and correct if necessary before publication.</diagnostic>
        <!-- quick fixes -->
        <diagnostic id="fix_blockadeDate_title_en" xml:lang="en">Insert a black square</diagnostic>
        <diagnostic id="fix_blockadeDate_p_en" xml:lang="en">Insert black square after string</diagnostic>
    </diagnostics>

    <pattern id="issueNumber">
        <title>Ausgabennummer</title>

        <rule context="issue | supplement">
            <assert test="matches(., '^\d{1,4}$') or matches(., '^\d{1,4}/\d{1,4}$')" sqf:fix="formatIssueNumber" role="warn" diagnostics="issueNumber_01_de issueNumber_01_en"/>
            <!--report test="matches(., '^\d{1}\s*$')" sqf:fix="formatIssueNumber" role="error" diagnostics="issueNumber_01_de issueNumber_01_en">Die Ausgaben-/Supplementnummer muss immer zweiziffrig sein. Einstellige Ausgaben-/Supplementnummern müssen mit einer führenden Null genannt werden, bspw. 01 oder bei Doppelnummern 01/02.</report-->
            <sqf:fix id="formatIssueNumber">
                <sqf:description>
                    <sqf:title ref="fix_formatIssueNumber_title_de fix_formatIssueNumber_title_en"/>
                    <sqf:p ref="fix_formatIssueNumber_p_de fix_formatIssueNumber_p_en"/>
                </sqf:description>
                <let name="type" value="
                        if (self::issue) then
                            'issue'
                        else
                            'supplement'"/>
                <let name="number" value="
                        if (matches(., '^\d{1}$')) then
                            concat('0', .)
                        else
                            if (matches(., '^\d{1}/\d{1}$')) then
                                concat('0', substring-before(., '/'), '/', '0', substring-after(., '/'))
                            else
                                if (matches(., '^\d{1}/\d{2}$')) then
                                    concat('0', substring-before(., '/'), '/', substring-after(., '/'))
                                else
                                    if (matches(., '^\d{2}/\d{1}$')) then
                                        concat(substring-before(., '/'), '/', '0', substring-after(., '/'))
                                    else
                                        ()"/>
                <sqf:replace node-type="keep" target="{$type}" select="$number"/>

                <!-- Funktioniert nicht :/ -->
                <!--   <sqf:stringReplace regex="^(\d{1})\s*$">
                    <!-\- doppelte geschweifte Klammer muss sein, s.a. https://www.data2type.de/xml-xslt-xslfo/xslt/xslt-referenz/analyze-string/ -\->
                    <xsl:analyze-string select="." regex="^(\d{{1}})\s*$">
                        <xsl:matching-substring>
                            <xsl:copy-of select="concat('0', regex-group(1))"/>
                        </xsl:matching-substring>
                    </xsl:analyze-string>
                </sqf:stringReplace>-->
            </sqf:fix>

            <!-- Schrägstrich bei Doppelnummern einfügen -->
            <report test="contains(., '–') or contains(., '-')" sqf:fix="replaceHyphen" role="error" diagnostics="issueNumber_02_de issueNumber_02_en">Doppelnummern, z.B. 02-03, müssen durch einen Schrägstrich getrennt werden.</report>
            <sqf:fix id="replaceHyphen">
                <sqf:description>
                    <sqf:title ref="fix_replaceHyphen_title_de fix_replaceHyphen_title_en"/>
                    <sqf:p ref="fix_replaceHyphen_p_de fix_replaceHyphen_p_en"/>
                </sqf:description>
                <!-- Funktioniert nicht :/ -->
                <!--  <sqf:stringReplace regex="^(\d+)\s*[–,-]\s*(\d+)">
                    <xsl:analyze-string select="." regex="^(\d+)\s*[–,-]\s*(\d+)">
                        <xsl:matching-substring>
                            <xsl:copy-of select="concat(regex-group(1),'/', regex-group(2))"/>
                        </xsl:matching-substring>
                    </xsl:analyze-string>
                </sqf:stringReplace>-->
            </sqf:fix>
        </rule>
    </pattern>

    <diagnostics>
        <diagnostic id="issueNumber_01_de" xml:lang="de">Die Ausgaben-/Supplementnummer sollte maximal vierstellig sein und nur Ziffern enthalten. Einstellige Ausgaben-/Supplementnummern müssen mit einer führenden Null genannt werden, bspw. 01 oder bei Doppelnummern 01/02.</diagnostic>
        <diagnostic id="issueNumber_02_de" xml:lang="de">Doppelnummern, z.B. 02-03, müssen durch einen Schrägstrich getrennt werden.</diagnostic>
        <!-- quick fixes -->
        <diagnostic id="fix_formatIssueNumber_title_de" xml:lang="de">Führende</diagnostic>
        <diagnostic id="fix_formatIssueNumber_p_de" xml:lang="de">Fügt eine führende Null ein.</diagnostic>
        <diagnostic id="fix_replaceHyphen_title_de" xml:lang="de">Doppelnummer</diagnostic>
        <diagnostic id="fix_replaceHyphen_p_de" xml:lang="de">Schrägstrich zwischen Doppelnummern ergänzen.</diagnostic>



        <!-- EN -->
        <diagnostic id="issueNumber_01_en" xml:lang="en">The issue/supplement number should have a maximum of four digits and contain only digits. One-digit issue/supplement numbers must be indicated with a leading zero, e.g. 01 or in the case of double issues, 01/02.</diagnostic>
        <diagnostic id="issueNumber_02_en" xml:lang="en">Double digits, e.g. 02-03, must be separated by a slash.</diagnostic>
        <!-- quick fixes -->
        <diagnostic id="fix_formatIssueNumber_title_en" xml:lang="en">Issue number</diagnostic>
        <diagnostic id="fix_formatIssueNumber_p_en" xml:lang="en">Inserts a leading zero.</diagnostic>
        <diagnostic id="fix_replaceHyphen_title_en" xml:lang="en">Double digits</diagnostic>
        <diagnostic id="fix_replaceHyphen_p_en" xml:lang="en">Insert slash between double digits.</diagnostic>
    </diagnostics>

    <!--Regel 4-->
    <pattern id="doubledDOI">
        <title>DOI und Pubmed-ID</title>
        <rule context="litref/(jnref | bkref | chref)/id[@type = 'doi'][2] | litref/(jnref | bkref | chref)/id[@type = 'pubmed'][2]" role="error">
            <report test=".[@type = 'doi']" sqf:fix="deleteDOIorPubmed" role="error" diagnostics="doubledDOI_01_de doubledDOI_01_en"/>
            <report test=".[@type = 'pubmed']" sqf:fix="deleteDOIorPubmed" role="error" diagnostics="doubledDOI_02_de doubledDOI_02_en"/>
        </rule>
    </pattern>

    <diagnostics>
        <diagnostic id="doubledDOI_01_de" xml:lang="de">DOI kommt mehr als einmal vor.</diagnostic>
        <diagnostic id="doubledDOI_02_de" xml:lang="de">PubMed-ID kommt mehr als einmal vor.</diagnostic>
        <!-- EN -->
        <diagnostic id="doubledDOI_01_en" xml:lang="en">DOI occurs more than once.</diagnostic>
        <diagnostic id="doubledDOI_02_en" xml:lang="en">PubMed-ID occurs more than once.</diagnostic>
    </diagnostics>

    <pattern id="doubledElementsLitref">
        <title>Doppelte Elemente in Literaturreferenzen</title>
        <rule context="
                //litref[count(descendant::volume) > 1] | //litref[count(descendant::fpage) > 1] | //litref[count(descendant::issue) > 1] | //litref[count(descendant::lpage) > 1]
                | //litref[count(descendant::name[@type = 'author']) > 3] | //litref[count(descendant::etal) > 1] | //litref[count(descendant::anonymous) > 1] | //litref[count(descendant::reftitle) > 1]
                | //litref[count(descendant::refpub) > 1] | //litref[count(descendant::date) > 1] | //litref[count(descendant::supplement) > 1] | //litref[count(descendant::uri) > 1]
                | //litref[count(descendant::issn) > 1] | //litref[count(descendant::id[@type = 'doi']) > 1] | //litref[count(descendant::id[@type = 'pubmed']) > 1]
                | //litref[count(descendant::txt) > 1]" role="error">
            <report test="count(descendant::volume) &gt; 1" diagnostics="doubledElementsLitref_01_de doubledElementsLitref_01_en"/>
            <report test="count(descendant::issue) &gt; 1" diagnostics="doubledElementsLitref_02_de doubledElementsLitref_02_en"/>
            <report test="count(descendant::lpage) &gt; 1" diagnostics="doubledElementsLitref_03_de doubledElementsLitref_03_en"/>
            <report test="count(descendant::fpage) &gt; 1" diagnostics="doubledElementsLitref_04_de doubledElementsLitref_04_en"/>
            <report test="count(descendant::name[@type = 'author']) &gt; 3" diagnostics="doubledElementsLitref_05_de doubledElementsLitref_05_en"/>
            <report test="count(descendant::etal) &gt; 1" diagnostics="doubledElementsLitref_06_de doubledElementsLitref_06_en"/>
            <report test="count(descendant::anonymous) &gt; 1" diagnostics="doubledElementsLitref_07_de doubledElementsLitref_07_en"/>
            <report test="count(descendant::reftitle) &gt; 1" diagnostics="doubledElementsLitref_08_de doubledElementsLitref_08_en"/>
            <report test="count(descendant::refpub) &gt; 1" diagnostics="doubledElementsLitref_09_de doubledElementsLitref_09_en"/>
            <report test="count(descendant::date) &gt; 1" diagnostics="doubledElementsLitref_10_de doubledElementsLitref_10_en"/>
            <report test="count(descendant::supplement) &gt; 1" diagnostics="doubledElementsLitref_11_de doubledElementsLitref_11_en"/>
            <report test="count(descendant::uri) &gt; 1" diagnostics="doubledElementsLitref_12_de doubledElementsLitref_12_en"/>
            <report test="count(descendant::issn) &gt; 1" diagnostics="doubledElementsLitref_13_de doubledElementsLitref_13_en"/>
            <report test="count(descendant::id[@type = 'doi']) &gt; 1" diagnostics="doubledElementsLitref_14_de doubledElementsLitref_14_en"/>
            <report test="count(descendant::id[@type = 'pubmed']) &gt; 1" diagnostics="doubledElementsLitref_15_de doubledElementsLitref_15_en"/>
            <!--report test="count(descendant::txt) &gt; 1" diagnostics="doubledElementsLitref_16_de doubledElementsLitref_16_en"/-->
        </rule>
    </pattern>

    <diagnostics>
        <diagnostic id="doubledElementsLitref_01_de" xml:lang="de">volume kommt mehrmals innerhalb der Referenz vor.</diagnostic>
        <diagnostic id="doubledElementsLitref_02_de" xml:lang="de">issue kommt mehrmals innerhalb der Referenz vor.</diagnostic>
        <diagnostic id="doubledElementsLitref_03_de" xml:lang="de">lpage kommt mehrmals innerhalb der Referenz vor.</diagnostic>
        <diagnostic id="doubledElementsLitref_04_de" xml:lang="de">fpage kommt mehrmals innerhalb der Referenz vor.</diagnostic>
        <diagnostic id="doubledElementsLitref_05_de" xml:lang="de">name type="author" sollte maximal 3-mal innerhalb einer Referenz vorkommen.</diagnostic>
        <diagnostic id="doubledElementsLitref_06_de" xml:lang="de">etal kommt mehrmals innerhalb der Referenz vor.</diagnostic>
        <diagnostic id="doubledElementsLitref_07_de" xml:lang="de">anonymous kommt mehrmals innerhalb der Referenz vor.</diagnostic>
        <diagnostic id="doubledElementsLitref_08_de" xml:lang="de">reftitle kommt mehrmals innerhalb der Referenz vor.</diagnostic>
        <diagnostic id="doubledElementsLitref_09_de" xml:lang="de">refpub kommt mehrmals innerhalb der Referenz vor.</diagnostic>
        <diagnostic id="doubledElementsLitref_10_de" xml:lang="de">date kommt mehrmals innerhalb der Referenz vor.</diagnostic>
        <diagnostic id="doubledElementsLitref_11_de" xml:lang="de">supplement kommt mehrmals innerhalb der Referenz vor.</diagnostic>
        <diagnostic id="doubledElementsLitref_12_de" xml:lang="de">uri kommt mehrmals innerhalb der Referenz vor.</diagnostic>
        <diagnostic id="doubledElementsLitref_13_de" xml:lang="de">issn kommt mehrmals innerhalb der Referenz vor.</diagnostic>
        <diagnostic id="doubledElementsLitref_14_de" xml:lang="de">id type = 'doi' kommt mehrmals innerhalb der Referenz vor.</diagnostic>
        <diagnostic id="doubledElementsLitref_15_de" xml:lang="de">id type = 'pubmed' kommt mehrmals innerhalb der Referenz vor.</diagnostic>
        <!--diagnostic id="doubledElementsLitref_16_de" xml:lang="de">txt kommt mehrmals innerhalb der Referenz vor.</diagnostic-->
        <!-- EN -->
        <diagnostic id="doubledElementsLitref_01_en" xml:lang="en">volume occurs more than once in this reference.</diagnostic>
        <diagnostic id="doubledElementsLitref_02_en" xml:lang="en">issue occurs more than once in this reference.</diagnostic>
        <diagnostic id="doubledElementsLitref_03_en" xml:lang="en">lpage occurs more than once in this reference.</diagnostic>
        <diagnostic id="doubledElementsLitref_04_en" xml:lang="en">fpage occurs more than once in this reference.</diagnostic>
        <diagnostic id="doubledElementsLitref_05_en" xml:lang="en">name type="author" should only occur up to three times within a reference.</diagnostic>
        <diagnostic id="doubledElementsLitref_06_en" xml:lang="en">etal occurs more than once in this reference.</diagnostic>
        <diagnostic id="doubledElementsLitref_07_en" xml:lang="en">anonymous occurs more than once in this reference.</diagnostic>
        <diagnostic id="doubledElementsLitref_08_en" xml:lang="en">reftitle occurs more than once in this reference.</diagnostic>
        <diagnostic id="doubledElementsLitref_09_en" xml:lang="en">refpub occurs more than once in this reference.</diagnostic>
        <diagnostic id="doubledElementsLitref_10_en" xml:lang="en">date occurs more than once in this reference.</diagnostic>
        <diagnostic id="doubledElementsLitref_11_en" xml:lang="en">supplement occurs more than once in this reference.</diagnostic>
        <diagnostic id="doubledElementsLitref_12_en" xml:lang="en">uri occurs more than once in this reference.</diagnostic>
        <diagnostic id="doubledElementsLitref_13_en" xml:lang="en">issn occurs more than once in this reference.</diagnostic>
        <diagnostic id="doubledElementsLitref_14_en" xml:lang="en">id type = 'doi' occurs more than once in this reference.</diagnostic>
        <diagnostic id="doubledElementsLitref_15_en" xml:lang="en">id type = 'pubmed' occurs more than once in this reference.</diagnostic>
        <!--diagnostic id="doubledElementsLitref_16_en" xml:lang="en">txt occurs more than once in this reference.</diagnostic-->
    </diagnostics>

    <!--Regel 5-->
    <pattern id="emptyAuthors">
        <title>Autoren leer</title>
        <rule context="jnref/name[@type = 'author']/*" role="error">
            <report test="not(matches(., '[\w]'))" sqf:fix="deleteEmptyName" role="error" diagnostics="emptyAuthors_01_de emptyAuthors_01_en"/>
        </rule>
    </pattern>

    <diagnostics>
        <diagnostic id="emptyAuthors_01_de" xml:lang="de">Autoren-Element in der Literaturreferenz ist leer.</diagnostic>
        <!-- EN -->
        <diagnostic id="emptyAuthors_01_en" xml:lang="en">The author element in the literature reference is empty.</diagnostic>
    </diagnostics>

    <!--Regel 6-->
    <pattern id="startingWithPunctuation">
        <title>Interpunktion zu Beginn der Literaturreferenz</title>
        <rule context="litref//*[not(*)]/text()" role="error">
            <report test="matches(., '^[\s\\.\\,;\-\\?_\\!]+[\s]*.*$')" sqf:fix="deleteStartingPunctuation" role="error" diagnostics="startingWithPunctuation_01_de startingWithPunctuation_01_en"/>
        </rule>
    </pattern>

    <diagnostics>
        <diagnostic id="startingWithPunctuation_01_de" xml:lang="de">Dieses Kindelement von litref beginnt mit einem Interpunktions- und/oder Leerzeichen.</diagnostic>
        <!-- EN -->
        <diagnostic id="startingWithPunctuation_01_en" xml:lang="en">This child element of litref starts with a punctuation marks or/and blank space.</diagnostic>
    </diagnostics>

    <!--Regel 7-->
    <pattern id="startingWithDOI">
        <title>Präfix vor DOI</title>
        <!--<rule context="id[@type='doi']/text()" role="error">            
            <report test="matches(.,'^doi:?.*$')" sqf:fix="deleteStartingDOI" role="error">Vor einem DOI darf kein Präfix stehen</report>            
        </rule>-->
        <!--rule abgeleitet aus dem pattern metadata-->
        <rule context="(metadata | (jnref | bkref | chref)/id[1])[@type = 'doi']/text()">
            <report test="matches(., '^doi:?.*$')" sqf:fix="deleteStartingDOI" role="error" diagnostics="startingWithDOI_01_de startingWithDOI_01_en"/>
            <!--<report test="matches(., '[^a-z0-9\.\-/]')">Die DOI darf nur Buchstaben, Zahlen, Punkte, Bindestriche und Slashes (/) enthalten</report>-->
            <report test="not(matches(., '^\d{2}\.\d{4}.*$'))" diagnostics="startingWithDOI_02_de startingWithDOI_02_en"/>
        </rule>
    </pattern>
    <diagnostics>
        <diagnostic id="startingWithDOI_01_de" xml:lang="de">Vor einem DOI darf kein Präfix stehen.</diagnostic>
        <diagnostic id="startingWithDOI_02_de" xml:lang="de">Die DOI muss ein Präfix in der Struktur XX.XXXX (X: beliebige Ziffer) enthalten. Bitte überprüfen Sie die DOI.</diagnostic>
        <!-- EN -->
        <diagnostic id="startingWithDOI_01_en" xml:lang="en">A DOI must not be preceded by a prefix.</diagnostic>
        <diagnostic id="startingWithDOI_02_en" xml:lang="en">The DOI must contain a prefix of the structure XX.XXXX (X:any digit). Please check the DOI.</diagnostic>
    </diagnostics>

    <!--Regel 8-->
    <pattern id="searchProcessingInstruction">
        <title>Processing instruction</title>
        <rule context="litref//processing-instruction()">
            <report test="." sqf:fix="deleteProcessingInstruction" role="error" diagnostics="searchProcessingInstruction_01_de searchProcessingInstruction_01_en"/>
        </rule>
    </pattern>
    <diagnostics>
        <diagnostic id="searchProcessingInstruction_01_de" xml:lang="de">Innerhalb der Literaturreferenzen steht eine Processing Instruction.</diagnostic>
        <!-- EN -->
        <diagnostic id="searchProcessingInstruction_01_en" xml:lang="en">The literature reference contains a processing instruction.</diagnostic>
    </diagnostics>

    <!--Regel 9-->
    <pattern id="textContentInLitref">
        <title>Interpunktionen und Text in Literaturreferenzen</title>
        <rule context="(litref | jnref | litref/jnref/name[@type = 'author'] | litref/jnref/name[@type = 'editor'])[normalize-space(string-join(text())) != '']">
            <report test="." sqf:fix="deleteTextNodes" role="warn" diagnostics="textContentInLitref_01_de textContentInLitref_01_en"/>
        </rule>
    </pattern>
    <diagnostics>
        <diagnostic id="textContentInLitref_01_de" xml:lang="de">Innerhalb der Literaturreferenzen stehen Interpunktionen oder Leerzeichen.</diagnostic>
        <!-- EN -->
        <diagnostic id="textContentInLitref_01_en" xml:lang="en">The literature reference contains punctuation marks or blank spaces.</diagnostic>
    </diagnostics>

    <!--Regel 10 nicht umgesetzt-->
    <!--Regel 11-->
    <pattern id="fz_sectionLitref">
        <title>Literatur-Section</title>
        <rule context="section[litref][not(matches((descendant::metadata[@type = 'layout'] | preceding::metadata[@type = 'layout']), '^04a01$'))]">
            <report test="not(@type = 'references')" sqf:fix="addReferences" role="warn" diagnostics="fz_sectionLitref_01_de fz_sectionLitref_01_en"/>
        </rule>
    </pattern>
    <diagnostics>
        <diagnostic id="fz_sectionLitref_01_de" xml:lang="de">Die section, in der die Literaturreferenzen enthalten sind, ist nicht vom type="references".</diagnostic>
        <!-- EN -->
        <diagnostic id="fz_sectionLitref_01_en" xml:lang="en">The section containing the literature references is not of the type="references".</diagnostic>
    </diagnostics>

    <!--Regel 12-->
    <pattern id="metadataSpaces">
        <title>Leerzeichen in Metadaten</title>
        <rule context="metadata[not(metadata)]">
            <report test="matches(., '^\s*.+\s+$')" role="warn" diagnostics="metadataSpaces_01_de metadataSpaces_01_en"/>
        </rule>
    </pattern>
    <diagnostics>
        <diagnostic id="metadataSpaces_01_de" xml:lang="de">In einem oder mehreren Metadaten-Elementen sind Leerzeichen am Ende enthalten. Bitte entfernen Sie die Leerzeichen in censhare.</diagnostic>
        <!-- EN -->
        <diagnostic id="metadataSpaces_01_en" xml:lang="en">One or more elements of the metadata contain blank spaces at the end. Please remove the blank spaces in censhare.</diagnostic>
    </diagnostics>

    <!--Regel 13a-->
    <pattern id="captionStartingWithNumber">
        <title>Nummerierung in Tabelle</title>
        <rule context="table/caption/text()[not(preceding-sibling::*)][1]">
            <report test="matches(., '^[\d]+[\s]*.*$')" role="error" sqf:fix="deleteStartingNumber" diagnostics="captionStartingWithNumber_01_de captionStartingWithNumber_01_en"/>
        </rule>
        <rule context="table/caption/emph[not(preceding-sibling::text())]/text()">
            <report test="matches(., '^[\d]+[\s]*.*$')" role="error" sqf:fix="deleteStartingNumber" diagnostics="captionStartingWithNumber_01_de captionStartingWithNumber_01_en"/>
        </rule>
    </pattern>
    <diagnostics>
        <diagnostic id="captionStartingWithNumber_01_de" xml:lang="de">Die Legende erhält eine Ziffer am Anfang. Die Nummerierung wird im Satz und den elektronischen Marktprodukten automatisch vergeben und sollte daher nicht fix in der Legende stehen.</diagnostic>
        <!-- EN -->
        <diagnostic id="captionStartingWithNumber_01_en" xml:lang="en">The legend is assigned a number at the beginning. The numbering is automatically assigned by the typesetter and by the e-products. Therefore the legend should contain no fixed number.</diagnostic>
    </diagnostics>

    <!--Regel 13b-->
    <pattern id="legendStartingWithNumber">
        <title>Nummerierung in Legende</title>
        <rule context="figure/legend/para/text()[not(preceding-sibling::*)][1]">
            <report test="matches(., '^[\d]+[\s]*.*$')" role="error" sqf:fix="deleteStartingNumber" diagnostics="captionStartingWithNumber_01_de captionStartingWithNumber_01_en"/>
        </rule>
        <rule context="figure/legend/para/emph[not(preceding-sibling::text())]/text()">
            <report test="matches(., '^[\d]+[\s]*.*$')" role="error" sqf:fix="deleteStartingNumber" diagnostics="captionStartingWithNumber_01_de captionStartingWithNumber_01_en"/>
        </rule>
    </pattern>

    <!--Regel 14 Löschen von target; reduntant zu pattern deprecated-->

    <!--Regel 15-->
    <pattern id="categoryLayoutColor">
        <title>Layout und Rubrik</title>
        <rule context="metadata[@type = 'articlemeta']">
            <report test="not(metadata[@type = 'category'] and metadata[@type = 'layout'] and metadata[@type = 'color'])" role="error" diagnostics="categoryLayoutColor_01_de categoryLayoutColor_01_en"/>
        </rule>
    </pattern>
    <diagnostics>
        <diagnostic id="categoryLayoutColor_01_de" xml:lang="de">Die Angaben zu Rubrik und Layout sind nicht enthalten. Bitte pflegen Sie in censhare die Rubrik am Artikel.</diagnostic>
        <!-- EN -->
        <diagnostic id="categoryLayoutColor_01_en" xml:lang="en">The article category and layout specifications are not included. Please add the article's category to the metadata in censhare.</diagnostic>
    </diagnostics>

    <!--Regel 16-->
    <pattern id="cme">
        <title>CME-Fragen</title>
        <rule context="qti">
            <report test="not(response)" role="error" sqf:fix="addResponse" diagnostics="cme_01_de cme_01_en"/>
            <report test="response[matches(., '^\s*$')]" role="error" sqf:fix="addResponseText" diagnostics="cme_01_de cme_01_en"/>
        </rule>
    </pattern>
    <diagnostics>
        <diagnostic id="cme_01_de" xml:lang="de">Die Antwort einer CME-Frage ist nicht gekennzeichnet. TReX korrigieren und neues KIS-XML erzeugen oder manuell in KIS-XML strukturieren.</diagnostic>
        <!-- EN -->
        <diagnostic id="cme_01_en" xml:lang="en">The answer to a CME-question is not marked. Please correct the TReX and create a new KIS-XML or correct manually in KIS-XML.</diagnostic>
    </diagnostics>

    <!--Regel 17-->
    <pattern id="authorAffiliation">
        <title>Affiliation</title>
        <rule context="metadata[@type = 'author']">
            <report test="not(matches(preceding-sibling::metadata[@type = 'layout'], '^04a01$')) and (not(metadata[@type = 'affiliation']))" role="warn" diagnostics="authorAffiliation_01_de authorAffiliation_01_en"/>
        </rule>
    </pattern>
    <diagnostics>
        <!--diagnostic id="authorAffiliation_01_de" xml:lang="de">Am Autor ist keine Affiliation gepflegt. Bitte pflegen Sie in censhare ggf. die Affiliation des Autors.</diagnostic-->
        <diagnostic id="authorAffiliation_01_de" xml:lang="de">Am Autor ist keine Vita oder Affiliation gepflegt. Bitte pflegen Sie in censhare ggf. die Affiliation des Autors.</diagnostic>
        <!-- EN -->
        <!--diagnostic id="authorAffiliation_01_en" xml:lang="en">No affiliation is included for the author. Please add the author's affiliation in censhare if necessary.</diagnostic-->
        <diagnostic id="authorAffiliation_01_en" xml:lang="en">No vita or affiliation is included for the author. Please add the author's affiliation in censhare if necessary.</diagnostic>
    </diagnostics>

    <!--Regel 18-->
    <pattern id="correspaddressEmailPhone">
        <title>Korrespondenzadresse: Email, Telefon</title>
        <rule context="metadata[@type = 'correspaddress']">
            <report test="not(metadata[@type = 'email'] | metadata[@type = 'telephone'])" role="warn" diagnostics="correspaddressEmailPhone_01_de correspaddressEmailPhone_01_en"/>
        </rule>
    </pattern>
    <diagnostics>
        <diagnostic id="correspaddressEmailPhone_01_de" xml:lang="de">An der Korrespondenzadresse ist keine E-Mail-Adresse und/oder Telefonnummer gepflegt.</diagnostic>
        <!-- EN -->
        <diagnostic id="correspaddressEmailPhone_01_en" xml:lang="en">The correspondence address does not contain any e-mail address and/or telephone number.</diagnostic>
    </diagnostics>

    <!-- Regel 18a -->
    <pattern id="correspaddressCountry">
        <title>Korrespondenzadresse: Land</title>
        <rule context="metadata[@type = 'correspaddress']">
            <report test="not(metadata[@type = 'country'])" role="error" diagnostics="correspaddressCountry_01_de correspaddressCountry_01_en"/>
        </rule>
    </pattern>
    <diagnostics>
        <diagnostic id="correspaddressCountry_01_de" xml:lang="de">An der Korrespondenzadresse ist kein Land gepflegt. Bitte in censhare ein Land hinzufügen.</diagnostic>
        <!-- EN -->
        <diagnostic id="correspaddressCountry_01_en" xml:lang="en">The correspondence address does not contain a country. Please add the country in censhare.</diagnostic>
    </diagnostics>

    <!--Regel 19-->
    <pattern id="correspauthorAddress">
        <title>Korrespondenzadresse fehlt</title>
        <rule context="metadata[@type = 'correspauthor']">
            <report test="not(metadata[@type = 'correspaddress'])" role="warn" diagnostics="correspauthorAddress_01_de correspauthorAddress_01_en"/>
        </rule>
    </pattern>
    <diagnostics>
        <!--diagnostic id="correspauthorAddress_01_de" xml:lang="de">metadata type correspauthor muss immer ein metadata type correspaddress enthalten.</diagnostic-->
        <diagnostic id="correspauthorAddress_01_de" xml:lang="de">metadata type correspauthor muss immer eine vollständige Korrespondenzadresse enthalten</diagnostic>
        <!-- EN -->
        <!--diagnostic id="correspauthorAddress_01_en" xml:lang="en">metadata type correspauthor must always contain the metadata type correspaddress.</diagnostic-->
        <diagnostic id="correspauthorAddress_01_en" xml:lang="en">metadata type correspauthor must always contain a full correspondence address.</diagnostic>
    </diagnostics>

    <!--Regel 20-->
    <pattern id="emptyPara">
        <title>Leerer Absatz</title>
        <rule context="para[not(parent::td)][not(parent::th)][not(ancestor::figure[not(child::tableau) and (string-length(child::title/text()) >0)])]"> 
            <report test="not(*) and not(matches(., '\S'))" role="error" sqf:fix="deleteEmptyPara" diagnostics="emptyPara_01_de emptyPara_01_en"/>
        </rule>
    </pattern>
    <diagnostics>
        <diagnostic id="emptyPara_01_de" xml:lang="de">Es sind leere Absätze enthalten. Bitte entfernen.</diagnostic>
        <!-- EN -->
        <diagnostic id="emptyPara_01_en" xml:lang="en">There are empty paragraphs. Please remove them.</diagnostic>
    </diagnostics>

    <!--ADD 2020-12-04 from KIS Schematron Abgleich mit Buch.pdf - modifizierte Patterns aus kis-check.sch für Datenstruktur Fachzeitschriften -->
    <!-- subset abgeleitet aus dem pattern info-->
    <pattern id="fz_info">
        <title>Infomeldungen</title>
        <rule context="/" role="Versionsinfo und Statistik">
            <report test="." role="info" diagnostics="fz_info_01_de fz_info_01_en"/>
            <report test="." role="info" diagnostics="fz_info_02_de fz_info_02_en"/>
            <report test="." role="info" diagnostics="fz_info_03_de fz_info_03_en"/>
            <report test=".[//@index]" role="info" diagnostics="fz_info_04_de fz_info_04_en"/>
        </rule>
    </pattern>

    <diagnostics>
        <diagnostic id="fz_info_01_de" xml:lang="de"> [Statistik] Links: <value-of select="count(//link[@idref = $ids])"/> valide + <value-of select="count($idrefs) - count(//link[@idref = $ids])"/> invalide + <value-of select="count(//link[not(@idref)])"/> leer = <value-of select="count(//link)"/> gesamt</diagnostic>
        <diagnostic id="fz_info_02_de" xml:lang="de"> [Statistik] Linkziele: <value-of select="count($ids[. = $idrefs])"/> genutzt + <value-of select="count($ids) - count(//@id[. = $idrefs])"/> ungenutzt = <value-of select="count($ids)"/> gesamt</diagnostic>
        <diagnostic id="fz_info_03_de" xml:lang="de"> [Statistik] Medien: <value-of select="$valid_filerefs"/> verknüpft + <value-of select="$all_filerefs - $valid_filerefs - $empty_filerefs"/> fehlerhaft + <value-of select="$empty_filerefs"/> leer = <value-of select="$all_filerefs"/> gesamt</diagnostic>
        <diagnostic id="fz_info_04_de" xml:lang="de"> [Statistik] Indices: <value-of select="string-join(distinct-values(//@index), ', ')"/></diagnostic>
        <!-- EN -->
        <diagnostic id="fz_info_01_en" xml:lang="en"> [Statistics] Links: <value-of select="count(//link[@idref = $ids])"/> valid + <value-of select="count($idrefs) - count(//link[@idref = $ids])"/> invalid + <value-of select="count(//link[not(@idref)])"/> empty = <value-of select="count(//link)"/> total</diagnostic>
        <diagnostic id="fz_info_02_en" xml:lang="en"> [Statistics] Link targets: <value-of select="count($ids[. = $idrefs])"/> used + <value-of select="count($ids) - count(//@id[. = $idrefs])"/> not used = <value-of select="count($ids)"/> total </diagnostic>
        <diagnostic id="fz_info_03_en" xml:lang="en"> [Statistics] Media files: <value-of select="$valid_filerefs"/> referenced + <value-of select="$all_filerefs - $valid_filerefs - $empty_filerefs"/> invalid + <value-of select="$empty_filerefs"/> empty = <value-of select="$all_filerefs"/> total</diagnostic>
        <diagnostic id="fz_info_04_en" xml:lang="en"> [Statistics] Indices: <value-of select="string-join(distinct-values(//@index), ', ')"/></diagnostic>
    </diagnostics>

    <!--subset abgeleitet aus dem pattern metadata-->
    <pattern id="fz_metadata_subset_DOI_startnum">
        <title>Startnummer</title>
        <rule context="@startnum" role="error">
            <sqf:fix id="startnum-dups">
                <sqf:description>
                    <sqf:title ref="fix_duplicates_title_de fix_duplicates_title_en"/>
                    <sqf:p ref="fix_duplicates_p_de fix_duplicates_p_en"/>
                </sqf:description>
                <sqf:delete match="//(document | section)/@startnum[not(generate-id() = generate-id(current()))]"/>
            </sqf:fix>
            <report test="count(//(document | section)/@startnum) > 1" sqf:fix="startnum-dups" diagnostics="fz_metadata_subset_DOI_startnum_01_de fz_metadata_subset_DOI_startnum_01_en"/>
        </rule>
    </pattern>
    <diagnostics>
        <diagnostic id="fz_metadata_subset_DOI_startnum_01_de" xml:lang="de">Das Dokument enthält mehrere Startnummern, darf aber nur eine Startnummer enthalten.</diagnostic>
        <!-- EN -->
        <diagnostic id="fz_metadata_subset_DOI_startnum_01_en" xml:lang="en">The document contains several start numbers, but may contain only one start number</diagnostic>
    </diagnostics>

    <!--subset abgeleitet aus dem pattern links-->
    <pattern id="fz_links">
        <title>Verlinkungen</title>
        <rule context="link/@idref" role="Gültigkeitsprüfungen für gesetzte Links">
            <report test="matches(., '[^A-Za-z0-9:_\.\-]')" role="error" sqf:fix="sonderzeichen" diagnostics="fz_links_01_de fz_links_01_en"/>
            <assert test=". = $ids" role="error" diagnostics="fz_links_02_de fz_links_02_en"/>
            <sqf:fix id="sonderzeichen">
                <sqf:description>
                    <sqf:title ref="fix_sonderzeichen_title_de fix_sonderzeichen_title_en"/>
                    <sqf:p ref="fix_sonderzeichen_p_de fix_sonderzeichen_p_en"/>
                </sqf:description>
                <let name="clean_id" value="replace(., '[^A-Za-z0-9:_\.\-]', '_')"/>
                <sqf:replace node-type="attribute" match="$ids[. = current()]" target="id" use-when="not($ids[. = $clean_id])">
                    <value-of select="$clean_id"/>
                </sqf:replace>
                <sqf:replace node-type="attribute" target="idref" use-when="not($ids[. = $clean_id])">
                    <value-of select="$clean_id"/>
                </sqf:replace>
            </sqf:fix>
        </rule>
        <rule context="link[@idref = $ids]" role="Gültigkeitsprüfung für alle Links">
            <let name="id" value="@idref"/>
            <let name="element" value="(//*[@id = $id])[1]"/>
            <report role="error" test="@idref = $ids and @target = ('audio', 'figure', 'video') and not($element/name() = ('figure', 'subfigure'))" diagnostics="fz_links_03_de fz_links_03_en"/>
            <report role="error" test="@idref = $ids and @target = ('box', 'formula', 'part', 'section', 'table') and not($element/name() = @target)" sqf:fix="target" diagnostics="fz_links_04_de fz_links_04_en"/>
            <report role="error" test="@idref = $ids and @target = 'excursus' and not($element/name() = ('section'))" diagnostics="fz_links_05_de fz_links_05_en"/>
            <report role="error" test="@target = 'page' and string-length(normalize-space(.)) = 0" diagnostics="fz_links_06_de fz_links_06_en"/>
            <report role="warn" test="@target = ('audio', 'figure', 'video', 'table') and (following-sibling::node()[1]/@target = 'page' or string-length(normalize-space(following-sibling::node()[1])) &lt; 5 and following-sibling::node()[2]/@target = 'page')" diagnostics="fz_links_07_de fz_links_07_en"/>
            <sqf:fix id="target">
                <sqf:description>
                    <sqf:title ref="fix_target_title_de fix_target_title_en"/>
                    <sqf:p ref="fix_target_p_de fix_target_p_en"/>
                </sqf:description>
                <sqf:add target="target" node-type="attribute" select="$element/name()" use-when="$element/name() = ('box', 'formula', 'part', 'section', 'table')"/>
            </sqf:fix>
        </rule>
        <rule context="uri" role="Uris prüfen">
            <assert role="error" test="@type = 'email' or matches(@href, '^(https?|ftp)://[^\s/$\.?#\\\(\)]+\.[^\s\\\(\)]+$')" diagnostics="fz_links_08_de fz_links_08_en"/>
            <report role="error" test="@type = 'email' and not(matches(@href, '^[^0-9\s]\S+@\S+\.\S+$'))" diagnostics="fz_links_09_de fz_links_09_en"/>
        </rule>
        <rule context="para/text() | emph/text() | footnote/text() | literature/text()" role="Text mit möglichen Uris">
            <report role="error" test="contains(., 'www.')" sqf:fix="uri" diagnostics="fz_links_10_de fz_links_10_en"/>
            <report role="error" test="matches(., '[^0-9\s]\S+@\S+\.\S+')" sqf:fix="uri-mail" diagnostics="fz_links_11_de fz_links_11_en"/>
            <sqf:fix id="uri">
                <sqf:description>
                    <sqf:title ref="fix_uri_title_de fix_uri_title_en"/>
                    <sqf:p ref="fix_uri_p_de fix_uri_p_en"/>
                </sqf:description>
                <sqf:stringReplace regex="(((https?|ftp)://|www\.)[^\s/$.?#].[^\s]*)">
                    <xsl:analyze-string select="." regex="(((https?|ftp)://|www\.)[^\s/$.?#].[^\s]*)">
                        <xsl:matching-substring>
                            <uri xmlns="" href="{if(starts-with(regex-group(1),'www')) then 'https://' else ''}{regex-group(1)}">
                                <xsl:copy-of select="regex-group(1)"/>
                            </uri>
                        </xsl:matching-substring>
                    </xsl:analyze-string>
                </sqf:stringReplace>
            </sqf:fix>
            <sqf:fix id="uri-mail">
                <sqf:description>
                    <sqf:title ref="fix_uri-mail_title_de fix_uri-mail_title_en"/>
                    <sqf:p ref="fix_uri-mail_p_de fix_uri-mail_p_en"/>
                </sqf:description>
                <sqf:stringReplace regex="(\S+@\S+\.\S+)">
                    <xsl:analyze-string select="." regex="(\S+@\S+\.\S+)">
                        <xsl:matching-substring>
                            <uri xmlns="" href="{regex-group(1)}" type="email">
                                <xsl:copy-of select="regex-group(1)"/>
                            </uri>
                        </xsl:matching-substring>
                    </xsl:analyze-string>
                </sqf:stringReplace>
            </sqf:fix>
        </rule>
        <rule context="figure" role="Prüfung auf fehlerhaft verlinkte Abbildungen">
            <assert test="@counter = 'no' or .//@id = $idrefs" role="error" diagnostics="fz_links_12_de fz_links_12_en"/>
            <report test="//link[@idref = current()//@id and @target = ('audio', 'figure', 'video')] and not(.//legend | .//title)" role="error" sqf:fix="addtitle addlegend" diagnostics="fz_links_13_de fz_links_13_en"/>
            <let name="filerefs" value=".//@fileref[string-length(normalize-space()) > 0]"/>
            <assert role="error" test="count(distinct-values($filerefs)) = count($filerefs)" diagnostics="fz_links_14_de fz_links_14_en"/>
        </rule>
        <rule context="table" role="Prüfung auf fehlerhaft verlinkte Tabellen">
            <assert test="@counter = 'no' or .//@id = $idrefs" role="error" diagnostics="fz_links_15_de fz_links_15_en"/>
        </rule>
    </pattern>

    <diagnostics>
        <diagnostic id="fz_links_01_de" xml:lang="de">IDs dürfen keine Sonderzeichen enthalten, da dies zu Problemen in EPUBs oder Webanwendungen führen könnte.</diagnostic>
        <diagnostic id="fz_links_02_de" xml:lang="de">Link <value-of select="current()"/> hat kein gültiges Ziel</diagnostic>
        <diagnostic id="fz_links_03_de" xml:lang="de">Dieser Link mit @target=<value-of select="@target"/> verweist auf <value-of select="$element/name()"/> und nicht auf eine Abbildung. Das Ziel muss (sub-)figure sein.</diagnostic>
        <diagnostic id="fz_links_04_de" xml:lang="de">Dieser Link mit @target=<value-of select="@target"/> verweist auf <value-of select="$element/name()"/>, muss aber auf <value-of select="@target"/> verweisen.</diagnostic>
        <diagnostic id="fz_links_05_de" xml:lang="de">Dieser Link mit @target=<value-of select="@target"/> verweist auf <value-of select="$element/name()"/> und nicht auf ein Kapitel. Das Ziel muss section sein.</diagnostic>
        <diagnostic id="fz_links_06_de" xml:lang="de">Dieser Link muss echten Text beinhalten.</diagnostic>
        <diagnostic id="fz_links_07_de" xml:lang="de">Laut Redaktionsrichtlinie darf auf einen Abbildungs- oder Tabellenverweis kein Seitenverweis folgen.</diagnostic>
        <diagnostic id="fz_links_08_de" xml:lang="de">Die angegebene URL ist nicht zulässig, da sie falsch formatiert ist oder ungültige Zeichen beinhaltet.</diagnostic>
        <diagnostic id="fz_links_09_de" xml:lang="de">Die angegebene E-Mail ist nicht zulässig.</diagnostic>
        <diagnostic id="fz_links_10_de" xml:lang="de">In diesem Absatz ist eine Webadresse nicht verlinkt. Damit fz_links anklickbar sind, müssen diese mit uri ausgezeichnet werden.</diagnostic>
        <diagnostic id="fz_links_11_de" xml:lang="de">Möglicherweise ist in diesem Absatz eine E-Mail-Adresse nicht verlinkt. Damit fz_links anklickbar sind, müssen diese mit uri ausgezeichnet werden.</diagnostic>
        <diagnostic id="fz_links_12_de" xml:lang="de">Diese nummerierte figure ist nicht im Text verlinkt, es sollten aber alle figures im Text referenziert sein (redaktionelle Anforderung).</diagnostic>
        <diagnostic id="fz_links_13_de" xml:lang="de">Auf diesen Abbildungscontainer wurde verlinkt (<value-of select=".//@id[. = $idrefs]"/>). Er benötigt daher einen Titel oder eine Legende, damit eine Abbildungsnummer generiert werden kann.</diagnostic>
        <diagnostic id="fz_links_14_de" xml:lang="de">In dieser <value-of select="name()"/> wurde dieselbe Abbildung mehrfach referenziert, bitte Duplikate löschen.</diagnostic>
        <diagnostic id="fz_links_15_de" xml:lang="de">Diese nummerierte <value-of select="name()"/> ist nicht verlinkt, es sollten aber alle tables im Text referenziert sein (redaktionelle Anforderung).</diagnostic>

        <!-- EN -->
        <diagnostic id="fz_links_01_en" xml:lang="en">IDs must not contain special characters, since this could cause problems in ePubs or web applications.</diagnostic>
        <diagnostic id="fz_links_02_en" xml:lang="en">Link <value-of select="current()"/> has no valid target</diagnostic>
        <diagnostic id="fz_links_03_en" xml:lang="en">This link with the @target=<value-of select="@target"/> refers to <value-of select="$element/name()"/> and not to a figure. The target should be (sub-)figure.</diagnostic>
        <diagnostic id="fz_links_04_en" xml:lang="en">This link with the @target=<value-of select="@target"/> refers to <value-of select="$element/name()"/>, but should link to <value-of select="@target"/>.</diagnostic>
        <diagnostic id="fz_links_05_en" xml:lang="en">This link with the @target=<value-of select="@target"/> refers to <value-of select="$element/name()"/> and not to a section. The target should be section.</diagnostic>
        <diagnostic id="fz_links_06_en" xml:lang="en">This link should contain real text.</diagnostic>
        <diagnostic id="fz_links_07_en" xml:lang="en">According to the editorial guidelines a figure or table reference must not be followed by a page reference.</diagnostic>
        <diagnostic id="fz_links_08_en" xml:lang="en">The specified URL is not allowed, because it is formatted incorrectly or contains invalid characters.</diagnostic>
        <diagnostic id="fz_links_09_en" xml:lang="en">The specified email is not allowed.</diagnostic>
        <diagnostic id="fz_links_10_en" xml:lang="en">A web address in this paragraph is not linked. For fz_links to be clickable, they must be marked with uri.</diagnostic>
        <diagnostic id="fz_links_11_en" xml:lang="en">An e-mail address in this paragraph is not linked. For fz_links to be clickable, they must be marked with uri.</diagnostic>
        <diagnostic id="fz_links_12_en" xml:lang="en">This <value-of select="name()"/> is not linked, however all <value-of select="name()"/>s should be linked.</diagnostic>
        <diagnostic id="fz_links_13_en" xml:lang="en">This figure container was linked to (<value-of select=".//@id[. = $idrefs]"/>). It therefore needs a title or legend so that a figure number can be generated.</diagnostic>
        <diagnostic id="fz_links_14_en" xml:lang="en">In this figure the same image is referenced multiple times, please delete duplicates.</diagnostic>
        <diagnostic id="fz_links_15_en" xml:lang="en">This <value-of select="name()"/> is not linked, however all <value-of select="name()"/>s should be linked.</diagnostic>
    </diagnostics>

    <!--subset abgeleitet aus dem pattern tables-->
    <pattern id="fz_tables">
        <title>Tabellen</title>
        <rule context="col" role="Prüfe auf gültigen col-Wert">
            <assert role="error" test="matches(@width, '^\d+(%|px|pt)?$')" diagnostics="fz_tables_01_de fz_tables_01_en"/>
        </rule>
        <rule context="table" role="Colspan- und Tabellenkopf-Überprüfung bei Tabellen">
            <let name="colsnr" value=".//col/number(replace(@width, '[^\d]', ''))"/>
            <assert role="error" test="
                    count(.//tr) * count(.//col) = sum(for $n in .//(td | th)
                    return
                        number(($n/@colspan,
                        '1')[1]) * number(($n/@rowspan,
                        '1')[1]))" diagnostics="fz_tables_02_de fz_tables_02_en"/>
            <report test="count(distinct-values(.//col/replace(@width, '\d', ''))) > 1" subject="col" diagnostics="fz_tables_03_de fz_tables_03_en"/>
            <report test="max($colsnr) &gt; min($colsnr) * 10" role="warn" diagnostics="fz_tables_04_de fz_tables_04_en"/>
            <assert role="warn" test="thead" sqf:fix="addthead" diagnostics="fz_tables_05_de fz_tables_05_en"/>
            <sqf:fix id="addthead">
                <sqf:description>
                    <sqf:title ref="fix_addthead_title_de fix_addthead_title_en"/>
                    <sqf:p ref="fix_addthead_p_de fix_addthead_p_en"/>
                </sqf:description>
                <sqf:add target="thead" node-type="element" position="first-child" select="tbody/tr[1]"/>
                <sqf:delete match="tbody/tr[1]"/>
            </sqf:fix>
        </rule>
    </pattern>
    <diagnostics>
        <diagnostic id="fz_tables_01_de" xml:lang="de">Der col-Wert ist ungültig. Erlaubt sind nur Zahlen; optional mit den Einheiten %, px oder p.</diagnostic>
        <diagnostic id="fz_tables_02_de" xml:lang="de">Die Anzahl der Zellen ist ungültig. Bitte überprüfen Sie die Anzahl der col-Elemente, sowie die Attribute @colspan und @rowspan. Bei der Fehlersuche hilft die Autorenansicht.</diagnostic>
        <diagnostic id="fz_tables_03_de" xml:lang="de">Es dürfen nur gleiche Maßeinheiten in einer Tabelle verwendet werden.</diagnostic>
        <diagnostic id="fz_tables_04_de" xml:lang="de">Die Spaltenbreiten weisen extreme Verhältnisse auf (liegen mehr als um den Faktor 10 auseinander) und müssen überprüft werden.</diagnostic>
        <diagnostic id="fz_tables_05_de" xml:lang="de">Die Tabelle hat keine Kopfzeile. Falls die Tabelle eine Kopfzeile besitzt, strukturieren Sie diese bitte mit thead.</diagnostic>
        <!-- EN -->

        <diagnostic id="fz_tables_01_en" xml:lang="en">The col-value is invalid. Only numbers are allowed; optionally with the units %, px or pt.</diagnostic>
        <diagnostic id="fz_tables_02_en" xml:lang="en">The number of cells is invalid. Please check the number of col-elements, as well as the attributes @colspan and @rowspan.</diagnostic>
        <diagnostic id="fz_tables_03_en" xml:lang="en">Only the same units of measurement may be used in a table.</diagnostic>
        <diagnostic id="fz_tables_04_en" xml:lang="en">The column widths feature extreme ratios (values more than a factor of 10 apart) and need to be checked.</diagnostic>
        <diagnostic id="fz_tables_05_en" xml:lang="en">The table does not have a headline. If the table has a headline, please structure it with thead.</diagnostic>
    </diagnostics>


    <pattern id="fz_partsection">
        <title>Kapitel und Werkteile</title>
        <rule context="document[part]" role="Prüfung auf erforderliche Werkteile">
            <report test="count(part[@type = 'content']) &lt; 1" sqf:fix="fz-addparttype" diagnostics="fz_partsection_01_de fz_partsection_01_en"/>
            <sqf:fix id="fz-addparttype">
                <sqf:description>
                    <sqf:title ref="fix_fz-addparttype_title_de fix_fz-addparttype_title_en"/>
                    <sqf:p ref="fix_fz-addparttype_p_de fix_fz-addparttype_p_en"/>
                </sqf:description>
                <sqf:add target="type" match="part" node-type="attribute" select="'content'"/>
            </sqf:fix>
        </rule>
        <rule context="part/section" role="Prüfung der EPub-Dateigröße">
            <let name="size" value="string-length(string-join(.//*/text(), '')) * 1.4"/>
            <let name="maxsize" value="400000"/>
            <report test="$size > $maxsize and count(.//processing-instruction()) = 0" role="warn" diagnostics="fz_partsection_02_de fz_partsection_02_en"/>
        </rule>
        <rule context="section/section" role="Absatzprüfung">
            <assert test="* except (title | shorttitle)" sqf:fix="remvalue" diagnostics="fz_partsection_03_de fz_partsection_03_en"/>
            <report test="count(ancestor::section) &gt; 6" diagnostics="fz_partsection_04_de fz_partsection_04_en"/>
        </rule>
    </pattern>
    <diagnostics>
        <diagnostic id="fz_partsection_01_de" xml:lang="de">Pro Werk muss mindestens ein Content-Teil enthalten sein.</diagnostic>
        <diagnostic id="fz_partsection_02_de" xml:lang="de">Dieses Kapitel ist voraussichtlich um <value-of select="round(($size - $maxsize) div 1024)"/> kB zu groß und muss für EPub mit einer PI getrennt werden.</diagnostic>
        <diagnostic id="fz_partsection_03_de" xml:lang="de">Dieses Kapitel ist leer, es muss neben dem Titel noch weitere Elemente beinhalten.</diagnostic>
        <diagnostic id="fz_partsection_04_de" xml:lang="de">Es dürfen nicht mehr als sieben Kapitelhierarchiestufen verwendet werden.</diagnostic>
        <!-- quickfixes -->
        <diagnostic id="fix_fz-addparttype_title_de" xml:lang="de">Part-Typen hinzufügen</diagnostic>
        <diagnostic id="fix_fz-addparttype_p_de" xml:lang="de">Prüfen ob Content-Part vorhanden ist.</diagnostic>

        <!-- EN -->
        <diagnostic id="fz_partsection_01_en" xml:lang="en">At least one content part must be included per book.</diagnostic>
        <diagnostic id="fz_partsection_02_en" xml:lang="en">This chapter is expected to be <value-of select="round(($size - $maxsize) div 1024)"/> kB too large and must be split with a PI for ePub.</diagnostic>
        <diagnostic id="fz_partsection_03_en" xml:lang="en">This chapter is empty, it must contain other elements besides title.</diagnostic>
        <diagnostic id="fz_partsection_04_en" xml:lang="en">No more than seven chapter hierarchy levels are allowed to be used.</diagnostic>
        <!-- quickfixes -->
        <diagnostic id="fix_fz-addparttype_title_en" xml:lang="en">Add part types</diagnostic>
        <diagnostic id="fix_fz-addparttype_p_en" xml:lang="en">Check, if there is a content part</diagnostic>
    </diagnostics>

    <!--subset abgeleitet aus dem subset text-->
    <pattern id="fz_para">
        <title>Absätze</title>
        <rule abstract="true" id="fz_rule-1" role="Prüfung auf Whitespace">
            <report role="warn" test="starts-with(descendant::text()[1], ' ') and not(name(*[1]) = 'link')" diagnostics="fz_para_01_de fz_para_01_en"/>
        </rule>
        <rule context="emph" role="Prüfung der Auszeichnungen">
            <sqf:fix id="emph-combine">
                <sqf:description>
                    <sqf:title ref="fix_emph-combine_title_de fix_emph-combine_title_en"/>
                    <sqf:p ref="fix_emph-combine_p_de fix_emph-combine_p_en"/>
                </sqf:description>
                <let name="content" value="child::node()"/>
                <sqf:add match="preceding-sibling::node()[1][name() = 'emph']" position="last-child" select="$content"/>
                <sqf:delete/>
            </sqf:fix>
            <report role="warn" test="preceding-sibling::node()[1][name() = 'emph' and @type = current()/@type]" sqf:fix="emph-combine" diagnostics="fz_para_02_de fz_para_02_en"/>
            <report role="warn" test="matches(preceding-sibling::node()[1][self::text()], '^\s*$') and preceding-sibling::node()[2][name() = 'emph' and @type = current()/@type]" diagnostics="fz_para_02_de fz_para_02_en"/>
            <report role="warn" test="string-length(normalize-space()) = 0" sqf:fix="remelm" diagnostics="fz_para_03_de fz_para_03_en"/>
        </rule>
        <rule context="para" role="Paraprüfung">
            <report test="uri[@type = 'qrcode'] and count(descendant::node()) &gt; 1" diagnostics="fz_para_04_de fz_para_04_en"/>
            <report test="matches(., 'HYPERLINK|REF _Ref')" diagnostics="fz_para_05_de fz_para_05_en"/>
            <extends rule="fz_rule-1"/>
        </rule>
        <rule context="comment()" role="Prüfung auf defekte Verweise">
            <report test="matches(., 'Nicht identfizierbares Feld')" diagnostics="fz_para_06_de fz_para_06_en"/>
        </rule>
        <rule context="notInFont" role="notInFont">
            <report role="warn" test="." diagnostics="fz_para_07_de fz_para_07_en"/>
        </rule>
        <rule context="processing-instruction('oxy_comment_start')" role="Oxygen-Kommentare">
            <report test="." role="warn" diagnostics="fz_para_08_de fz_para_08_en"/>
        </rule>
    </pattern>
    <diagnostics>
        <diagnostic id="fz_para_01_de" xml:lang="de">Whitespace zu Beginn von <value-of select="name()"/></diagnostic>
        <diagnostic id="fz_para_02_de" xml:lang="de">Dieses <value-of select="name()"/> kann mit dem vorhergehenden <value-of select="name()"/> zusammengeführt werden.</diagnostic>
        <diagnostic id="fz_para_03_de" xml:lang="de">Dieses <value-of select="name()"/> wird wahrscheinlich nicht benötigt und kann entfernt werden.</diagnostic>
        <!--diagnostic id="fz_para_04_de" xml:lang="de">Ein QR-Code link muss exklusiv in einem fz_para stehen.</diagnostic-->
        <diagnostic id="fz_para_04_de" xml:lang="de">Ein QR-Code link muss in einem separaten Absatz stehen.</diagnostic>
        <diagnostic id="fz_para_05_de" xml:lang="de">In diesem <value-of select="name()"/> ist ein defekter Verweis enthalten.</diagnostic>
        <diagnostic id="fz_para_06_de" xml:lang="de">In diesem Absatz ist ein defekter Verweis enthalten.</diagnostic>
        <diagnostic id="fz_para_07_de" xml:lang="de">Im Dokument sind <value-of select="name()"/>-Elemente enthalten.</diagnostic>
        <diagnostic id="fz_para_08_de" xml:lang="de">Dieser Oxygen-Kommentar deutet auf eine unfertige XML-Datei hin.</diagnostic>

        <!-- EN -->
        <diagnostic id="fz_para_01_en" xml:lang="en">Blank space at the beginning of <value-of select="name()"/>.</diagnostic>
        <diagnostic id="fz_para_02_en" xml:lang="en">This <value-of select="name()"/> can be merged with the preceding <value-of select="name()"/>.</diagnostic>
        <diagnostic id="fz_para_03_en" xml:lang="en">This <value-of select="name()"/> is probably not needed and can be removed.</diagnostic>
        <!--diagnostic id="fz_para_04_en" xml:lang="en">A QR code link must stand alone in a fz_para.</diagnostic-->
        <diagnostic id="fz_para_04_en" xml:lang="en">A QR code link must stand in a separate paragraph.</diagnostic>
        <diagnostic id="fz_para_05_en" xml:lang="en">This <value-of select="name()"/> contains an incorrect reference.</diagnostic>
        <diagnostic id="fz_para_06_en" xml:lang="en">This fz_paragraph contains an incorrect reference.</diagnostic>
        <diagnostic id="fz_para_07_en" xml:lang="en">This document contains <value-of select="name()"/>-elements.</diagnostic>
        <diagnostic id="fz_para_08_en" xml:lang="en">This Oxygen comment indicates an unfinished XML file.</diagnostic>
    </diagnostics>

    <!--subset abgeleitet aus dem pattern text (erweitert um etal als nicht zu untersuchendem Element)-->
    <pattern id="fz_text">
        <title>Allgemeine Textprüfungen</title>
        <rule context="
                *[not(name() = ('br',
                'graphic',
                'audio',
                'video',
                'col',
                'concept',
                'custom',
                'td',
                'th',
                'target',
                'etal'))]" role="Leere Elemente und Blockaden">

            <report role="warn" test="not(name() = ('link', 'personid', 'title', 'shorttitle', 'definition')) and not(@type = 'key_sonstiges') and string-length(normalize-space(.)) = 0 and not(*)" diagnostics="fz_text_01_de fz_text_01_en"/>
            <report role="error" test="text()[matches(., '▀|▁|▂|▃|▄|▅|▆|▇|█|▉|▊|▋|▌|▍|▎|▏|▐|░|▒|▓|▔|▕|▖|▗|▘|▙|▚|▛|▜|▝|▞|▟|■')]" diagnostics="fz_text_02_de fz_text_02_en"/>
            <!-- sqf funktioniert nicht <sqf:stringReplace regex="[&amp;#x7f;-&amp;#x9f;]" match="text()"></sqf:stringReplace> -->
            <report test="text()[matches(., '[^\P{Cc}\n\t]')]" diagnostics="fz_text_03_de fz_text_03_en"/>
        </rule>
    </pattern>
    <diagnostics>
        <diagnostic id="fz_text_01_de" xml:lang="de">Das Element <value-of select="name()"/> ist leer</diagnostic>
        <diagnostic id="fz_text_02_de" xml:lang="de">Die Blockade in <value-of select="name()"/> muss aufgelöst werden.</diagnostic>
        <diagnostic id="fz_text_03_de" xml:lang="de">Aus <value-of select="name()"/> müssen ungültige Zeichen entfernt oder ersetzt werden: <value-of select="replace(., '[\P{Cc}\n\t]', '')"/>.</diagnostic>

        <!-- EN -->
        <diagnostic id="fz_text_01_en" xml:lang="en">The element <value-of select="name()"/> is empty.</diagnostic>
        <diagnostic id="fz_text_02_en" xml:lang="en">The black square in <value-of select="name()"/> must be resolved.</diagnostic>
        <diagnostic id="fz_text_03_en" xml:lang="en">Invalid characters must be removed or replaced from <value-of select="name()"/>: <value-of select="replace(., '[\P{Cc}\n\t]', '')"/>.</diagnostic>
    </diagnostics>

    <pattern id="litref">
        <title>Literaturreferenzen</title>
        <rule context="//litref//date">
            <assert test="text()[matches(., '^\d{4}-\d{2}-\d{2}$')] | text()[matches(., '^\d{4}$')]" role="error" diagnostics="litref_01_de litref_01_en"/>
        </rule>
        <rule context="//litref//name[@type = ('author', 'editor')]">
            <assert test="child::firstname" role="error" diagnostics="litref_02_de litref_02_en"/>
        </rule>
    </pattern>
    <diagnostics>
        <diagnostic id="litref_01_de" xml:lang="de">Bitte strukturieren Sie das Datum im Format JJJJ-MM-TT oder JJJJ. Die Angabe von weiteren Zeichen führt in Schema zu Fehlern.</diagnostic>
        <diagnostic id="litref_02_de" xml:lang="de">Der Inhalt des Elements <value-of select="name()"/> ist unvollständig. Bitte ergänzen Sie "firstname", mit dem Initial/den Initialen des Vornamens.</diagnostic>
        <!-- EN -->
        <diagnostic id="litref_01_en" xml:lang="en">Please structure the date in the format YYYY-MM-DD or YYYY. Deviations from this format will lead to errors in Schema.</diagnostic>
        <diagnostic id="litref_02_en" xml:lang="en">The content of element <value-of select="name()"/> is incomplete. Please add "firstname" containing the initial/the initials of the first name.</diagnostic>
    </diagnostics>

    <pattern id="doubledDivisIndex">
        <title>Doppelter Divis</title>
        <rule context="indexentry/descendant::*">
            <report role="error" test="text()[matches(., '--')]" diagnostics="doubledDivisIndex_01_de doubledDivisIndex_01_en"/>
        </rule>
    </pattern>
    <diagnostics>
        <diagnostic id="doubledDivisIndex_01_de" xml:lang="de">Doppelte Divis in Indexeinträgen.</diagnostic>
        <!-- EN -->
        <diagnostic id="doubledDivisIndex_01_en" xml:lang="en">Double divis in index entries.</diagnostic>
    </diagnostics>

    <pattern id="fz_abstract">
        <title>Abstract Journals</title>
        <rule context="abstract | abstracttranslated">
            <report role="error" test="." diagnostics="fz_abstract_01_de fz_abstract_01_en"/>
        </rule>
    </pattern>
    <diagnostics>
        <diagnostic id="fz_abstract_01_de" xml:lang="de">Abstracts bitte mit &lt;section type="abstract"&gt; oder &lt;section type="abstracttranslated"&gt; strukturieren und nicht mit &lt;abstract&gt; oder &lt;abstracttranslated&gt;. Abstracts in TReX strukturieren und neues KIS-XML erzeugen oder in KIS-XML korrigieren.</diagnostic>
        <!-- EN -->
        <diagnostic id="fz_abstract_01_en" xml:lang="en">Please mark up abstracts with &lt;section type="abstract"&gt; or &lt;section type="abstracttranslated"&gt; and not with &lt;abstract&gt; or &lt;abstracttranslated&gt;. Structure abstracts in TReX and create new KIS-XML or correct in KIS-XML.</diagnostic>
    </diagnostics>

    <pattern id="fz_jnref">
        <title>fpage und doi in jnref</title>
        <rule context="jnref">
            <assert role="error" test="(descendant::fpage and descendant::lpage) or descendant::id[@type = 'doi']" diagnostics="fz_jnref_01_de fz_jnref_01_en"/>
        </rule>
    </pattern>
    <diagnostics>
        <diagnostic id="fz_jnref_01_de" xml:lang="de">Mindestens fpage und lpage oder id type="doi" muss in jnref angegeben werden.</diagnostic>
        <!-- EN -->
        <diagnostic id="fz_jnref_01_en" xml:lang="en">At least fpage and lpage or id type="doi" has to be present in the element jnref.</diagnostic>
    </diagnostics>

    <pattern id="language">
        <title>Sprach- und Länderangaben</title>
        <rule context="language | metadata[@type = 'language'] | @language">
            <assert
                test="matches(., '^((aa|ab|af|ak|sq|am|ar|an|hy|as|av|ae|ay|az|ba|bm|eu|be|bn|bh|bi|bs|br|bg|my|ca|ch|ce|zh|cu|cv|kw|co|cr|cs|da|dv|nl|dz|en|eo|et|ee|fo|fj|fi|fr|fy|ff|ka|de|gd|ga|gl|gv|el|gn|gu|ht|ha|he|hz|hi|ho|hr|hu|ig|is|io|ii|iu|ie|ia|id|ik|it|jv|ja|kl|kn|ks|kr|kk|km|ki|rw|ky|kv|kg|ko|kj|ku|lo|la|lv|li|ln|lt|lb|lu|lg|mk|mh|ml|mi|mr|ms|mg|mt|mn|na|nv|nr|nd|ng|ne|nn|nb|no|ny|oc|oj|or|om|os|pa|fa|pi|pl|pt|ps|qu|rm|ro|rn|ru|sg|sa|si|sk|sl|se|sm|sn|sd|so|st|es|sc|sr|ss|su|sw|sv|ty|ta|tt|te|tg|tl|th|bo|ti|to|tn|ts|tk|tr|tw|ug|uk|ur|uz|ve|vi|vo|cy|wa|wo|xh|yi|yo|za|zu)-(AD|AE|AF|AG|AI|AL|AM|AO|AQ|AR|AS|AT|AU|AW|AX|AZ|BA|BB|BD|BE|BF|BG|BH|BI|BJ|BL|BM|BN|BO|BQ|BR|BS|BT|BV|BW|BY|BZ|CA|CC|CD|CF|CG|CH|CI|CK|CL|CM|CN|CO|CR|CU|CV|CW|CX|CY|CZ|DE|DJ|DK|DM|DO|DZ|EC|EE|EG|EH|ER|ES|ET|FI|FJ|FK|FM|FO|FR|GA|GB|GD|GE|GF|GG|GH|GI|GL|GM|GN|GP|GQ|GR|GS|GT|GU|GW|GY|HK|HM|HN|HR|HT|HU|ID|IE|IL|IM|IN|IO|IQ|IR|IS|IT|JE|JM|JO|JP|KE|KG|KH|KI|KM|KN|KP|KR|KW|KY|KZ|LA|LB|LC|LI|LK|LR|LS|LT|LU|LV|LY|MA|MC|MD|ME|MF|MG|MH|MK|ML|MM|MN|MO|MP|MQ|MR|MS|MT|MU|MV|MW|MX|MY|MZ|NA|NC|NE|NF|NG|NI|NL|NO|NP|NR|NU|NZ|OM|PA|PE|PF|PG|PH|PK|PL|PM|PN|PR|PS|PT|PW|PY|QA|RE|RO|RS|RU|RW|SA|SB|SC|SD|SE|SG|SH|SI|SJ|SK|SL|SM|SN|SO|SR|SS|ST|SV|SX|SY|SZ|TC|TD|TF|TG|TH|TJ|TK|TL|TM|TN|TO|TR|TT|TV|TW|TZ|UA|UG|UM|US|UY|UZ|VA|VC|VE|VG|VI|VN|VU|WF|WS|YE|YT|ZA|ZM|ZW))$')"
                role="error" diagnostics="language_01_de language_01_en"/>
        </rule>
    </pattern>
    <diagnostics>
        <diagnostic id="language_01_de" xml:lang="de">Die Angabe der Sprache muss im Format "Sprachcode-Ländercode" erfolgen, bspw. en-US. Alle Werte der Normen ISO 639-1 (Sprachcodes) sowie ISO 3166 Alpha-2 (Ländercodes) sind zugelassen.</diagnostic>
        <!-- EN -->
        <diagnostic id="language_01_en" xml:lang="en">The language must be specified in the format 'language code-country code', e.g. 'en-US'. All values of the standards ISO 639.1 (language codes) and ISO 3166 alpha-2 (country codes) are permitted.</diagnostic>
    </diagnostics>

    <pattern id="fz_keywords">
        <title>Keywords</title>
        <rule context="//metadata[contains(@type, 'keyword')]">
            <let name="firstLanguage" value="//metadata[contains(@type, 'keyword')][1]/@type"/>
            <let name="keywordsFirstLanguage" value="count(//metadata[@type = $firstLanguage])"/>
            <let name="keywordsTotal" value="count(//metadata[contains(@type, 'keyword')])"/>
            <report test="(following-sibling::metadata[@type = 'bilingual-text'] | preceding-sibling::metadata[@type = 'bilingual-text']) and ($keywordsFirstLanguage = $keywordsTotal)" role="warning" diagnostics="fz_keywords_01_de fz_keywords_01_en"/>
        </rule>
        <rule context="metadata[not(contains(@type, 'keyword'))]">
            <report role="error" test="child::sub or child::sup or child::emph" diagnostics="fz_keywords_02_de fz_keywords_02_en"/>
        </rule>
    </pattern>
    <diagnostics>
        <diagnostic id="fz_keywords_01_de" xml:lang="de">Bitte prüfen Sie die Spracheinstellungen der Keywords, da diese nur in einer Sprache enthalten sind und korrigieren Sie ggf. in censhare</diagnostic>
        <diagnostic id="fz_keywords_02_de" xml:lang="de"><value-of select="child::*/name()"/> ist nur in metadata type="keyword-de" und type="keyword-en" erlaubt.</diagnostic>
        <!-- EN -->
        <diagnostic id="fz_keywords_01_en" xml:lang="en">Please check the language settings of the keywords since they are only included in one language and correct in censhare if necessary</diagnostic>
        <diagnostic id="fz_keywords_02_en" xml:lang="en"><value-of select="child::*/name()"/> is only allowed in metadata type="keyword-de" and type="keyword-en".</diagnostic>
    </diagnostics>

    <pattern id="fz_container">
        <title>Sonderumgebungen</title>
        <rule context="box" role="Fehlerhafte Boxen">
            <report role="error" test="@type = ('profile', 'symptome', 'technique', 'pitfall', 'other')" diagnostics="fz_container_01_de fz_container_01_en"/>
        </rule>
    </pattern>

    <diagnostics>
        <diagnostic id="fz_container_01_de" xml:lang="de">Dieser Boxtyp ist für Journals nicht erlaubt und führt bei der Konvertierung nach PDF zu Fehlern, bitte korrigieren.</diagnostic>
        <!-- EN -->
        <diagnostic id="fz_container_01_en" xml:lang="en">This box type is not allowed for journals and leads to errors in XML2PDF conversion, please correct.</diagnostic>
    </diagnostics>
    <pattern id="fz_title">
        <title>Titelangaben</title>
        <rule context="titletranslated">
            <report role="error" test="matches(./text(), '^NOTSET$')" diagnostics="fz_title_01_de fz_title_01_en"/>
        </rule>
    </pattern>
    <diagnostics>
        <diagnostic id="fz_title_01_de" xml:lang="de">Dieser übersetzte Titel ist leer. Bitte korrigieren Sie die Metadaten am Artikel-Asset in censhare.</diagnostic>
        <!-- EN -->
        <diagnostic id="fz_title_01_en" xml:lang="en">This translated title is empty. Please correct the metadata of the article-asset in censhare.</diagnostic>
    </diagnostics>

    <pattern id="fz_metadata">
        <title>FZ Metadaten</title>
        <rule context="metadata[@type = 'fundinginstitutionid']">
            <assert test="matches(., '^10.13039(.){1,}')" diagnostics="fz_metadata_01_de fz_metadata_01_en"/>
        </rule>

    </pattern>
    <diagnostics>
        <diagnostic id="fz_metadata_01_de" xml:lang="de">Der DOI muss mit dem Präfix 10.13039 beginnen.</diagnostic>
        <!-- EN -->
        <diagnostic id="fz_metadata_01_en" xml:lang="en">The DOI must begin with the prefix 10.13039.</diagnostic>
    </diagnostics>

    <pattern id="qblock">
        <title>Prüfungsfragen</title>
        <rule context="(figure | table)">
            <report test="(preceding-sibling::qblock | following-sibling::qblock)" role="error" diagnostics="qblock_01_de qblock_01_en"/>
        </rule>
    </pattern>
    <diagnostics>
        <diagnostic id="qblock_01_de" xml:lang="de">Das Element <value-of select="name()"/> muss innerhalb von Frage, Antwort, Kommentar angelegt sein.</diagnostic>
        <!-- EN -->
        <diagnostic id="qblock_01_en" xml:lang="en">The element <value-of select="name()"/> must be placed in the question, answer, comment.</diagnostic>
    </diagnostics>

    <pattern id="sectionLiterature">
        <title>Literatur-Section</title>
        <rule context="section">
            <report test="child::literature and not(@type = 'literature')" role="warn" diagnostics="sectionLiterature_01_de sectionLiterature_01_en"/>
        </rule>
    </pattern>
    <diagnostics>
        <diagnostic id="sectionLiterature_01_de" xml:lang="de">Die section, in der die Literaturreferenzen enthalten sind, ist nicht vom type="literature".</diagnostic>
        <!-- EN -->
        <diagnostic id="sectionLiterature_01_en" xml:lang="en">The section containing the literature references is not of the type="literature".</diagnostic>
    </diagnostics>

    <pattern id="mmlTex">
        <title>TeX-Transformation</title>
        <rule context="formula[@type = 'math']">
            <report test="not(descendant::m:annotation)" role="error" diagnostics="mmlTex_01_de mmlTex_01_en"/>
        </rule>
    </pattern>
    <diagnostics>
        <diagnostic id="mmlTex_01_de" xml:lang="de">TeX-Transformation wurde nicht ausgeführt</diagnostic>
        <!-- EN -->
        <diagnostic id="mmlTex_01_en" xml:lang="en">TeX transformation has not been executed</diagnostic>
    </diagnostics>
    
    <pattern id="accessibility">
        <title>Barrierefreiheit</title>
        <rule context="graphic[parent::subfigure | parent::personpicture]">
            <assert test="./@alt" role="warn" diagnostics="accessibility_01_de accessibility_01_en"/>
            <report test="(./@alt) and (string-length(./@alt)=0)" role="warn" diagnostics="accessibility_02_de accessibility_02_en"/>
         </rule>
    </pattern>
    <diagnostics>
        <diagnostic id="accessibility_01_de" xml:lang="de">Die (Teil-)Abbildung enthält keinen Alternativtext, bitte prüfen und ggf. ergänzen.</diagnostic>
        <diagnostic id="accessibility_02_de" xml:lang="de">Der Alternativtext ist gesetzt, aber leer. Das unterstellt eine inhaltlich nicht relevante Schmuckabbildung. Bitte ggf. prüfen.</diagnostic>
        <!-- EN -->
        <diagnostic id="accessibility_01_en" xml:lang="en">The figure does not contain an alternative text, please check and add if necessary.</diagnostic>    
        <diagnostic id="accessibility_02_en" xml:lang="en">The alternative text is set, but empty. Please check if this is a decorative image.</diagnostic>
         </diagnostics>

</schema>
