<!-- 
   Modul für die Erfassung von Metainformationen
   Copyright (c) 2007-2019 Georg Thieme Verlag KG, Stuttgart
 -->

<!--doc: Klammert alle Metainformationen-->
<!--~~ <meta>
<p lang="de">Klammert alle Metainformationen</p>
<p lang="en">Brackets all meta information</p>
~~-->
<!ELEMENT meta ( categories | collaborator | contributors | custom | docalttitle | docdate | doctitle |  docsubtitle | doi | fignumber | isbn | issn | keywords | language | materialid |
				metadata | moduleid | note | publisher | relatedobjects | series | subseries | source | version | volume | xi:include)* >
<!ATTLIST meta 
		xml:base CDATA #IMPLIED >

<!ELEMENT metadata (#PCDATA | metadata)*>
<!ATTLIST metadata
    type  CDATA     #IMPLIED        
    value CDATA     #IMPLIED
    medilearn CDATA #IMPLIED
    project (radbase | enes | exon | surgerybase | vetcenter) #IMPLIED 
>

<!--Idee für zukünftiges Modell-->
<!--<!ELEMENT metadata (#PCDATA | metadata)*>
<!ATTLIST metadata
type CDATA #REQUIRED
value CDATA #IMPLIED
%lang.attrib;
>-->

<!---doc: Generisches Metadatenelement -->
<!ELEMENT custom EMPTY >
<!ATTLIST custom
   name CDATA  #REQUIRED 
   type    (numbering | searchlevel | searchterm) #IMPLIED
   project (RadBase | eNes | Walle | Exon | DuR | VetCenter | surgerybase) #IMPLIED 
   value   CDATA  #REQUIRED 
>

<!--doc: DOI (Digital Object Identifier) -->
<!--~~ <doi>
<p lang="de">DOI (Digital Object Identifier)</p>
<p lang="en">DOI (Digital Object Identifier)</p>
~~-->
<!ELEMENT doi (#PCDATA)>


<!-- doc: Materialnummer des Werkes aus SAP-->
<!--~~ <materialid>
<p lang="de">Materialnummer des Werkes aus SAP</p>
<p lang="en">Material ID of the document from SAP-System</p>
~~-->
<!ELEMENT materialid (#PCDATA)>


<!-- doc: weitere ID -->
<!--~~ <moduleid>
<p lang="de">weitere ID</p>
<p lang="en">further ID</p>

~~-->
<!ELEMENT moduleid (#PCDATA)>


<!-- doc: Sprache des Dokumentes -->
<!--~~ <language> 
<p lang="de">Sprache des Dokumentes</p>
<p lang="en">Document language</p>

~~-->
<!ELEMENT language (#PCDATA)>


<!-- doc: Klammert die Kategorie -->
<!--~~ <categories>
<p lang="de">Klammert die Kategorie</p>
<p lang="en">Brackets different categories</p>
~~-->
<!ELEMENT categories (category+) >


<!-- doc: Kategorie -->
<!--~~ <category> 
<p lang="de">Fachgebietkategorie</p>
<p lang="en">Branches: category</p>
~~-->
<!ELEMENT category (#PCDATA)>
<!ATTLIST category
medicalbranch (ains | anatomy | audiology | communicationalsciences | dentistry | dermatology | gynecologyandobstetrics | internalmedicine | logopedics | neurology | neurosurgery| nursing| occupationaltherapy | ophthalmology | orthopedicsandtraumasurgery |
otolaryngology | pediatrics | physiotherapy | plasticsurgery | psychiatryandpsychotherapy | radiology | rescueservice| surgery | urology | varia) #IMPLIED>


<!-- doc: Klammert die Schlagwörter -->
<!--~~ <keywords>
<p lang="de">Klammert die Schlagwörter</p>
<p lang="en">Brackets the keywords</p>
~~-->
<!ELEMENT keywords (keyword+)>


<!-- doc: Schlagwort -->
<!--~~ <keyword>
<p lang="de">Einzelnes Schlagwort</p>
<p lang="en">Single keyword</p>
~~-->
<!ELEMENT keyword (#PCDATA)>
<!ATTLIST keyword 
		  %lang.attrib;>
		 

<!-- doc: Erscheinungsdatum, Auslieferungsdatum aus VIS<br/>
Format: YYYY-MM-DD -->
<!--~~ <docdate>
<p lang="de">Erscheinungsdatum, Auslieferungsdatum aus VIS<br/>
Format: YYYY-MM-DD</p>
<p lang="en">Date of document, date of delivery from VIS-System<br/>
Format: YYYY-MM-DD
</p>
~~-->
<!ELEMENT docdate (#PCDATA)>
<!ATTLIST docdate
		  type (created | modified | released ) #REQUIRED
>


<!-- doc: Auflage eines Buches -->
<!--~~ <version>
<p lang="de">Auflage eines Buches</p>
<p lang="en">Edition of the book</p>

~~-->
<!ELEMENT version (#PCDATA)>
<!ATTLIST version
          type (online | print) #REQUIRED
>

<!-- doc: Kennzeichnet eine Buchreihe-->
<!--~~ <series>
<p lang="de">Kennzeichnet eine Buchreihe.</p>
<p lang="en">Series, comprising title of series and serial number</p>
~~-->
<!ELEMENT series (#PCDATA)>


<!-- doc: DEPRECATED. Untergeordneter Reihentitel-->
<!--~~ <subseries>
<p lang="de">DEPRECATED. Untergeordneter Reihentitel</p>
<p lang="en">DEPRECATED. Name of a book’s sub collection.</p>
~~-->
<!ELEMENT subseries (#PCDATA)>

<!-- doc: Die ISBN eines Buches-->
<!--~~ <isbn>
<p lang="de">Die ISBN eines Buches.</p>
<p lang="en">ISBN of a book.</p>

~~ type
<p lang="de">
print = ISBN für gedrucktes Buch;
epub = ISBN für E-Books im EPUB-Format;
epdf = ISBN für E-Books im PDF-Format;
online = HTML und PDF-Version;
restofworld = ISBN außerhalb Amerikas</p>
<p lang="en">
print = ISBN for a printed book;
epub = ISBN for an e-Book in ePUB-format;
epdf = ISBN for e-Books in PDF-format;
online = HTML and PDF-Version;
restofworld = ISBN beyond America</p>
~~-->
<!ELEMENT isbn (#PCDATA)>
<!ATTLIST isbn
		  type (print | epub | epdf | online | restofworld) #IMPLIED
>
		  
<!-- doc: Die ISSN einer Zeitschrift-->		  
<!--~~ <issn>
<p lang="de">Die ISSN einer Zeitschrift.</p>
<p lang="en">Optional specification of ISSN for journals.</p>
~~-->
<!ELEMENT issn (#PCDATA)>
<!ATTLIST issn
          type (print | e-issn) #IMPLIED >

<!-- doc: Jahrgang einer Zeitschrift oder Bandnummer eines Buches-->
<!--~~ <volume>
<p lang="de">Jahrgang einer Zeitschrift oder Bandnummer eines Buches.</p>
<p lang="en">Volume number of journal/book.</p>
~~-->
<!ELEMENT volume (#PCDATA)>


<!-- doc: Buchtitel -->
<!--~~ <doctitle>
<p lang="de">Buchtitel</p>
<p lang="en">Book title</p>
~~-->
<!ELEMENT doctitle (#PCDATA)>


<!-- doc: Untertitel eines Buches -->
<!--~~ <docsubtitle>
<p lang="de">Untertitel eines Buches</p>
<p lang="en">Book subtitle</p>
~~-->
<!ELEMENT docsubtitle (#PCDATA)>


<!-- doc: Alternativer Titel, z. B. für elektronische Medien-->
<!--~~ <docalttitle>
<p lang="de">Alternativer Titel, z. B. für elektronische Medien</p>
<p lang="en">Alternative title, e.g. for electronic media</p>
~~-->
<!ELEMENT docalttitle (#PCDATA)>


<!-- doc: Titel und Copyright des Ursprungswerkes bei Übersetzungen-->
<!--~~ <source>
<p lang="de">Titel und Copyright des Ursprungswerkes bei Übersetzungen</p>
<p lang="en">Copyright and title of the original document; especially for translations</p>
~~-->
<!ELEMENT source (sourcedoctitle, copyright)>


<!-- doc: Titel des Ursprungswerkes -->
<!--~~ <sourcedoctitle>
<p lang="de">Titel des Ursprungswerkes</p>
<p lang="en">Title of the original document</p>
~~-->
<!ELEMENT sourcedoctitle (#PCDATA)>


<!-- doc: Anzahl der Abbildungen-->
<!--~~ <fignumber>
<p lang="de">Anzahl der Abbildungen.</p>
<p lang="en">Number of figures.</p>
~~-->
<!ELEMENT fignumber (#PCDATA)>


<!-- doc: Verlagsadresse-->
<!--~~ <publisher>
<p lang="de">Klammert Infos über den Verlag (Name, Verlagsadresse, Copyright und URI)</p>
<p lang="en">Brackets info about the publisher (publishername, copyright, adress, uri)</p>
~~-->
<!ELEMENT publisher (publishername, copyright, address?, uri*)>


<!-- doc: Verlagsname -->
<!--~~ <publishername>
<p lang="de">Verlagsname</p>
<p lang="en">Name of publisher</p>
~~-->
<!ELEMENT publishername (#PCDATA)>


<!-- doc: Copyrightjahr und Verlagsname im Impressum-->
<!--~~ <copyright>
<p lang="de">Copyrightjahr und Verlagsname im Impressum</p>
<p lang="en">Copyright notice (year and publisher name) in the impressum</p>
~~-->
<!ELEMENT copyright (#PCDATA)>


<!-- doc: Klammert alle Adresszeilen -->
<!--~~ <address>
<p lang="de">Klammert alle Adresszeilen. Die Straße ist seit 2017/11 optional, da es durchaus Adressen ohne Straße gibt (meist Universitäten).</p>
<p lang="en">Brackets all information about the address</p>
~~-->
<!ELEMENT address (street?, additional?, zip, city, state?, country?)>


<!-- doc: Straße und Hausnummer -->
<!--~~ <street>
<p lang="de">Straße und Hausnummer</p>
<p lang="en">Street and number</p>
~~-->
<!ELEMENT street (#PCDATA)>


<!-- doc: Adresszusatz; mehrere möglich. -->
<!--~~ <additional>
<p lang="de">Adresszusatz; mehrere möglich.</p>
<p lang="en">Additional information for adress; serveral are possible.</p>
~~-->
<!ELEMENT additional (#PCDATA)>


<!-- doc: Postleitzahl -->
<!--~~ <zip>
<p lang="de">Postleitzahl</p>
<p lang="en">Zip code</p>
~~-->
<!ELEMENT zip (#PCDATA)>


<!-- doc: Stadt -->
<!--~~ <city>
<p lang="de">Stadt</p>
<p lang="en">City</p>
~~-->
<!ELEMENT city (#PCDATA)>


<!-- doc: Bundesstaat -->
<!--~~ <state>
<p lang="de">Bundesstaat</p>
<p lang="en">Federal state</p>
~~-->
<!ELEMENT state (#PCDATA)>


<!-- doc: Land-->
<!--~~ <country>
<p lang="de">Land</p>
<p lang="en">Country</p>
~~-->
<!ELEMENT country (#PCDATA)>


<!-- doc: Klammert alle Herausgeber und Autoren
Beitragende können eine Körperschaft und eine Person sein oder eine Kombination -->
<!--~~ <contributors>
<p lang="de">Klammert alle Herausgeber und Autoren
Beitragende können eine Körperschaft, eine Person oder eine Kombination sein.</p>
<p lang="en">Brackets all editors and authors
Contributors could be a corporation, a person or any combination.</p>
~~-->
<!ELEMENT contributors (corporation | person)* >


<!-- doc: Kennzeichnet eine Körperschaft als Herausgeber oder Autor. -->
<!--~~ <corporation>
<p lang="de">Kennzeichnet eine Körperschaft als Herausgeber oder Autor.</p>
<p lang="en">Indicates a corporation as editor or author.</p>
~~-->
<!ELEMENT corporation (organisation, address?, uri?) >
<!ATTLIST corporation
		  type ( author | editor ) #REQUIRED >


<!-- doc: Klammert alle Infos zu einer Person (Herausgeber, Autor)
Das Attribut @priority steuert die Reihenfolge der Personen, stellt wichtige Personen an den Anfang. Ansonsten ist die Sortierreihenfolge gleich der im XML. -->
<!--~~ <person>
<p lang="de">Klammert alle Infos zu einer Person (Herausgeber, Autor)
Das Attribut @priority steuert die Reihenfolge der Personen, stellt wichtige Personen an den Anfang. Ansonsten ist die Sortierreihenfolge gleich der im XML.</p>
<p lang="en">Brackets all information about a person (editor, author)
The attribute @priority controlls the order of persons, if its not alphabethical. In other respects the order is the same as mentioned in the XML file.
</p>

~~ priority
<p lang="de">Das Attribut @priority steuert die Reihenfolge der Personen, stellt wichtige Personen an den Anfang. Ansonsten ist die Sortierreihenfolge gleich der im XML.</p>
<p lang="en">The attribute @priority controlls the order of persons, if its not alphabethical. In other respects the order is the same as mentioned in the XML file.
</p>

~~-->
<!ELEMENT person (persontitle?, initials?, firstname?, lastname, suffix?, personid*, role*, organisation?, address?, uri*, personpicture?, vita?)>
<!ATTLIST person
		  type ( author | editor | serieseditor ) #REQUIRED
		  priority CDATA #IMPLIED
>


<!-- doc: Akademische Grade, Berufs- bzw. Ehrentitel-->
<!--~~ <persontitle>
<p lang="de">Akademische Grade, Berufs- bzw. Ehrentitel</p>
<p lang="en">Academic, job or honorary title</p>
~~-->
<!ELEMENT persontitle (#PCDATA)>

<!-- doc: Abgekürzte(r) Vorname(n) -->
<!--~~ <initials>
<p lang="de">Abgekürzte(r) Vorname(n)</p>
<p lang="en">Shortened first name(s)</p>
~~-->
<!ELEMENT initials (#PCDATA)>
<!-- doc: Vorname(n) der Person-->
<!--~~ <firstname>
<p lang="de">Vorname(n) der Person</p>
<p lang="en">First name of a person</p>
~~-->
<!ELEMENT firstname (#PCDATA)>

<!-- doc: Nachname(n) der Person-->
<!--~~ <lastname>
<p lang="de">Nachname(n) der Person</p>
<p lang="en">Surname of a person</p>
~~-->
<!ELEMENT lastname (#PCDATA)>

<!-- doc: Sämtliche Namenszusätze wie "Jr.", "2nd" oder akademische Titel-->
<!--~~ <suffix>
<p lang="de">Sämtliche Namenszusätze wie "Jr.", "2nd" oder akademische Titel.</p>
<p lang="en">Suffix for persons like "Jr.", "2nd" or an academic title.</p>
~~-->
<!ELEMENT suffix (#PCDATA)>

<!-- doc: Titel der referenzierte Publikation (Artikel, Kapitel oder Buch)-->
<!--~~ <reftitle>
<p lang="de">Titel der referenzierte Publikation (Artikel, Kapitel oder Buch).</p>
<p lang="en">Title of the referenced publication (article, chapter or book).</p>
~~-->

<!ELEMENT personids (personid+) >


<!-- doc: Geschäftspartnernummer (GPN) ist Standard. Andere IDs werden bisher nicht verwendet.-->
<!--~~ <personid>
<p lang="de">Geschäftspartnernummer (GPN) ist Standard. Andere IDs werden bisher nicht verwendet.</p>
<p lang="en">Business partner number (gpn) from SAP is the standard.
Further authors IDs are possible.</p>
~~-->
<!ELEMENT personid (#PCDATA)>
<!ATTLIST personid
	type (gpn | orcid | isni | viaf) #IMPLIED >


<!-- doc: Funktion der Person in einem bestimmten Kontext.-->
<!--~~ <role>
<p lang="de">Funktion der Person in einem bestimmten Kontext.</p>
<p lang="en">A person’s role in a specified context.</p>
~~-->
<!ELEMENT role (#PCDATA)>


<!-- doc: Klammert alle Infos zu einer Organisation/Unternehmen. -->
<!--~~ <organisation>
<p lang="de">Klammert alle Infos zu einer Organisation/Unternehmen.</p>
<p lang="en">Brackets all information about an organization</p>
~~-->
<!ELEMENT organisation (organame, additional*)>


<!-- doc: Name der Organisation/des Unternehmens-->
<!--~~ <organame>
<p lang="de">Name der Organisation/des Unternehmens</p>
<p lang="en">Name of the organization/company</p>
~~-->
<!ELEMENT organame (#PCDATA)>
<!ELEMENT personpicture (graphic)>


<!-- doc: Lebenslauf/Kurzbiografie einer Person.-->
<!--~~ <vita>
<p lang="de">Lebenslauf/Kurzbiografie einer Person.</p>
<p lang="en">Curriculum Vitae of a person</p>
~~-->
<!ELEMENT vita (para+, listing?)>


<!-- doc: Wird für verschiedene Textinformationen im Impressum genutzt.-->
<!--~~ <note>
<p lang="de">Wird für verschiedene Textinformationen im Impressum genutzt.</p>
<p lang="en">Used for various text information in the impressum.</p>

~~ type
<p lang="de">abstract = Inhaltliche Zusammenfassung; addmaterial = Hinweise auf Zusatzmaterial; cip = Bibliografische Information der Deutschen Nationalbiliothek;
cooperation = Eventuelle Kooperationspartner; copyright = Urheberrechtsschutz; disclaimer = Haftungsausschluss von Personen; ereader = Lesegeräthinweis;
feedback = Leserfeedback; formeredition = Auflagenhistorie; important = wichtiger Hinweis; original = TRIAS Original; paper = Art des Papieres;
parties = namentlich genannte Beteiligte; printedin = Hinweis zum Druckort; service = Leserservice, z. B. Newsletter; termsofuse = Nutzungsbedingungen;
trademark = Geschützte Warennamen</p>
<p lang="en">abstract = summary of the book content; addmaterial = Note for additional material; cip = Cataloging in Publication Data of the German National Library;
cooperation = Partner of cooperation; copyright = Copyright; disclaimer = note disclaimer, e.g. of persons; ereader = E-reader note Readers;
feedback = feedback; formeredition = Former editions; important = Important note; original = TRIAS Original; paper = Papergrade;
parties = Named parties/collaborators; printedin = Information where the document was printed; service = Readers service, e.g. newsletter; termsofuse = Terms of use;
trademark = Trademark</p>
~~-->
<!ELEMENT note (para+)>
<!ATTLIST note
		  type (abstract | addmaterial | cip | cooperation | copyright | disclaimer | ereader | feedback | formeredition | important | original | paper | parties | printedin | service | termsofuse | trademark) #REQUIRED
		  xml:base CDATA #IMPLIED >


<!-- doc: Im Impressum erscheinende weitere Dienstleister-->
<!--~~ <collaborator>
<p lang="de">Im Impressum erscheinende, weitere Dienstleister</p>
<p lang="en">Other collaborators displayed on the imprint page</p>
~~-->
<!ELEMENT collaborator  (#PCDATA)>
<!ATTLIST collaborator
          type ( consultant | copyediting | design | graphic | origination | photography | printing | programming | stylesheet | translation | typesetting) #REQUIRED>


<!-- doc: Werden von der CLS automatisch angelegt. -->
<!--~~ <relatedobjects>
<p lang="de">Werden von der CLS automatisch angelegt.</p>
<p lang="en">Automatically insert by the CLS</p>
~~-->
<!ELEMENT relatedobjects (relpdfio*, relfigureio*)>


<!-- doc: Verweis auf eine Abbildungs-IO in der CLS.-->
<!--~~ <relfigureio>
<p lang="de">Verweis auf eine Abbildungs-IO in der CLS.</p>
<p lang="en">Reference to a Figure Information Object in the CLS.</p>
~~-->
<!ELEMENT relfigureio (#PCDATA) >
<!ATTLIST relfigureio
   fileref CDATA  #IMPLIED 
   %id.attrib;
>


<!-- doc: Verweis auf eine PDF-IO in der CLS. -->
<!--~~ <relpdfio>
<p lang="de">Verweis auf eine PDF-IO in der CLS.</p>
<p lang="en">Reference to a PDF Information Object in the CLS. </p>
~~-->
<!ELEMENT relpdfio (#PCDATA) >
<!ATTLIST relpdfio
   fileref CDATA  #IMPLIED 
   %id.attrib;
>
