<?xml version="1.0" encoding="UTF-8"?>
<!-- 
  Schematron als Ergänzung zur KIS DTD
  Patrick Schwarz, (c) Georg Thieme Verlag KG Stuttgart
  Changelog:
    v0.1 initial release, ps, 15.03.2012
    v1.0, aufgeräumt, Prüfung im Images- und Rootordner, Check für alte Boxtypen und leere Elemente
    v1.1, 24.08.12 Dateipfad für Abbildungsprüfung umgestellt, da nicht mehr funktionsfähig
    v1.2, 29.11.12 Links ohne id aufzählen; Prüfung Datumsangaben, ISBN-Nummer, Materialnummer; URL-Filter gegen Schematron-Abbruch bei Sonderzeichen (Abb.)
    v1.3, 14.12.12 Neues Metadatenmodell ergänzt
    v1.4, 07.01.13 Warnungen und Fehler korrigiert
    v1.5, 04.02.13 Formulierung, empty Element Prüfung korrigiert
    v1.6, 25.02.13 Prüfregeln für Tabellen, externe Links, x-Level, leere Dateinamen in Abbildungen, Section-Titellänge
    v1.7, 20.03.13 Prüfung nach mehrfach gesetzten meta-Elementen, Prüfung nach unnötigen emphs
    v1.8, 11.04.13 Bugfix Section-Titellänge und uri-Prüfung, Deprecated-Elemente
    v1.9, 10.07.13 Keine figure,box,table in listing; para beginnt mit Leerzeichen; Absatzprüfung; Tabellenkopfzeile; Listenebenen; Sectionabsatz (Lu)
    v1.10,30.08.13 Fehlerhafte Regel zum Prüfen von überflüssigen Leerzeichen vorerst entfernt
    v1.11,09.10.13 Link mit target page muss echten Text beinhalten (si), front/backmatter-Prüfung, Blockadenprüfung (arj), col-width-Werte, indexentry-Leerzeichen, kein Link im title (arj), uri als Fehler, Prüfung auf doppelte personid-Werte (arj)
    v1.12,04.06.14 Part-Prüfungen erweitert, notInFont-Info (si), keine Umlaute in IDs (si), keine Links auf Abbildungen ohne Legende (si)
    v1.13,27.06.14 Abb ohne Legende: Nur Warnung, Probleme bei Anwendung der Link-Regeln behoben, Versionsbezeichnung entfernt, Alte Boxen: Fehler (arj)
    v1.14,31.07.14 Kommentare als Hinweis anzeigen (Lu); Prüfung von leeren Elementen auf Elemente eingegrenzt, col/rowspan-Überprüfung neu geschrieben (md), alte Metaprüfungen entfernt
    v1.15,22.08.14 a/v-@id-Prüfung (arj), Nur Warnung bei mehrfach verwendeten Meta-Elementen (Lu)
    v1.16,24.10.14 collaborator aus meta-Duplikatprüfung entfernt, box-H-Prüfung entfernt, deprecated-Elemente entfernt, backmatter entfernt, div. Tabellenprüfungen, div. Linkprüfungen, Section @counter/@level, @index-Info, Prüfung ob Tab/Abb verlinkt (si)
    v1.17,24.11.14 Beschreibende Titel eingefügt, Texte und Variablen angepasst (für Doku), Prüfung auf unterschiedliche Bilderordner entfernt, Bugfix: Tab/Abb-Boxprüfung, Abb-Fileprüfung deaktivieren, wenn keine Abb. verlinkt, div. error-Level angepasst, Abb.-link-Prüfung auf title erweitert, Kommentarprüfung entfernt (Lu)
    v1.18,02.03.15 Prüfung auf fehlerhafte Zitate (ps); Whitespace-Prüfung eingeschränkt, xlevel entfernt, URLs angepasst, Boxenprüfung eingeschränkt, Absatzprüfungen für Doku restrukturiert, emph-Prüfung korrigiert
    v1.19,14.04.15 Tabellenkopfprüfung korrigiert, Legendenprüfung E-Produkte (si,arj)
    v2.0, 17.04.15 SQF: Diverse Schematron Quick Fixes integriert
    v2.1, 17.06.15 Globale Quickfixes vorerst entfernt, da durch Art und Weise der Umsetzung Performanceprobleme auftreten, Prüfung auf Abbildungsduplikate in einer Figure, Fehlerbehebung Listing-Check
    v2.2, 17.07.15 Verweisprüfung in Abbildungen optimiert, Prüfung der Dateiendungen, @id-Prüfung für audio/video entfernt
    v2.3, 24.09.15 Keine Info mehr bei leeren targets, entry4-6 bewarnen, fehlende doi bewarnen
    v2.4, 10.12.15 SQFs für emph korrigiert
    v2.5, 19.02.16 Fehler in doppelt angelegten SQF-IDs behoben
    v2.6, 30.11.16 Weiteres Blockadezeichen aufgenommen (fhj), "link" aus Prüfung leerer Elemente ausgenommen (si), Sprache-Metadatum prüfen (arj), Trailer-Hinweis (si), ePub-Prüfwert von 512000 auf 400000 geändert (si), Abbildungsprüfung für censhare deaktiviert
    v2.7, 05.02.17 Fehler, wenn mehr als eine startnum
    v2.8, 21.03.17 Legenden an Abbildungen in Tabellen verboten (si), Prüfung auf verbotene Zeichen (arj), DOI-Prüfung (fhj)
    v2.9, 14.04.17 Korrektur Schreibfehler
    v2.10,20.11.17 Prüfung auf leere Attribute
    v2.11,05.02.18 Bugfix: Schematron funktioniert nicht bei XMLs mit fehlerhafter figure/video-Struktur (fhj), personid als Fehler (fhj) und leere Elemente als Warnung hochgestuft
    v2.12,01.03.18 rights wird auf 3rdparty überprüft #OXY-20
    v2.13,08.03.18 Bugfix Abbildungsprüfung: leere filerefs geben Duplikatfehler aus
    v2.14,16.03.18 Medienprüfung für censhare erweitert und Fehler in Medienprüfung beseitigt CS-P#5925175
    v2.15,23.03.18 title und shorttitle wurden doppelt auf Inhalt geprüft
    v2.16,16.04.18 Link-ID-Prüfung angepasst, damit Schematronprüfung bei doppelten IDs nicht abstürzt
    v2.17,25.04.18 Erweiterung URI-Prüfung #OXY-109 (si)
    v2.18,17.05.18 Weitere Einschränkung der URI-Prüfung (Leerzeichen verboten), da das Schematron so nicht mehr funktioniert
    v2.19,18.07.18 DOI-Prüfung auf document/meta beschränkt (Änderugn durch neues Metadatenmodell)
    v3.0,07.02.19 Änderungen aufgrund DTD-Anpassung: Prüfung auf document/section entfernt; metaInfo und anaSectio aus der Liste der deprecated Elemente entfernt
    v4.0,11.09.19 Anpassungen für via medici 
-->
<schema xmlns="http://purl.oclc.org/dsdl/schematron" see="http://wiki.l42.net/Thieme/4._Oxygen/Schematron" queryBinding="xslt2" xmlns:sqf="http://www.schematron-quickfix.com/validator/process" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <title>KIS Schematron</title>
    <ns uri="java:java.io.File" prefix="f"/>
    <ns uri="java:java.net.URI" prefix="u"/>
    <let name="idrefs" value="//link/@idref"/>
    <let name="ids" value="//@id"/>
    <let name="id_elements" value="
            ('subfigure',
            'figure',
            'table',
            'box',
            'formula',
            'para',
            'definitionitem',
            'literature',
            'paratitle1',
            'paratitle2',
            'header1',
            'header2',
            'header3',
            'subtitle',
            'section',
            'part',
            'jnref',
            'bkref',
            'chref',
            'otherref')"/>
    <let name="all_filerefs" value="count(//@fileref)"/>
    <let name="empty_filerefs" value="count(//@fileref[. = ''])"/>
    <let name="cs_filerefs" value="count(//@fileref[starts-with(., 'censhare://') and doc-available(tokenize(., '/storage')[1])])"/>
    <let name="fs_filerefs" value="count(//@fileref[not(. = '') and not(starts-with(., 'censhare://')) and f:exists(f:new(resolve-uri(replace(., '[^a-zA-Z0-9_\-\.]', ''), base-uri())))])"/>
    <!--	<let name="fs_filerefs" value="0"/>-->

    <let name="valid_filerefs" value="$fs_filerefs + $cs_filerefs"/>
    <sqf:fixes>
        <sqf:fix id="duplicates">
            <sqf:description>
                <sqf:title>Duplikate entfernen</sqf:title>
                <sqf:p>Entfernt Duplikate und behält das ausgewählte Element bei</sqf:p>
            </sqf:description>
            <sqf:delete use-when="not(@type)" match="parent::*/*[name() = current()/name() and not(generate-id() = generate-id(current()))]"/>
            <sqf:delete use-when="@type" match="parent::*/*[name() = current()/name() and not(generate-id() = generate-id(current())) and @type = current()/@type]"/>
        </sqf:fix>
        <sqf:fix id="remvalue">
            <sqf:description>
                <sqf:title>Eintrag entfernen</sqf:title>
                <sqf:p>Löscht den selektierten Knoten</sqf:p>
            </sqf:description>
            <sqf:delete/>
        </sqf:fix>
        <sqf:fix id="remelm">
            <sqf:description>
                <sqf:title>Element entfernen</sqf:title>
                <sqf:p>Löscht das Element, behält den Elementinhalt jedoch bei</sqf:p>
            </sqf:description>
            <sqf:replace><sqf:keep select="child::node()"/></sqf:replace>
        </sqf:fix>
        <sqf:fix id="addtitle">
            <sqf:description>
                <sqf:title>Titel hinzufügen</sqf:title>
                <sqf:p>Fügt einen Titel hinzu</sqf:p>
            </sqf:description>
            <sqf:add target="title" node-type="element" position="first-child"/>
        </sqf:fix>
        <sqf:fix id="addheader">
            <sqf:description>
                <sqf:title>Header hinzufügen</sqf:title>
                <sqf:p>Fügt einen Header hinzu</sqf:p>
            </sqf:description>
            <sqf:add target="header1" node-type="element" position="after"/>
        </sqf:fix>
        <sqf:fix id="addlegend">
            <sqf:description>
                <sqf:title>Legende hinzufügen</sqf:title>
                <sqf:p>Legende an die Figure anhängen</sqf:p>
            </sqf:description>
            <sqf:add>
                <legend xmlns="">
                    <para/>
                </legend>
            </sqf:add>
        </sqf:fix>
    </sqf:fixes>

    <pattern id="info">
        <title>Infomeldungen</title>
        <rule context="/" role="Versionsinfo und Statistik">
            <report test="." role="info"> [Statistik] Links: <value-of select="count(//link[@idref = $ids])"/> valide + <value-of select="count($idrefs) - count(//link[@idref = $ids])"/> invalide + <value-of select="count(//link[not(@idref)])"/> leer = <value-of select="count(//link)"/> gesamt </report>
            <report test="." role="info"> [Statistik] Linkziele: <value-of select="count($ids[. = $idrefs])"/> genutzt + <value-of select="count($ids) - count(//@id[. = $idrefs])"/> ungenutzt = <value-of select="count($ids)"/> gesamt </report>
            <report test="." role="info"> [Statistik] Medien: <value-of select="$valid_filerefs"/> verknüpft + <value-of select="$all_filerefs - $valid_filerefs - $empty_filerefs"/> fehlerhaft + <value-of select="$empty_filerefs"/> leer = <value-of select="$all_filerefs"/> gesamt </report>
            <report test=".[//@index]" role="info"> [Statistik] Indices: <value-of select="string-join(distinct-values(//@index), ', ')"/></report>
            <!--<report test="." role="info"> [Statistik] Dokumentgröße: <value-of select="round(string-length(unparsed-text(document-uri(.))) div 1024)"/> kB</report>-->
        </rule>
    </pattern>
    <pattern id="metadata" see="http://wiki.l42.net/Thieme/3._XML-Bearbeitung/Metadaten_bzw._Titelei">
        <title>Metadatenprüfungen</title>
        <rule role="Doppelte Metadaten prüfen" id="rule-2" abstract="true">
            <!--       <report test="count(parent::*/*[name()=current()/name() and @type=current()/@type])>1" sqf:fix="duplicates">Das Element <name/> mit Attributwert <value-of select="@type"/> ist mehrfach gesetzt. Bitte entfernen Sie doppelte Einträge</report>
            <report test="count(parent::*/*[name()=current()/name() and not(@type)])>1" sqf:fix="duplicates">Das Element <name/> wurde mehrfach verwendet. Bitte entfernen Sie die doppelten Angaben</report>
     -->
        </rule>
        <rule context="personid" role="Prüfung auf doppelte GP-Nummern">
            <report test="string-length(normalize-space(.)) = 0">Das Element <name/> darf nicht leer sein</report>
            <report test="string-length(normalize-space(.)) > 0 and count(parent::*/*[. = current()]) > 1" sqf:fix="remvalue">Die GP-Nummer <value-of select="."/> in <name/> wurde mehrfach verwendet. Bitte entfernen Sie das Duplikat</report>
        </rule>
        <rule context="materialid" role="Gültigkeit der Materialnummer prüfen">
            <report test=". = '1010654321'" sqf:fix="april">Auch die umgekehrte Beispielnummer darf nicht als Materialnummer verwendet werden</report>
            <assert test="matches(., '^\d{6,10}$') or string-length(.) = 0" sqf:fix="april">Die Materialnummer muss aus einer sechs- bis zehnstelligen Zahl bestehen</assert>
            <extends rule="rule-2"/>
            <sqf:fix id="april">
                <sqf:description>
                    <sqf:title>Ändere die Nummer</sqf:title>
                </sqf:description>
                <sqf:stringReplace regex="^.+$" match="text()" select="codepoints-to-string(reverse(string-to-codepoints(substring(replace(., '\D', '0'), 1, 10))))"/>
            </sqf:fix>
        </rule>
        <rule context="isbn" role="Gültigkeit der ISBN-Nummer prüfen">
            <let name="checksum" value="number(substring(., string-length(), 1))"/>
            <let name="digits" value="
                    for $i in reverse(string-to-codepoints(substring(., 1, string-length() - 1)))
                    return
                        $i - 48"/>
            <let name="calculation" value="
                    sum((for $i in $digits[(position()) mod 2 = 1]
                    return
                        $i * 3,
                    for $i in $digits[(position()) mod 2 = 0]
                    return
                        $i)) mod 10"/>
            <report test="
                    string-length(.) ne 13 or (if ($calculation ne 0) then
                        (10 - $calculation)
                    else
                        0) ne $checksum" role="warn">Die ISBN-Nummer hat eine ungültige Prüfziffer und sollte überprüft werden</report>
            <extends rule="rule-2"/>
        </rule>

        <rule context="language">
            <assert test="contains(upper-case(/*/@language), .)" role="warn" sqf:fix="metalanguage">Die Sprache des Dokuments weicht von der Sprachangabe in den Metadaten ab. Bitte prüfen Sie die Sprachangaben</assert>
            <sqf:fix id="metalanguage">
                <sqf:description>
                    <sqf:title>An Dokumentsprache angleichen</sqf:title>
                </sqf:description>
                <sqf:stringReplace regex=".+" match="text()" select="upper-case(substring-before(/*/@language, '-'))"/>
            </sqf:fix>
        </rule>
        <rule context="docdate" role="Gültigkeit des Datums prüfen">
            <assert test="matches(., '^([\d]{4})-(1[0-2]|0[1-9])-(3[0-1]|0[1-9]|[1-2][\d])$')" role="warn">Das Datum sollte auf JJJJ-MM-TT geändert werden, damit es ISO 8601 entspricht</assert>
            <extends rule="rule-2"/>
        </rule>
        <rule context="doi">
            <report test="matches(., '[^a-z0-9\.\-/]')">Die DOI darf nur Buchstaben, Zahlen, Punkte, Bindestriche und Slashes (/) enthalten</report>
            <extends rule="rule-2"/>
        </rule>
        <rule context="meta/*[not(name() = 'collaborator')]" role="Doppelte Metadaten prüfen">
            <extends rule="rule-2"/>
        </rule>
        <rule context="@startnum">
            <sqf:fix id="startnum-dups">
                <sqf:description>
                    <sqf:title>Duplikate entfernen</sqf:title>
                    <sqf:p>Entfernt Duplikate und behält das ausgewählte Element bei</sqf:p>
                </sqf:description>
                <sqf:delete match="//(document | section)/@startnum[not(generate-id() = generate-id(current()))]"/>
            </sqf:fix>
            <report test="count(//(document | section)/@startnum) > 1" sqf:fix="startnum-dups">Das Dokument enthält mehrere Startnummern, darf aber nur eine Startnummer enthalten</report>
        </rule>
    </pattern>

    <pattern see="http://wiki.l42.net/Thieme/3._XML_Grundlagen/Verlinkungen" id="links">
        <title>Verlinkungen</title>
        <rule context="link/@idref" role="Gültigkeitsprüfungen für gesetzte Links">
            <report test="matches(., '[^A-Za-z0-9:_\.\-]')" sqf:fix="sonderzeichen">IDs dürfen keine Sonderzeichen enthalten, da dies zu Problemen in EPUBs oder Webanwendungen führen könnte</report>
            <assert test=". = $ids" role="warn">Link <value-of select="."/> hat kein gültiges Ziel</assert>
            <sqf:fix id="sonderzeichen">
                <sqf:description>
                    <sqf:title>Sonderzeichen aus IDs entfernen</sqf:title>
                    <sqf:p>Dieser SQFix entfernt Sonderzeichen aus IDs</sqf:p>
                </sqf:description>
                <let name="clean_id" value="replace(., '[^A-Za-z0-9:_\.\-]', '_')"/>
                <sqf:replace node-type="attribute" match="$ids[. = current()]" target="id" use-when="not($ids[. = $clean_id])">
                    <value-of select="$clean_id"/>
                </sqf:replace>
                <sqf:replace node-type="attribute" target="idref" use-when="not($ids[. = $clean_id])">
                    <value-of select="$clean_id"/>
                </sqf:replace>
            </sqf:fix>
        </rule>
        <rule context="link[@idref = $ids]" role="Gültigkeitsprüfung für alle Links">
            <let name="id" value="@idref"/>
            <let name="element" value="(//*[@id = $id])[1]"/>
            <report role="warn" test="@idref = $ids and @target = ('audio', 'figure', 'video') and not($element/name() = ('figure', 'subfigure'))">Dieser Link mit @target=<value-of select="@target"/> verweist auf <name path="$element"/> und nicht auf eine Abbildung. Das Ziel muss (sub-)figure sein</report>
            <report role="warn" test="@idref = $ids and @target = ('box', 'formula', 'part', 'section', 'table') and not($element/name() = @target)" sqf:fix="target">Dieser Link mit @target=<value-of select="@target"/> verweist auf <name path="$element"/>, muss aber auf <value-of select="@target"/> verweisen.</report>
            <report role="warn" test="@idref = $ids and @target = 'literature' and not($element/name() = ('literature', 'litref'))">Dieser Link mit @target=<value-of select="@target"/> verweist auf <name path="$element"/> und nicht auf eine Literaturstelle. Das Ziel muss literature oder litref sein</report>
            <report role="warn" test="@idref = $ids and @target = 'excursus' and not($element/name() = ('section'))">Dieser Link mit @target=<value-of select="@target"/> verweist auf <name path="$element"/> und nicht auf ein Kapitel. Das Ziel muss section sein</report>
            <report test="@target = 'page' and string-length(normalize-space(.)) = 0">Dieser Link muss echten Text beinhalten</report>
            <report test="@target = ('audio', 'figure', 'video', 'table') and (following-sibling::node()[1]/@target = 'page' or string-length(normalize-space(following-sibling::node()[1])) &lt; 5 and following-sibling::node()[2]/@target = 'page')">Laut Redaktionsrichtlinie darf einem Abbildungs- oder Tabellenverweis kein Seitenverweis folgen</report>
            <sqf:fix id="target">
                <sqf:description>
                    <sqf:title>Target-Attribut korrigieren</sqf:title>
                    <sqf:p>Ändert das @target, damit es zum Zielknoten passt</sqf:p>
                </sqf:description>
                <sqf:add target="target" node-type="attribute" select="$element/name()" use-when="$element/name() = ('box', 'formula', 'part', 'section', 'table')"/>
            </sqf:fix>
        </rule>
        <rule context="uri" role="Uris prüfen" see="http://wiki.l42.net/Thieme/3._XML-Bearbeitung/Verlinkungen/URIs">
            <assert test="@type = 'email' or matches(@href, '^(https?|ftp)://[^\s/$\.?#\\\(\)]+\.[^\s\\\(\)]+$')">Die angegebene URL ist nicht zulässig, da sie falsch formatiert ist oder ungültige Zeichen beinhaltet</assert>
            <report test="@type = 'email' and not(matches(@href, '^[^0-9\s]\S+@\S+\.\S+$'))">Die angegebene E-Mail ist nicht zulässig</report>
        </rule>
        <rule context="para/text() | emph/text() | footnote/text() | literature/text()" role="Text mit möglichen Uris" see="http://wiki.l42.net/Thieme/3._XML-Bearbeitung/Verlinkungen/URIs">
            <report test="contains(., 'www.')" sqf:fix="uri">In diesem Absatz ist eine Webadresse nicht verlinkt. Damit Links anklickbar sind, müssen diese mit uri ausgezeichnet werden</report>
            <report role="warn" test="matches(., '[^0-9\s]\S+@\S+\.\S+')" sqf:fix="uri-mail">Möglicherweise ist in diesem Absatz eine E-Mail-Adresse nicht verlinkt. Damit Links anklickbar sind, müssen diese mit uri ausgezeichnet werden</report>
            <sqf:fix id="uri">
                <sqf:description>
                    <sqf:title>Webadressen umwandeln</sqf:title>
                    <sqf:p>Versuche, die Webadressen in uri umzuwandeln</sqf:p>
                </sqf:description>
                <sqf:stringReplace regex="(((https?|ftp)://|www\.)[^\s/$.?#].[^\s]*)">
                    <xsl:analyze-string select="." regex="(((https?|ftp)://|www\.)[^\s/$.?#].[^\s]*)">
                        <xsl:matching-substring>
                            <uri xmlns="" href="{if(starts-with(regex-group(1),'www')) then 'http://' else ''}{regex-group(1)}"><xsl:copy-of select="regex-group(1)"/></uri>
                        </xsl:matching-substring>
                    </xsl:analyze-string>
                </sqf:stringReplace>
            </sqf:fix>
            <sqf:fix id="uri-mail">
                <sqf:description>
                    <sqf:title>E-Mail-Adressen umwandeln</sqf:title>
                    <sqf:p>Versuche, die E-Mail-Adresse in uri umzuwandeln</sqf:p>
                </sqf:description>
                <sqf:stringReplace regex="(\S+@\S+\.\S+)">
                    <xsl:analyze-string select="." regex="(\S+@\S+\.\S+)">
                        <xsl:matching-substring>
                            <uri xmlns="" href="{regex-group(1)}" type="email"><xsl:copy-of select="regex-group(1)"/></uri>
                        </xsl:matching-substring>
                    </xsl:analyze-string>
                </sqf:stringReplace>
            </sqf:fix>
        </rule>
        <rule context="figure" role="Prüfung auf fehlerhaft verlinkte Abbildungen">
            <report test="//link[@idref = current()//@id and @target = ('audio', 'figure', 'video')] and not(.//legend | .//title)" role="warn" sqf:fix="addtitle addlegend">Auf diesen Abbildungscontainer wurde verlinkt (<value-of select=".//@id[. = $idrefs]"/>). Er benötigt daher einen Titel oder eine Legende, damit eine Abbildungsnummer generiert werden kann</report>
            <let name="filerefs" value=".//@fileref[string-length(normalize-space()) > 0]"/>
            <assert test="count(distinct-values($filerefs)) = count($filerefs)">In dieser Figure wurde dieselbe Abbildungen mehrfach referenziert, bitte Duplikate löschen</assert>
        </rule>
    </pattern>

    <pattern see="http://wiki.l42.net/Thieme/3._XML-Bearbeitung/Abbildungen" id="figures">
        <title>Mediencontainer</title>
        <rule context="@fileref" role="Gültigkeit der Medien prüfen" see="http://wiki.l42.net/Thieme/3._XML-Bearbeitung/Abbildungen/Dateinamenkonvention">
            <let name="is_cs" value="starts-with(., 'censhare://')"/>
            <report test="not($all_filerefs = $empty_filerefs) and string-length() = 0">Sie müssen diesem Mediencontainer einen Dateinamen geben</report>
            <report test="not($is_cs) and $valid_filerefs &gt; 0 and not(f:exists(f:new(resolve-uri(replace(., '[^a-zA-Z0-9_\-\.]', ''), base-uri()))))" role="warn">Die Mediendatei <value-of select="."/> fehlt im Dateisystem</report>
            <report test="$is_cs and $valid_filerefs &gt; 0 and not(doc-available((tokenize(., '/storage')[1])))">Die Mediendatei <value-of select="."/> fehlt in censhare</report>
        </rule>

        <rule context="figure[count(subfigure) > 1]/subfigure" role="Prüfung auf Teilabbildungslegenden">
            <assert test="legend" sqf:fix="addlegends">Abbildungen mit mehr als einer Teilabbildung benötigen Teilabbildungslegenden</assert>
            <sqf:fix id="addlegends">
                <sqf:description>
                    <sqf:title>Legenden hinzufügen</sqf:title>
                    <sqf:p>Fügt die Struktur für Teilabbildungslegenden hinzu</sqf:p>
                </sqf:description>
                <sqf:add match="parent::*/subfigure[not(legend)]" position="last-child">
                    <legend xmlns="">
                        <para/>
                    </legend>
                </sqf:add>
            </sqf:fix>
        </rule>
        <rule context="figure//para" role="Prüfung auf subfigures">
            <report test="//link[@idref = current()//@id and @target = ('audio', 'figure', 'video')]">Bei Verweisen auf Abbildungen muss das (sub-)figure-Element genutzt werden</report>
        </rule>
        <rule context="tableau/graphic" role="Tableaus prüfen">
            <report test="@* except @fileref" sqf:fix="tableauclean">Die Tableau-Abbildung darf außer @fileref keine weiteren Attribute beinhalten.</report>
            <sqf:fix id="tableauclean">
                <sqf:description>
                    <sqf:title>Falsche Attribute entfernen</sqf:title>
                    <sqf:p>Alle falsch gesetzten Attribute löschen</sqf:p>
                </sqf:description>
                <sqf:delete match="@* except @fileref"/>
            </sqf:fix>
        </rule>
        <!-- In DTD aufnehmen; aktuell wegen cmids/cls nicht möglich -->
        <!-- <rule context="video | audio" role="Audio/Video-IDs für QR-Code-Seiten prüfen" see="http://wiki.l42.net/Thieme/3._XML-Bearbeitung/Video">
            <assert test="@id" role="warn">Das <name/>-Element muss eine ID beinhalten, wenn es im Buchprozess als Zusatzinhalt verlinkt werden soll</assert>
        </rule>-->
        <rule context="figure[subfigure/(video | audio)]" role="Prüfen auf nicht erlaubte Teilmedien" see="http://wiki.l42.net/Thieme/3._XML-Bearbeitung/Video">
            <report test="count(subfigure) &gt; 1">Eine <name/> mit audio oder video darf nur eine subfigure beinhalten</report>
            <assert test="legend" role="warn" sqf:fix="addlegend">Eine <name/> mit <name path="(subfigure/(video | audio))[1]"/> benötigt für e-Produkte eine Legende</assert>
        </rule>
        <rule context="audio" role="Prüfe audio-Attribute">
            <assert test="ends-with(@fileref, '.mp3')" role="warn"><name/> benötigt als Dateiendung '.mp3'</assert>
        </rule>
        <rule context="graphic[not(@fileref = '') and not(starts-with(@fileref, 'censhare://'))]" role="Prüfe graphic-Attribute">
            <assert test="matches(@fileref, '\.(eps|tif|jpg|png|gif|svg)$')" role="warn"><name/> benötigt als Dateiendung '.eps', '.tif', '.jpg', '.png', '.gif', '.svg'</assert>
        </rule>
        <rule context="@rights" role="Prüfe rights-Attribut">
            <assert test=". = '3rdparty'" role="warn" sqf:fix="thirdparty remvalue"><name/> darf nur 3rdparty enthalten</assert>
            <sqf:fix id="thirdparty">
                <sqf:description>
                    <sqf:title>3rdparty setzen</sqf:title>
                    <sqf:p>Den Attibutwert in 3rdparty ändern</sqf:p>
                </sqf:description>
                <sqf:replace node-type="attribute" target="rights">3rdparty</sqf:replace>
            </sqf:fix>
        </rule>
        <rule context="table//figure" role="Prüfe Abbildungen in Tabellen">
            <assert test="@counter = 'no'">Abbildungen in Tabellen müssen immer auf counter=no gesetzt sein</assert>
            <report test=".//legend" sqf:fix="remelm">Abbildungen in Tabellen dürfen keine Legenden beinhalten</report>
        </rule>
        <!-- hha: -->
        <rule context="legend">
            <report test="emph[@type = 'marker']">Das Element emph type=“marker“ innerhalb von legend ist nicht erlaubt.</report>
            <report test="./link">Das Element link innerhalb von legend ist nicht erlaubt.</report>
        </rule>
    </pattern>

    <pattern see="http://wiki.l42.net/Thieme/3._XML-Bearbeitung/Tabellen" id="tables">
        <title>Tabellen</title>
        <rule context="col" role="Prüfe auf gültigen col-Wert">
            <assert test="matches(@width, '^\d+(%|px|pt)?$')">Der col-Wert ist ungültig. Erlaubt sind nur Zahlen; optional mit den Einheiten %, px oder pt</assert>
        </rule>
        <rule context="table" role="Colspan- und Tabellenkopf-Überprüfung bei Tabellen">
            <let name="colsnr" value=".//col/number(replace(@width, '[^\d]', ''))"/>
            <assert test="
                    count(.//tr) * count(.//col) = sum(for $n in .//(td | th)
                    return
                        number(($n/@colspan,
                        '1')[1]) * number(($n/@rowspan,
                        '1')[1]))">Die Anzahl der Zellen ist ungültig. Bitte überprüfen Sie die Anzahl der col-Elemente, sowie die Attribute @colspan und @rowspan</assert>
            <report test="count(distinct-values(.//col/replace(@width, '\d', ''))) > 1" subject="col">Es dürfen nur gleiche Maßeinheiten in einer Tabelle verwendet werden</report>
            <report test="max($colsnr) &gt; min($colsnr) * 10" role="warn">Die Spaltenbreiten weisen extreme Verhältnisse auf (liegen mehr als um den Faktor 10 auseinander) und müssen überprüft werden</report>
            <assert role="warn" test="thead" sqf:fix="addthead">Die Tabelle hat keine Kopfzeile. Falls die Tabelle eine Kopfzeile besitzt, strukturieren Sie diese bitte mit thead</assert>
            <sqf:fix id="addthead">
                <sqf:description>
                    <sqf:title>Erste Zeile in thead umwandeln</sqf:title>
                    <sqf:p>Verschiebt die erste Zeile in ein thead-Element</sqf:p>
                </sqf:description>
                <sqf:add target="thead" node-type="element" position="first-child" select="tbody/tr[1]"/>
                <sqf:delete match="tbody/tr[1]"/>
            </sqf:fix>
        </rule>
    </pattern>

    <pattern id="listing">
        <title>Auflistungen</title>
        <rule context="listing" role="Prüfung der Listenelemente">
            <report role="warn" test="count(ancestor::listing) &gt; 1">Mehr als zwei Listenebenen sollten aufgrund von Darstellungsproblemen vermieden werden</report>
            <report role="warn" test=".//(figure | table | box)">Abbildungen, Tabellen und Boxen sollte wegen Darstellungsproblemen in Templates und Online-Applikationen nicht in <name/> verwendet werden</report>
        </rule>
    </pattern>

    <pattern id="container">
        <title>Sonderumgebungen</title>
        <rule context="box[@type = ('caution', 'comment', 'definition', 'exam', 'guidline', 'practical', 'remember', 'summary')]" role="Fehlerhafte Boxen" see="http://wiki.l42.net/Thieme/3._XML-Bearbeitung/Boxen">
            <assert test="title" sqf:fix="addtitle">Bitte vergeben Sie an dieser Box (<value-of select="@type"/>) einen Titel mit dem Element title</assert>
        </rule>
        <rule context="box[@type=('addition', 'definition')]">
            <assert test="header1" sqf:fix="addheader">Bitte vergeben Sie an dieser Box (<value-of select="@type"/>) einen Header mit dem Element header1</assert>
        </rule>
        <rule context="box[@type = ('addition', 'other', 'profile')]" role="Fehlerhafte Boxen" see="http://wiki.l42.net/Thieme/3._XML-Bearbeitung/Boxen">
            <report role="warn" test="title" sqf:fix="addtitle">Diese Box (<value-of select="@type"/>) darf keine Überschrift in Form eines title besitzen</report>
        </rule>
        <rule context="box[@type = ('pitfall', 'symptome', 'technique', 'therapy')]">
            <report test=".">Dieser Boxtyp (<value-of select="@type"/>) darf in via medici nicht benutzt werden.</report>
        </rule>
        <!-- Ausgenommen wegen Bug in Saxon 9.6.0.5, gelöst in Oxygen 19/Saxon 9.7.0.15 -->
        <!--<rule context="quote" role="Autorenangabe bei Zitaten">
            <report role="warn" test="para[matches(string-join(text(),' ') , '^(\S+[\s,]*)+\d{4}')]">Eine Autorenangabe muss im origin-Feld eines Zitates stehen</report>
        </rule>-->
        <rule context="ingredient" role="Prüfung auf fehlerhafte Überschriften in Rezepten">
            <report role="warn" test="emph" subject="emph" sqf:fix="titlereplace">Hierbei handelt es sich wahrscheinlich um eine Überschrift, diese muss als title gesetzt werden</report>
            <sqf:fix id="titlereplace">
                <sqf:description>
                    <sqf:title>durch Titel ersetzen</sqf:title>
                </sqf:description>
                <sqf:add target="title" node-type="element" position="before" select="emph/node()"/>
                <sqf:delete/>
            </sqf:fix>
        </rule>
    </pattern>

    <pattern id="indexentry" see="http://wiki.l42.net/Thieme/3._XML-Bearbeitung/Indexmarken">
        <title>Indexeinträge</title>
        <rule context="indexentry" role="Indexentry-Prüfung">
            <report role="warn" test="ends-with(preceding-sibling::node()[1][self::text()], ' ') and starts-with(following-sibling::node()[1][self::text()], ' ')">Mehr als ein Leerzeichen umgibt indexentry</report>
            <report test="entry4, entry5, entry6">Mehr als drei Ebenen in indexentry sind nicht mehr erlaubt</report>
        </rule>
    </pattern>

    <pattern id="partsection" see="http://wiki.l42.net/Thieme/3._XML-Bearbeitung">
        <title>Kapitel und Werkteile</title>
        <rule context="part/section" role="Prüfung der EPub-Dateigröße">
            <let name="size" value="string-length(string-join(.//*/text(), '')) * 1.4"/>
            <let name="maxsize" value="400000"/>
            <report test="$size > $maxsize and count(.//processing-instruction()) = 0" role="warn">Dieses Kapitel ist voraussichtlich um <value-of select="round(($size - $maxsize) div 1024)"/> kB zu groß und muss für EPub mit einer PI getrennt werden</report>
        </rule>
        <rule context="part/trailer">
            <report test="." role="info">Der Part-Trailer wird nicht in jedem Template/jeder Layout-Konfiguration ausgegeben – bitte Ergebnis prüfen!</report>
        </rule>
        <rule context="section/section" role="Absatzprüfung">
            <assert test="* except (title | shorttitle)" sqf:fix="remvalue">Dieses Kapitel ist leer, es muss neben dem Titel noch weitere Elemente beinhalten</assert>
            <report test="count(ancestor::section) &gt; 6">Es dürfen nicht mehr als sieben Kapitelhierarchiestufen verwendet werden</report>
        </rule>
    </pattern>

    <pattern id="text">
        <title>Absätze</title>
        <rule abstract="true" id="rule-1" role="Prüfung auf Whitespace">
            <report role="warn" test="starts-with(descendant::text()[1], ' ') and not(name(*[1]) = 'link')">Whitespace zu Beginn von <name/></report>
        </rule>
        <rule context="emph" role="Prüfung der Auszeichnungen">
            <sqf:fix id="emph-combine">
                <sqf:description>
                    <sqf:title>Zusammenführen</sqf:title>
                    <sqf:p>Mit vorhergehendem Element zusammenführen</sqf:p>
                </sqf:description>
                <let name="content" value="child::node()"/>
                <sqf:add match="preceding-sibling::node()[1][name() = 'emph']" position="last-child" select="$content"/>
                <sqf:delete/>
            </sqf:fix>
            <report role="warn" test="preceding-sibling::node()[1][name() = 'emph' and @type = current()/@type]" sqf:fix="emph-combine">Dieses <name/> kann mit dem vorhergehenden <name/> zusammengeführt werden</report>
            <report role="warn" test="matches(preceding-sibling::node()[1][self::text()], '^\s*$') and preceding-sibling::node()[2][name() = 'emph' and @type = current()/@type]">Dieses <name/> kann mit dem vorhergehenden <name/> zusammengeführt werden</report>
            <report role="warn" test="string-length(normalize-space()) = 0" sqf:fix="remelm">Dieses <name/> wird wahrscheinlich nicht benötigt und kann entfernt werden</report>
        </rule>
        <!-- hha -->
        <rule context="emph[@type = 'marker']">
            <report test="count(/target[@related]) &gt; 0">Das Element emph type='marker' muss immer mit mindestens einem Element target related ='xxy' beginnen.</report>
        </rule>
        <rule context="target[@related]">
            <report test="../emph[@type = 'marker']">Das Element target related ='xxy' muss immer innerhalb von emph type='marker' stehen..</report>
        </rule>
        <rule context="para" role="Paraprüfung">
            <report test="uri[@type = 'qrcode'] and count(descendant::node()) &gt; 1">Ein QR-Code link muss exklusiv in einem para stehen</report>
            <report test="matches(., 'HYPERLINK|REF _Ref')">In diesem <name/> ist ein defekter Verweis enthalten</report>
            <extends rule="rule-1"/>
        </rule>
        <rule context="comment()" role="Prüfung auf defekte Verweise">
            <report test="matches(., 'Nicht identfizierbares Feld')">In diesem Absatz ist ein defekter Verweis enthalten</report>
        </rule>
        <rule context="notInFont" role="notInFont" see="http://wiki.l42.net/Thieme/z._Fehlersuche/Sonderzeichen">
            <report role="warn" test=".">Im Dokument sind <name/>-Elemente enthalten</report>
        </rule>
        <rule context="processing-instruction('oxy_comment_start')" role="Oxygen-Kommentare" see="http://wiki.l42.net/Thieme/z._Fehlersuche/Bemerkungen">
            <report test="." role="warn">Dieser Oxygen-Kommentar deutet auf eine unfertige XML-Datei hin</report>
        </rule>
        <rule context="title | shorttitle" role="Titelprüfungen">
            <report test="string-length(normalize-space(.)) = 0 and not(*)">Ein Titel darf nicht leer sein</report>
            <report test="link, uri">In <name/> dürfen keine Links stehen</report>
            <extends rule="rule-1"/>
        </rule>
        <!-- hha -->
        <rule context="paratitle2">
            <report test=".">Das Element paratitle2 ist nicht erlaubt.</report>
        </rule>
    </pattern>

    <pattern id="text3">
        <title>Allgemeine Textprüfungen</title>
        <rule context="
                *[not(name() = ('br',
                'graphic',
                'audio',
                'video',
                'col',
                'concept',
                'custom',
                'td',
                'th',
                'target'))]" role="Leere Elemente und Blockaden">
            <report role="warn" test="not(name() = ('link', 'personid', 'title', 'shorttitle')) and string-length(normalize-space(.)) = 0 and not(*)">Das Element <name/> ist leer</report>
            <!-- sqf funktioniert nicht <sqf:stringReplace regex="[&amp;#x7f;-&amp;#x9f;]" match="text()"></sqf:stringReplace> -->
            <report test="text()[matches(., '[^\P{Cc}\n\t]')]">Aus <name/> müssen ungültige Zeichen entfernt oder ersetzt werden: <value-of select="replace(., '[\P{Cc}\n\t]', '')"/></report>
        </rule>
        <!-- Workaround, da sonst m:semantics geprüft wird auch wenn es keine Attribute hat -->
        <rule context="*[not(local-name() = 'semantics')]/@*[not(name() = 'fileref')]" role="Allgemeine Attribut- und Blockadenprüfung">
            <report test="string-length(.) = 0">Der Attributwert darf nicht leer sein</report>
        </rule>
    </pattern>

    <pattern id="deprecated">
        <title>Obsolete Elemente prüfen</title>
        <rule context="section" role="Prüfung auf @counter und @level">
            <report test="@counter" sqf:fix="remvalue-counter remvalues-counter">Das @counter-Attribut darf an <name/> nicht mehr verwendet werden</report>
            <report role="warn" test="number(@level) = (1 to 7)" sqf:fix="remvalue-level remvalues-level">@level sollte nicht mehr verwendet werden und kann im Normalfall einfach gelöscht werden</report>
            <sqf:fix id="remvalue-counter">
                <sqf:description>
                    <sqf:title>Eintrag entfernen</sqf:title>
                    <sqf:p>Löscht den selektierten Knoten</sqf:p>
                </sqf:description>
                <sqf:delete match="@counter"/>
            </sqf:fix>
            <sqf:fix id="remvalue-level">
                <sqf:description>
                    <sqf:title>Eintrag entfernen</sqf:title>
                    <sqf:p>Löscht den selektierten Knoten</sqf:p>
                </sqf:description>
                <sqf:delete match="@level"/>
            </sqf:fix>
            <sqf:fix id="remvalues-counter">
                <sqf:description>
                    <sqf:title>Eintrag an allen <name/> entfernen</sqf:title>
                    <sqf:p>Löscht den selektierten Knoten</sqf:p>
                </sqf:description>
                <sqf:delete match="//section/@counter"/>
            </sqf:fix>
            <sqf:fix id="remvalues-level">
                <sqf:description>
                    <sqf:title>Eintrag an allen <name/> entfernen</sqf:title>
                    <sqf:p>Löscht den selektierten Knoten</sqf:p>
                </sqf:description>
                <sqf:delete match="//section/@level"/>
            </sqf:fix>
        </rule>
        <rule context="section/subtitle" role="Prüfung auf falsch verwendeten subtitle">
            <assert test="
                    preceding-sibling::*[1]/name() = ('title',
                    'titletranslated')" sqf:fix="to_paratitle">Subtitle darf nur noch direkt nach title verwendet werden</assert>
            <sqf:fix id="to_paratitle">
                <sqf:description>
                    <sqf:title>In Paratitle konvertieren</sqf:title>
                    <sqf:p>Wandelt das selektierte Element in paratitle um</sqf:p>
                </sqf:description>
                <sqf:replace target="paratitle1" node-type="keep" select="child::node()"/>
            </sqf:fix>
        </rule>
    </pattern>
</schema>
