<?xml version="1.0" encoding="UTF-8"?>
<!-- 
  Schematron als Ergänzung zur KIS DTD
  Patrick Schwarz, (c) Georg Thieme Verlag KG Stuttgart
  Changelog:
    v0.1 initial release, ps, 15.03.2012
    v1.0, aufgeräumt, Prüfung im Images- und Rootordner, Check für alte Boxtypen und leere Elemente
    v1.1, 24.08.12 Dateipfad für Abbildungsprüfung umgestellt, da nicht mehr funktionsfähig
    v1.2, 29.11.12 Links ohne id aufzählen; Prüfung Datumsangaben, ISBN-Nummer, Materialnummer; URL-Filter gegen Schematron-Abbruch bei Sonderzeichen (Abb.)
    v1.3, 14.12.12 Neues Metadatenmodell ergänzt
    v1.4, 07.01.13 Warnungen und Fehler korrigiert
    v1.5, 04.02.13 Formulierung, empty Element Prüfung korrigiert
    v1.6, 25.02.13 Prüfregeln für Tabellen, externe Links, x-Level, leere Dateinamen in Abbildungen, Section-Titellänge
    v1.7, 20.03.13 Prüfung nach mehrfach gesetzten meta-Elementen, Prüfung nach unnötigen emphs
    v1.8, 11.04.13 Bugfix Section-Titellänge und uri-Prüfung, Deprecated-Elemente
    v1.9, 10.07.13 Keine figure,box,table in listing; para beginnt mit Leerzeichen; Absatzprüfung; Tabellenkopfzeile; Listenebenen; Sectionabsatz (Lu)
    v1.10,30.08.13 Fehlerhafte Regel zum Prüfen von überflüssigen Leerzeichen vorerst entfernt
    v1.11,09.10.13 Link mit target page muss echten Text beinhalten (si), front/backmatter-Prüfung, Blockadenprüfung (arj), col-width-Werte, indexentry-Leerzeichen, kein Link im title (arj), uri als Fehler, Prüfung auf doppelte personid-Werte (arj)
    v1.12,04.06.14 Part-Prüfungen erweitert, notInFont-Info (si), keine Umlaute in IDs (si), keine Links auf Abbildungen ohne Legende (si)
    v1.13,27.06.14 Abb ohne Legende: Nur Warnung, Probleme bei Anwendung der Link-Regeln behoben, Versionsbezeichnung entfernt, Alte Boxen: Fehler (arj)
    v1.14,31.07.14 Kommentare als Hinweis anzeigen (Lu); Prüfung von leeren Elementen auf Elemente eingegrenzt, col/rowspan-Überprüfung neu geschrieben (md), alte Metaprüfungen entfernt
    v1.15,22.08.14 a/v-@id-Prüfung (arj), Nur Warnung bei mehrfach verwendeten Meta-Elementen (Lu)
    v1.16,24.10.14 collaborator aus meta-Duplikatprüfung entfernt, box-H-Prüfung entfernt, deprecated-Elemente entfernt, backmatter entfernt, div. Tabellenprüfungen, div. Linkprüfungen, Section @counter/@level, @index-Info, Prüfung ob Tab/Abb verlinkt (si)
-->
<schema xmlns="http://purl.oclc.org/dsdl/schematron" see="http://wiki.l42.net/Thieme/4._Oxygen/Schematron" queryBinding="xslt2" xml:lang="de-DE">
    <let name="dir_fileref" value="'images/'"/>
    <ns uri="java:java.io.File" prefix="f"/>
    <ns uri="java:java.net.URI" prefix="u"/>
    <let name="idrefs" value="//link/@idref"/>
    <let name="ids" value="//@id"/>
    <title>KIS Schematron</title>

    <!-- Infomeldungen -->
    <pattern id="info">
        <rule context="/" role="Versionsinfo und Statistik">
            <report test="." role="info">
                <value-of select="concat('[Statistik] Links: ',count(//link[@idref = $ids]),' valide + ',count($idrefs) - count(//link[@idref = $ids]),' invalide + ',count(//link[not(@idref)]),' leer = ',count(//link),' gesamt')"/>
            </report>
            <report test="." role="info">
                <value-of select="concat('[Statistik] Linkziele: ',count($ids[. = $idrefs]),' genutzt + ',count($ids) - count(//@id[. = $idrefs]),' ungenutzt = ',count($ids),' gesamt')"/>
            </report>
            <report test="." role="info">
                <value-of select="concat('[Statistik] Abbildungen: ',count(//@fileref[not(f:exists(f:new(resolve-uri(concat($dir_fileref,replace(., '[^a-zA-Z0-9_\-. ]','')), base-uri())))) and not(f:exists(f:new(resolve-uri(replace(., '[^a-zA-Z0-9_\-. ]',''), base-uri()))))]),' von ',count(//graphic),' fehlen, davon ',count(//graphic[@fileref='']),' leer')"/>
            </report>
            <report test="." role="info">
                <value-of select="concat('[Statistik] Indices: ',string-join(distinct-values(//@index), ', '))"/>
            </report>
        </rule>
    </pattern>

    <!-- Metadaten und -nummern prüfen -->
    <!-- (Contains deprecated elements) -->
    <pattern id="metadata" see="http://wiki.l42.net/Thieme/3._XML-Bearbeitung/Buchaufbau/Titelei">
        <rule context="meta/*[not(name()='collaborator')]" role="Metadaten-Duplikate prüfen">
            <let name="name" value="name()"/>
            <let name="type" value="@type"/>
            <report test=".[count(parent::*/*[name()=$name and @type=$type])>1]">Das Element <name/> mit Attributwert <value-of select="@type"/> ist mehrfach gesetzt. Bitte entfernen Sie die doppelten Einträge</report>
            <report test=".[count(parent::*/*[name()=$name and not(@type)])>1]">Das Element <name/> wurde mehrfach verwendet. Bitte entfernen Sie die doppelten Angaben</report>
        </rule>
    </pattern>
    <!-- Trennen, da sonst nur oberste globale Regel greift -->
    <pattern id="metadata-2" see="http://wiki.l42.net/Thieme/3._XML-Bearbeitung/Buchaufbau/Titelei">
        <rule context="personid">
            <let name="value" value="."/>
            <report test=".[count(parent::*/*[.=$value])>1]">Die GP-Nummer <value-of select="."/> in <name/> wurde mehrfach verwendet. Bitte entfernen Sie das Duplikat</report>
        </rule>
        <rule context="materialid" role="Gültigkeit der Materialnummer prüfen">
            <report test=". = '1234560101'" role="warn">Die Materialnummer ist ungültig, da sie der Beispielnummer entspricht</report>
            <assert test="matches(., '^[0-9]{6,10}$') or string-length(.) = 0">Die Materialnummer muss aus einer sechs- bis zehnstelligen Zahl bestehen</assert>
        </rule>
        <rule context="isbn" role="Gültigkeit der ISBN-Nummer prüfen">
            <let name="checksum" value="number(substring(., string-length(), 1))"/>
            <let name="digits" value="for $i in reverse(string-to-codepoints(substring(., 1, string-length() -1))) return $i - 48"/>
            <let name="calculation" value="sum((for $i in $digits[(position()) mod 2 = 1] return $i * 3, for $i in $digits[(position()) mod 2 = 0] return $i)) mod 10"/>
            <report test="string-length(.) ne 13 or (if ($calculation ne 0) then (10 - $calculation) else 0) ne $checksum" role="warn">Die ISBN-Nummer hat eine ungültige Prüfziffer und sollte überprüft werden</report>
            <let name="value" value="."/>
            <report test="count(//isbn[text()=$value]) > 1" role="warn">Es ist mehrfach dieselbe ISBN definiert. Die Duplikate sollten gelöscht werden</report>
        </rule>
        <rule context="docdate" role="Gültigkeit des Datums prüfen">
            <assert test="matches(., '^([\d]{4})-(1[0-2]|0[1-9])-(3[0-1]|0[1-9]|[1-2][\d])$')" role="warn">Das Datum sollte auf JJJJ-MM-TT geändert werden, damit es ISO 8601 konform ist</assert>
        </rule>
    </pattern>

    <!-- Links prüfen -->
    <pattern see="http://wiki.l42.net/Thieme/3._XML_Grundlagen/Verlinkungen" id="links">
        <rule context="link" role="Gültigkeitsprüfungen für Links">
            <let name="id" value="@idref"/>
            <report role="warn" test="@target=('audio', 'figure', 'video') and not(//*[@id=$id]/name() = ('figure','subfigure'))">Dieser Link mit @target=<value-of select="@target"/> verweist auf <value-of select="//*[@id=$id]/name()"/> und nicht auf eine Abbildung. Das Ziel muss (sub-)figure sein</report>
            <report role="warn" test="@target=('box','formula','part','section','table') and not(//*[@id=$id]/name() = @target)">Dieser Link mit @target=<value-of select="@target"/> verweist auf <value-of select="//*[@id=$id]/name()"/>, muss aber auf <value-of select="@target"/> verweisen.</report>
            <report role="warn" test="@target='literature' and not(//*[@id=$id]/name() = ('literature','litref'))">Dieser Link mit @target=<value-of select="@target"/> verweist auf <value-of select="//*[@id=$id]/name()"/> und nicht auf eine Literaturstelle. Das Ziel muss literature oder litref sein</report>
            <report role="warn" test="@target='excursus' and not(//*[@id=$id]/name() = ('section'))">Dieser Link mit @target=<value-of select="@target"/> verweist auf <value-of select="//*[@id=$id]/name()"/> und nicht auf ein Kapitel. Das Ziel muss section sein</report>
            <report test="@target='page' and string-length(normalize-space(.)) = 0">Dieser Link muss echten Text beinhalten</report>
            <!-- TODO: Künftiges Linkhandling: Passt nicht mehr, da page überall hin verlinken muss, wenn es target nicht mehr gibt -->
            <!--<assert test="//target[@id=$id] or //section/title[@id=$id]">Das referenzierte Ziel muss entweder ein target oder ein Titel-Element sein.</assert>-->
            <assert test="@idref or @cmid" role="warn">Ein Link muss auf einen gültigen Zielanker verweisen, aber den Anker <value-of select="@idref"/> gibt es nicht</assert>
            <!-- Audio und Video auch prüfen, da in Templates wie Bilder behandelt = Alles was für Bilder zutrifft, trifft auch für audio und video zu -->
            <let name="id" value="@idref"/>
            <report test="@idref and (@target='figure' or @target='audio' or @target='video') and not(//figure[.//@id=$id]//legend)" role="warn">Der referenzierte Abbildungscontainer benötigt eine Legende (damit eine Abbildungsnummer generiert werden kann)</report>
            <report test="@target=('figure', 'table') and following-sibling::node()[1]/@target = 'page'">Laut Redaktionsrichtlinie darf einem Abbildungs- oder Tabellenverweis kein Seitenverweis folgen</report>
            <report test="@target=('figure', 'table') and string-length(normalize-space(following-sibling::node()[1]))&lt;5 and following-sibling::node()[2]/@target = 'page'">Laut Redaktionsrichtlinie darf einem Abbildungs- oder Tabellenverweis kein Seitenverweis folgen</report>
        </rule>
        <rule context="link/@idref" role="Gültigkeitsprüfungen für verlinkte Links">
            <report test="matches(.,'[^A-Za-z0-9:_\.\-]')">IDs dürfen keine Umlaute enthalten, da dies zu Problemen in EPUBs oder Webanwendungen führen könnte</report>
            <assert test=". = $ids" role="warn">Link <value-of select="."/> hat kein gültiges Ziel</assert>
        </rule>
        <rule context="uri" role="Uris prüfen">
            <assert test="@type='email' or matches(@href,'^(https?|ftp)://[^\s/$.?#].[^\s]*$')">Die angegebene URL ist nicht zulässig</assert>
            <report test="@type='email' and not(matches(@href,'^[^0-9][a-zA-Z0-9_\-]*([.][a-zA-Z0-9_\-]+)*[@][a-zA-Z0-9_\-]+([.][a-zA-Z0-9_\-]+)*[.][a-zA-Z]{2,4}$'))">Die angegebene E-Mail ist nicht zulässig</report>
        </rule>
        <rule context="target/@id" role="Linkziele ohne Quellen">
            <assert test=". = $idrefs" role="info">Ziel <value-of select="."/> wird nicht genutzt und kann gelöscht werden</assert>
            <report test="matches(.,'[^A-Za-z0-9:_\.\-]')">IDs dürfen keine Umlaute enthalten, da dies zu Problemen in EPUBs oder Webanwendungen führen könnte</report>
        </rule>
        <rule context="para/text() | emph/text() | footnote/text() | literature/text()" role="Text mit möglichen Uris">
            <report test="contains(.,'www.')">In diesem Absatz ist eine Webadresse nicht verlinkt. Damit Links anklickbar sind, müssen diese mit uri ausgezeichnet werden</report>
            <report role="warn" test="contains(.,'@')">Möglicherweise ist in diesem Absatz eine E-Mail-Adresse nicht verlinkt. Damit Links anklickbar sind, müssen diese mit uri ausgezeichnet werden</report>
        </rule>
        <rule context="figure | table">
            <assert test=".//@id = $idrefs" role="warn">Alle Abbildungen und Tabellen müssen verlinkt sein – diese ist es nicht.</assert>
        </rule>
    </pattern>

    <!-- Abbildungsprüfung -->
    <pattern see="http://wiki.l42.net/Thieme/3._XML-Bearbeitung/Abbildungen" id="figures">
        <rule context="@fileref" role="Gültigkeit der Abbildungslinks prüfen">
            <let name="file" value="f:new(resolve-uri(replace(., '[^a-zA-Z0-9_\-. ]',''), base-uri()))"/>
            <let name="file2" value="f:new(resolve-uri(concat($dir_fileref,replace(., '[^a-zA-Z0-9_\-. ]','')), base-uri()))"/>
            <report test="matches(., '[^a-zA-Z0-9_\-. ]')">Die Abbildung <value-of select="."/> enthält Sonderzeichen und kann nicht geprüft werden</report>
            <report test="matches(., '[A-Z ]')" role="warn">Die Abbildung <value-of select="."/> sollte keine Leerzeichen oder Großbuchstaben enthalten</report>
            <assert test="string-length() > 0">Sie müssen dieser Abbildung einen Dateinamen geben</assert>
            <assert test="f:exists($file) or f:exists($file2)" role="warn"> Abbildung <value-of select="."/> fehlt im Dateisystem</assert>
        </rule>
        <!-- Später mal in DTD aufnehmen; geht aktuell wegen cmids/cls nicht -->
        <rule context="video | audio" role="Audio/Video-IDs für QR-Code-Seiten prüfen">
            <assert test="@id">Das <name/>-Element muss eine ID beinhalten, damit es als Zusatzinhalt verlinkt werden kann</assert>
        </rule>
        <rule context="figure[count(subfigure)>1]/subfigure">
            <assert test="legend">Abbildungen mit mehr als einer Teilabbildung benötigen Teilabbildungslegenden</assert>
        </rule>
        <rule context="figure//para">
            <report test="@id">Bei Verweisen auf Abbildungen muss das (sub-)figure-Element genutzt werden</report>
        </rule>
    </pattern>

    <!-- Tabellenprüfung -->
    <pattern see="http://wiki.l42.net/Thieme/3._XML_Grundlagen/Tabellen" id="tables">
        <rule context="box/table">
            <assert test="@size='s'">Tabellen in Boxen müssen die Größe "s" haben (@size)</assert>
        </rule>
        <rule context="col" role="Prüfe auf gültigen col-Wert">
            <assert test="matches(@width,'^\d+(%|px|pt)?$')">Der col-Wert ist ungültig. Erlaubt sind nur Zahlen; optional mit den Einheiten %, px oder pt</assert>
        </rule>
        <rule context="table/thead" role="Prüfung auf Kopfzeile">
            <assert role="warn" test=".">Die Tabelle hat keine Kopfzeile. Bitte fügen Sie eine Kopfzeile mit dem thead-Element ein</assert>
        </rule>
        <rule context="table" see="http://wiki.l42.net/Thieme/4._Oxygen/Tabellen" role="Colspan-Überprüfung bei Tabellen">
            <let name="colsnr" value=".//col/number(replace(@width,'[^\d]',''))"/>
            
            <!-- colcount = tablecount -->
            <assert test="count(.//tr) * count(.//col) = sum(for $n in .//td return number(($n/@colspan, '1')[1]) * number(($n/@rowspan, '1')[1]))">Die Anzahl der Zellen ist ungültig. Bitte überprüfen sie die Anzahl der col-Elemente, sowie die Attribute @colspan und @rowspan</assert>
            <report test="count(distinct-values(.//col/replace(@width,'\d',''))) > 1">Es dürfen nur gleiche Einheiten in einer Tabelle verwendet werden.</report>
            <report test="max($colsnr) &gt; min($colsnr)*10" role="warn">Die Spaltenbreiten weisen extreme Verhältnisse auf und müssen überprüft werden</report>
        </rule>
    </pattern>

    <!-- Boxen überprüfen -->
    <pattern id="boxes" see="http://wiki.l42.net/Thieme/3._XML-Bearbeitung/Boxen">
        <rule context="box" role="Fehlerhafte Boxen">
            <assert role="info" test="title">Bitte vergeben Sie an diese Box (<value-of select="@type"/>) einen Titel mit dem Element title</assert>
            <report test="//box/(figure,table)[following-sibling::node()[name()]]" role="warn">Tabellen und Abbildungen in Boxen müssen am Ende der Box stehen</report>
        </rule>
    </pattern>

    <!-- TODO: Spätestens ab hier fehlen einige Links ins Wiki -->

    <!-- Leere Elemente -->
    <pattern id="emptyelements">
        <!-- TODO: Regel funktioniert nicht, wenn der Textnode nach einem anderen Node kommt... -->
        <!--<rule context="para[count(text()) = 1] | title[count(text()) = 1] | shorttitle[count(text()) = 1]" role="Elemente mit umgebendem Whitespace">
            <assert role="warn" test="replace(replace(text(),'\s+$',''),'^\s+','') = text()"><name/> enthält Leerzeichen zu Beginn oder am Ende des Elements</assert>
        </rule>-->
        <rule context="para|title|shorttitle">
            <report role="warn" test="starts-with(descendant::text()[1], ' ')">Whitespace zu Beginn von <name/></report>
            <report role="warn" test="ends-with(descendant::text()[last()], ' ')">Whitespace am Ende von <name/></report>
        </rule>
        <rule context="title">
            <report test="string-length(normalize-space(.)) = 0 and not(*)">Ein Titel darf nicht leer sein</report>
        </rule>
        <rule context="* [not(name()=('br','graphic','audio','video','col','concept','custom','td','th'))]" role="Leere Elemente auffinden">
            <report role="info" test="string-length(normalize-space(.)) = 0 and not(*)">Leeres Element <value-of select="name(.)"/></report>
        </rule>
    </pattern>

    <!-- Auszeichnungen -->
    <pattern id="emphasis">
        <rule context="emph" role="Prüfung der Auszeichnungen">
            <report role="warn" test=".[following-sibling::node()[1][name()='emph' and @type=preceding-sibling::*[1]/@type]]">An dieser Stelle können mehrere Auszeichnungen zusammengeführt werden</report>            
        	<report role="warn" test="string-length(normalize-space())=0">Es ist ein überflüssiges Auszeichnungselement vorhanden, das entfernt werden kann</report>
        </rule>
    </pattern>

    <!-- Document-Prüfungen -->
    <pattern id="document">
        <rule context="document[part]" role="Part-Prüfung">
            <assert test="count(//part[@type='frontmatter']) = 1">Es muss genau ein Frontmatter-Teil vorkommen</assert>
            <report test="count(//part[@type='content']) &lt; 1">Es muss mindestens ein Content-Teil vorkommen</report>
        </rule>
    </pattern>

    <!-- Part-Prüfungen -->
    <pattern id="part">
        <rule context="part[@type='frontmatter']/title" role="Frontmatter-Titelprüfung">
            <report role="warn" test=".">Der Frontmatter-Teil darf keinen Titel enthalten</report>
        </rule>
    </pattern>

    <!-- Section -->
    <pattern id="section">
        <rule context="section/section/section/section/section/section/section/section">
            <report test=".">Es dürfen nicht mehr als sieben Kapitelhierarchiestufen verwendet werden</report>
        </rule>
        <rule context="section[@level='x']" role="Prüfung des x-Levels">
            <report test=".//section[@level='x']">Das x-Level darf in einem Hierarchiepfad nur einmal verwendet werden</report>
        </rule>
        <!-- Laut hha: Gilt doch nicht? -->
        <!--<rule context="section">
            <report test="(literature, litref) and not(@type=('literature','bibliography'))">Diese Section muss den Typ 'literature' oder 'bibliography' besitzen</report>
        </rule>-->
    </pattern>

    <!-- title-Prüfung -->
    <pattern id="title">
        <rule context="title" role="Prüfung nach URLs im title">
            <report test="link, uri">Im Titel dürfen keine Links stehen</report>
        </rule>
        <rule context="section[count(ancestor-or-self::section) &lt; 3] | part" role="Prüfung der Titel-Länge eines Kapitels">
            <assert role="warn" test="string-length(normalize-space(string-join(title/text(),' '))) &lt; 51 or shorttitle">Dieser Titel ist als Kolumnentitel zu lang. Es sollte zusätzlich ein shorttitle angelegt werden</assert>
        </rule>
    </pattern>

    <!-- Absatzprüfung -->
    <pattern id="para">
        <rule context="section/section" role="Absatzprüfung">
            <assert role="warn" test="* except (title|shorttitle)">Dieses Kapitel ist leer</assert>
        </rule>
        <rule context="para" role="Paraprüfung">
            <report test="uri[@type='qrcode'] and count(descendant::node()) &gt; 1">Ein QR-Code link muss exklusiv in einem para stehen</report>
            <report role="warn" test="matches(.,'█|▒|░')">Die Blockade in diesem Absatz sollte aufgelöst werden</report>
            <report role="warn" test="matches(.,'HYPERLINK|REF _Ref')">In diesem Absatz ist möglicherweise ein defekter Verweis enthalten</report>
        </rule>
        <rule context="comment()">
            <report role="warn" test="matches(.,'Nicht identfizierbares Feld')">In diesem Absatz ist möglicherweise ein defekter Verweis enthalten</report>
        </rule>
    </pattern>
    
    <pattern id="recipe">
        <rule context="ingredient">
            <report role="warn" test="emph">Hierbei handelt es sich wahrscheinlich um eine Überschrift, diese muss als ingredients/title gesetzt werden</report>
        </rule>
    </pattern>

    <!-- deprecated-Elemente -->
    <pattern id="deprecated">
        <rule context="metaInfo | target | anaSection" role="Deprecated-Elemente">
            <report role="warn" test=".">Das Element <name/> sollte nicht mehr verwendet werden</report>
        </rule>
        <rule context="document">
            <!--Standardmäßig wird ein "document" auf oberster Ebene in "part"-Elemente untergliedert; auch bei nur einem "part", wird den "section"-Elementen ein "part"-Element vorgeschaltet.-->
            <report role="warn" test="section">Die Kombination document/section sollte nicht mehr verwendet werden. Bitte fügen Sie einen part ein.</report>
        </rule>
        <rule context="section">
            <report role="warn" test="@counter">Das @counter-Attribut sollte an <name/> nicht mehr verwendet werden</report>
            <report role="warn" test="number(@level) = (1 to 7)">@level sollte nicht mehr verwendet werden</report>
        </rule>
        <rule context="section/subtitle">
            <assert role="warn" test="preceding-sibling::*[1]/name() = ('title','titletranslated')">Subtitle darf nur noch direkt nach title verwendet werden</assert>
        </rule>
    </pattern>

    <!-- Listen -->
    <pattern id="listing">
        <rule context="listing//figure | listing//table | listing//box" role="Prüfung der Listenelemente">
            <report role="warn" test="."><name/> sollte wegen Darstellungsproblemen in Templates und Online-Applikationen nicht in Listen verwendet werden.</report>
        </rule>
        <rule context="listing" role="Prüfung der maximalen Ebenen">
            <report role="warn" test="litem/listing/litem/listing/litem/listing">Mehr als drei Ebenen sollten aufgrund von Darstellungsproblemen vermieden werden.</report>
        </rule>
    </pattern>

    <!-- Indexentry -->
    <pattern id="indexentry" see="http://wiki.l42.net/Thieme/3._XML-Bearbeitung/Indexmarken">
        <rule context="indexentry" role="Indexentry-Prüfung">
            <report role="warn" test="ends-with(preceding-sibling::node()[1][self::text()],' ') and starts-with(following-sibling::node()[1][self::text()],' ')">Mehr als ein Leerzeichen umgibt indexentry</report>
        </rule>
    </pattern>

    <!-- notInFont -->
    <pattern id="notinfont" see="http://wiki.l42.net/Thieme/z._Fehlersuche/Sonderzeichen">
        <rule context="notInFont" role="notInFont">
            <report role="info" test=".">Im Dokument sind notInFont-Elemente enthalten</report>
        </rule>
    </pattern>
    
    <!-- Kommentare -->
    <pattern id="comment">
        <rule context="processing-instruction('oxy_comment_start')" role="Oxygen-Kommentare">
            <report test="." role="info">Oxygen-Kommentare deuten auf eine unfertige XML-Datei hin.</report>        
        </rule>
        <rule context="comment()" role="XML-Kommentare">
            <report test="." role="info">XML-Kommentare deuten auf eine unfertige XML-Datei hin.</report>        
        </rule>
    </pattern>
</schema>