<!-- 
   Modul mit allen CLS Erweiterungen fuer Examen Online
   Alle spezifischen Elemente und Attribute, die in der kis-tvg und kis-basic 
   benutzt werden, sind hier definiert
   Diese Modul wurde fuer die KIS 2.0 neu geschaffen und war frueher ein Teil der KIS 1.x DTD
   
   Copyright (c) 2007-2012 Georg Thieme Verlag KG, Stuttgart
   Version 2.2.2 vom 08.04.2013
-->

<!--doc: Spezielle Metadaten für die Schwarze Reihe -->
<!--<!ELEMENT meta (metadata+) >-->
<!-- Die Art der Information wird ueber ein Attribut gesteuert, damit sich dieses Konstrukt leicht erweitern laesst -->
<!--<!ELEMENT metadata (#PCDATA)* >
<!ATTLIST  metadata
    type ( title | subject | company | category | keywords |
	       author | gk | gk_uk | examen_datum | examen_tag | frage_nr | frage_art | link | key_aktuell | 
           examen_fach | key_symptom | key_gkalt | key_gkneu | key_organ | key_erkrankung | key_sonstiges | 
           frage_typ | fach_mb | krankheiten_mb | symptome_mb | organe_mb | untersuchungen_mb ) #REQUIRED
   medilearn ( schwierigkeitsklasse | schwierigkeit | trennschaerfe | gekreuzt_a | gekreuzt_b | gekreuzt_c | gekreuzt_d | gekreuzt_e) #IMPLIED        
>-->

<!--doc: Markiert den Beginn einer Fallstudie, enthält aber nur die Metadaten zur Fallstudie inklusive der Verlinkungen zu den einzelnen Fragen-->
<!ELEMENT case (meta, relQblockIo+ ) >
<!-- CLS-Elemente für Verlinkungen -->
<!ELEMENT relQblockIo (#PCDATA) >
<!ATTLIST relQblockIo
   fileref CDATA  #IMPLIED
   %id.attrib;
>

<!--doc: Sonderumgebung für Prüfungsfragen, die eine gesamte Frage mit Antwort, Lösung und Kommentar klammert -->
<!ELEMENT qblock (qtitle?, meta, qti?, relQtiIo+, answer? ,comment?, box*) >
<!ATTLIST qblock 
        %id.attrib;>
<!-- Titel der Frage -->
<!ELEMENT qtitle (#PCDATA) >

<!ELEMENT relQtiIo (#PCDATA) >
<!ATTLIST relQtiIo
   fileref CDATA  #IMPLIED 
   %id.attrib;
>
<!--doc: Klammert Frage, Antwortoptionen und Lösung; war ursprünglich gemäß dem QTI-Standard für eLearning strukturiert -->
<!ELEMENT qti (response?, qbody) >
<!ATTLIST qti   %id.attrib;>

<!--doc: Der Buchstabe der korrekten Lösung -->
<!ELEMENT response (#PCDATA)* >

<!--doc: Die eigentliche Frage, bestehend aus Absätzen, Listen, Formeln, Abbildungen, Tabellen und den Antwortoptionen -->
<!ELEMENT qbody ((para | listing  | table | formula | figure | embed-figure)+, choices?) >

<!--doc: Klammert die Antwortoptionen -->
<!ELEMENT choices (choice)+ >

<!--doc: Einzelne Antwortoption -->
<!ELEMENT choice (%inline;)* >
<!ATTLIST choice
    value (A|B|C|D|E) #IMPLIED
>
<!--doc: Antwort zu einer Freitextfrage -->
<!ELEMENT answer (para | listing  | table | formula | figure | embed-figure)+ >
<!ATTLIST answer   %id.attrib;
>
<!--doc: Kommentar zu einer Frage, klammert den Kommentarblock -->
<!ELEMENT comment (para | listing  | table | formula | figure | embed-figure)+ >
<!ATTLIST comment   %id.attrib;
>
<!-- CLS spezifisches Element embed-section -->
<!ELEMENT embed-qblock (qblock)*>
<!ATTLIST embed-qblock %id.attrib;>
